/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_8_R2;

import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import net.minecraft.server.v1_8_R2.DataWatcher;
import net.minecraft.server.v1_8_R2.Packet;
import net.minecraft.server.v1_8_R2.PacketDataSerializer;

class PacketDataSerializerWrapper {
    private static final ThreadLocal<PacketDataSerializerWrapper> LOCAL_INSTANCE = ThreadLocal.withInitial(PacketDataSerializerWrapper::new);
    private final PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());

    private PacketDataSerializerWrapper() {
    }

    void writeToPacket(Packet<?> packet) {
        try {
            packet.a(this.serializer);
        }
        catch (IOException e) {
            throw new DecentHologramsNmsException("Failed to write data to packet", e);
        }
    }

    void clear() {
        this.serializer.clear();
    }

    void writeInt(int value) {
        this.serializer.writeInt(value);
    }

    void writeVarInt(int value) {
        this.serializer.b(value);
    }

    void writeShort(int value) {
        this.serializer.writeShort(value);
    }

    void writeByte(int value) {
        this.serializer.writeByte(value);
    }

    void writeWatchableObjects(List<DataWatcher.WatchableObject> watchableObjects) {
        try {
            DataWatcher.a(watchableObjects, (PacketDataSerializer)this.serializer);
        }
        catch (IOException e) {
            throw new DecentHologramsNmsException("Failed to write watchable objects", e);
        }
    }

    static PacketDataSerializerWrapper getInstance() {
        PacketDataSerializerWrapper instance = LOCAL_INSTANCE.get();
        instance.clear();
        return instance;
    }
}

