/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.plugin;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.commands.CommandManager;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.hook.NbtApiHook;
import eu.decentsoftware.holograms.plugin.commands.HologramsCommand;
import eu.decentsoftware.holograms.plugin.features.DamageDisplayFeature;
import eu.decentsoftware.holograms.plugin.features.HealingDisplayFeature;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DecentHologramsPlugin
extends JavaPlugin {
    private boolean unsupportedServerVersion = false;

    public void onLoad() {
        if (Version.CURRENT == null) {
            this.unsupportedServerVersion = true;
            return;
        }
        DecentHologramsAPI.onLoad(this);
    }

    public void onEnable() {
        if (this.unsupportedServerVersion) {
            this.getLogger().severe("Unsupported server version detected: " + Bukkit.getServer().getVersion());
            this.getLogger().severe("Plugin will now be disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DecentHologramsAPI.onEnable();
        DecentHolograms decentHolograms = DecentHologramsAPI.get();
        decentHolograms.getFeatureManager().registerFeature(new DamageDisplayFeature());
        decentHolograms.getFeatureManager().registerFeature(new HealingDisplayFeature());
        CommandManager commandManager = decentHolograms.getCommandManager();
        HologramsCommand mainCommand = new HologramsCommand();
        commandManager.setMainCommand(mainCommand);
        commandManager.registerCommand(mainCommand);
        NbtApiHook.initialize();
    }

    public void onDisable() {
        if (this.unsupportedServerVersion) {
            return;
        }
        DecentHologramsAPI.onDisable();
    }
}

