/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.plugin.features;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.features.AbstractFeature;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import eu.decentsoftware.holograms.api.utils.location.LocationUtils;
import eu.decentsoftware.holograms.plugin.features.FeatureCommons;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class DamageDisplayFeature
extends AbstractFeature
implements Listener {
    private static final DecentHolograms PLUGIN = DecentHologramsAPI.get();
    private int duration = 40;
    private String appearance = "&c{damage}";
    private String criticalAppearance = "&4&lCrit!&4 {damage}";
    private boolean displayForPlayers = true;
    private boolean displayForMobs = true;
    private boolean zeroDamage = false;
    private double heightOffset = 0.0;

    public DamageDisplayFeature() {
        super("damage_display");
        this.reload();
    }

    @Override
    public void reload() {
        this.disable();
        FileConfig config = Settings.getConfig();
        this.enabled = config.getBoolean("damage-display.enabled", this.enabled);
        this.duration = config.getInt("damage-display.duration", this.duration);
        this.appearance = config.getString("damage-display.appearance", this.appearance);
        this.criticalAppearance = config.getString("damage-display.critical-appearance", this.criticalAppearance);
        this.heightOffset = config.getDouble("damage-display.height", this.heightOffset);
        this.displayForPlayers = config.getBoolean("damage-display.players", this.displayForPlayers);
        this.displayForMobs = config.getBoolean("damage-display.mobs", this.displayForMobs);
        this.zeroDamage = config.getBoolean("damage-display.zero-damage", this.zeroDamage);
        if (this.enabled) {
            this.enable();
        }
    }

    @Override
    public void enable() {
        JavaPlugin javaPlugin = PLUGIN.getPlugin();
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        this.enabled = true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.enabled = false;
    }

    @Override
    public void destroy() {
        this.disable();
    }

    @Override
    public String getDescription() {
        return "Spawn a temporary hologram displaying damage.";
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        double damage = e.getFinalDamage();
        if (damage <= 0.0 && !this.zeroDamage) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity) || entity instanceof ArmorStand) {
            return;
        }
        if (entity instanceof Player && !this.displayForPlayers) {
            return;
        }
        if (!(entity instanceof Player) && !this.displayForMobs) {
            return;
        }
        Location location = LocationUtils.randomizeLocation(entity.getLocation().clone().add(0.0, 1.0 + this.heightOffset, 0.0));
        Entity damager = e instanceof EntityDamageByEntityEvent ? ((EntityDamageByEntityEvent)e).getDamager() : null;
        String currentAppearance = damager instanceof Player && this.isCritical((Player)damager) ? this.criticalAppearance : this.appearance;
        String text = currentAppearance.replace("{damage}", FeatureCommons.formatNumber(damage));
        PLUGIN.getHologramManager().spawnTemporaryHologramLine(location, text, this.duration);
    }

    private boolean isCritical(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (player.getFallDistance() <= 0.0f || player.isOnGround() || player.isInsideVehicle() || player.hasPotionEffect(PotionEffectType.BLINDNESS) || player.getLocation().getBlock().getType() == Material.LADDER || player.getLocation().getBlock().getType() == Material.VINE) {
            return false;
        }
        try {
            if (player.hasPotionEffect(PotionEffectType.getByName((String)"SLOW_FALLING"))) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

