/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves;

import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import org.browsit.seaofsteves.command.SosExecutor;
import org.browsit.seaofsteves.depend.Dependencies;
import org.browsit.seaofsteves.expansion.SOSExpansion;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.listener.BlockListener;
import org.browsit.seaofsteves.listener.EntityListener;
import org.browsit.seaofsteves.listener.MythicListener;
import org.browsit.seaofsteves.listener.PlayerListener;
import org.browsit.seaofsteves.listener.ProjectileListener;
import org.browsit.seaofsteves.listener.VehicleListener;
import org.browsit.seaofsteves.player.Pirate;
import org.browsit.seaofsteves.settings.BossSettings;
import org.browsit.seaofsteves.settings.ChanceSettings;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.timer.ResetTimer;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SeaOfSteves
extends JavaPlugin {
    private Dependencies depends;
    private BossSettings boss;
    private ChanceSettings chance;
    private ConfigSettings config;
    private GearSettings gear;
    private FoliaLib foliaLib;
    private ResetTimer timer;
    private final Collection<Pirate> pirates = new ConcurrentSkipListSet<Pirate>();

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().setHeader(Collections.singletonList("Configuration file for SeaOfSteves plugin"));
        this.saveConfig();
        try {
            IO.save(this, "boss.yml");
            IO.save(this, "gear.yml");
            IO.save(this, "strings.yml");
            IO.save(this, "chance.yml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            IO.load(this, "boss.yml");
            IO.load(this, "gear.yml");
            IO.load(this, "strings.yml");
            IO.load(this, "chance.yml");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.reloadAllSettings();
        this.depends = new Dependencies(this);
        this.foliaLib = new FoliaLib((Plugin)this);
        PluginCommand command = this.getCommand("sos");
        if (command != null) {
            command.setExecutor((CommandExecutor)new SosExecutor(this));
        }
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VehicleListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        if (this.getDependencies().isPluginAvailable("MythicMobs")) {
            this.getServer().getPluginManager().registerEvents((Listener)new MythicListener(this), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ProjectileListener(this), (Plugin)this);
        if (this.getDependencies().isPluginAvailable("PlaceholderAPI")) {
            new SOSExpansion(this).register();
        }
        this.timer = new ResetTimer(this);
        this.timer.run();
        if (this.depends.getMythicMobs() != null) {
            this.getLogger().info("Overwriting conflicting VOTSSpawnControlers skill, if present");
            Optional opt = this.getDependencies().getMythicMobs().getSkillManager().getSkill("VOTSSpawnControlers");
            if (opt.isPresent()) {
                Skill toRemove = (Skill)opt.get();
                this.getDependencies().getMythicMobs().getSkillManager().getSkills().remove(toRemove);
            }
        }
    }

    public void onDisable() {
        int count = 0;
        if (this.getDependencies().isPluginAvailable("MythicMobs")) {
            for (ActiveMob am : this.getDependencies().getMythicMobs().getMobManager().getActiveMobs()) {
                if (!WorldUtil.isAllowedWorld(am.getLocation().getWorld().getName())) continue;
                am.despawn();
                ++count;
            }
        }
        this.getLogger().info("Despawned " + count + " mythic mobs in allowed world(s)");
    }

    public Dependencies getDependencies() {
        return this.depends;
    }

    public BossSettings getBossSettings() {
        return this.boss;
    }

    public ChanceSettings getChanceSettings() {
        return this.chance;
    }

    public ConfigSettings getConfigSettings() {
        return this.config;
    }

    public GearSettings getGearSettings() {
        return this.gear;
    }

    public void reloadAllSettings() {
        this.config = new ConfigSettings(this);
        this.config.load();
        this.gear = new GearSettings(this);
        this.gear.load();
        this.chance = new ChanceSettings(this);
        this.chance.load();
        this.boss = new BossSettings(this);
        this.boss.load();
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public ResetTimer getResetTimer() {
        return this.timer;
    }

    public Collection<Pirate> getAllPirates() {
        return this.pirates;
    }

    @NotNull
    public Pirate getPirate(UUID uniqueId) {
        for (Pirate pirate : this.getAllPirates()) {
            if (!pirate.getUniqueId().equals(uniqueId)) continue;
            return pirate;
        }
        this.addPirate(new Pirate(uniqueId));
        return this.getPirate(uniqueId);
    }

    public void addPirate(Pirate pirate) {
        this.pirates.add(pirate);
    }

    public void removePirate(Pirate pirate) {
        this.pirates.remove(pirate);
    }
}

