/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.boss.lavablock;

import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.boss.lavablock.EffectTask;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.libs.folialib.wrapper.task.WrappedTask;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Silverfish;
import org.bukkit.inventory.ItemStack;
import org.joml.Matrix4f;

public class Tephra {
    private static FoliaLib foliaLib;
    private final ConfigSettings config;
    private final Location target;
    private final Entity vehicle;
    private final Display tephra;
    private final WrappedTask effects;

    public Tephra(SeaOfSteves plugin, Location target) {
        foliaLib = plugin.getFoliaLib();
        this.config = plugin.getConfigSettings();
        this.target = target;
        this.vehicle = this.initVehicle();
        this.tephra = this.initTephra();
        this.effects = foliaLib.getScheduler().runAtEntityTimer((Entity)this.tephra, new EffectTask(plugin, this.vehicle, this.tephra, target), 4L, 4L);
    }

    private Entity initVehicle() {
        if (this.target.getWorld() == null) {
            return null;
        }
        Silverfish vehicle = (Silverfish)this.target.getWorld().spawn(this.target.clone().add(0.0, (double)this.config.getEruptionStartHeight(), 0.0), Silverfish.class);
        vehicle.setInvisible(true);
        vehicle.setInvulnerable(true);
        return vehicle;
    }

    private Display initTephra() {
        if (this.target.getWorld() == null || this.vehicle == null) {
            return null;
        }
        ItemDisplay display = (ItemDisplay)this.target.getWorld().spawn(this.target.clone().add(0.0, (double)this.config.getEruptionStartHeight(), 0.0), ItemDisplay.class);
        display.setPersistent(false);
        display.setItemStack(new ItemStack(Material.valueOf((String)this.config.getEruptionMaterial())));
        display.setInvulnerable(true);
        display.setBrightness(new Display.Brightness(15, 15));
        this.beginRotation((Display)display);
        this.vehicle.addPassenger((Entity)display);
        return display;
    }

    private void beginRotation(Display display) {
        int duration = 60;
        Matrix4f mat = new Matrix4f().scale(3.0f);
        foliaLib.getScheduler().runAtEntityTimer((Entity)display, task -> {
            if (!display.isValid()) {
                this.effects.cancel();
                task.cancel();
                return;
            }
            display.setTransformationMatrix(mat.rotateY((float)Math.toRadians(180.0) + 0.1f));
            display.setInterpolationDelay(0);
            display.setInterpolationDuration(60);
        }, 2L, 60L);
    }

    public Location getTarget() {
        return this.target;
    }

    public Display getTephra() {
        return this.tephra;
    }

    public Entity getVehicle() {
        return this.vehicle;
    }

    public WrappedTask getEffectTask() {
        return this.effects;
    }
}

