/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.depend;

import com.codisimus.plugins.phatloots.PhatLoots;
import com.dfsek.terra.bukkit.TerraBukkitPlugin;
import com.oheers.fish.api.plugin.EMFPlugin;
import com.onarandombox.MultiverseCore.MultiverseCore;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythiccrucible.MythicCrucible;
import java.util.Objects;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.browsit.seaofsteves.SeaOfSteves;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Dependencies {
    private final SeaOfSteves plugin;
    private static Economy economy = null;
    private static EMFPlugin evenMoreFish = null;
    private static MultiverseCore multiverse = null;
    private static Permission permission = null;
    private static PhatLoots phatLoots = null;
    private static PlaceholderAPIPlugin placeholderApi = null;
    private static MythicBukkit mythicMobs = null;
    private static MythicCrucible mythicCrucible = null;
    private static TerraBukkitPlugin terra = null;
    public static boolean isVotsPresent = false;

    public Dependencies(SeaOfSteves plugin) {
        this.plugin = plugin;
    }

    public Economy getVaultEconomy() {
        if (economy == null && this.isPluginAvailable("Vault") && !this.setupEconomy()) {
            this.plugin.getLogger().warning("Economy provider not found.");
        }
        return economy;
    }

    public Permission getVaultPermission() {
        if (permission == null && this.isPluginAvailable("Vault") && !this.setupPermissions()) {
            this.plugin.getLogger().warning("Permission provider not found.");
        }
        return permission;
    }

    public EMFPlugin getEvenMoreFish() {
        if (evenMoreFish == null && this.isPluginAvailable("EvenMoreFish")) {
            evenMoreFish = EMFPlugin.getInstance();
        }
        return evenMoreFish;
    }

    public MultiverseCore getMultiverseCore() {
        if (multiverse == null && this.isPluginAvailable("Multiverse-Core")) {
            multiverse = (MultiverseCore)this.plugin.getServer().getPluginManager().getPlugin("Multiverse-Core");
        }
        return multiverse;
    }

    public MythicCrucible getMythicCrucible() {
        if (mythicCrucible == null && this.isPluginAvailable("MythicCrucible")) {
            mythicCrucible = MythicCrucible.inst();
        }
        return mythicCrucible;
    }

    public MythicBukkit getMythicMobs() {
        if (mythicMobs == null && this.isPluginAvailable("MythicMobs")) {
            mythicMobs = MythicBukkit.inst();
            ItemStack itemStack = mythicMobs.getItemManager().getItemStack("VOTSDirectionControler");
        }
        return mythicMobs;
    }

    public boolean isVotsPresent() {
        if (this.getMythicMobs() != null && this.plugin.getConfigSettings().getVotsShips().isEmpty()) {
            this.plugin.getLogger().severe("Config 'vots.ships' cannot be empty, even if not enabled");
            return false;
        }
        String skill = "VOTS" + String.valueOf(this.plugin.getConfigSettings().getVotsShips().toArray()[0]) + "Summon";
        Optional opt = mythicMobs.getSkillManager().getSkill(skill);
        if (opt.isPresent()) {
            isVotsPresent = true;
        } else {
            isVotsPresent = false;
            this.plugin.getLogger().info("Skill not found in config (check capitalization): " + skill);
        }
        return isVotsPresent;
    }

    public PhatLoots getPhatLoots() {
        if (phatLoots == null && this.isPluginAvailable("PhatLoots")) {
            phatLoots = (PhatLoots)this.plugin.getServer().getPluginManager().getPlugin("PhatLoots");
        }
        return phatLoots;
    }

    public PlaceholderAPIPlugin getPlaceholderApi() {
        if (placeholderApi == null && this.isPluginAvailable("PlaceholderAPI")) {
            placeholderApi = (PlaceholderAPIPlugin)this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        }
        return placeholderApi;
    }

    public TerraBukkitPlugin getTerra() {
        if (terra == null && this.isPluginAvailable("Terra")) {
            terra = (TerraBukkitPlugin)this.plugin.getServer().getPluginManager().getPlugin("Terra");
        }
        return terra;
    }

    public boolean isPluginAvailable(String pluginName) {
        if (this.plugin.getServer().getPluginManager().getPlugin(pluginName) != null) {
            try {
                if (Objects.requireNonNull(this.plugin.getServer().getPluginManager().getPlugin(pluginName)).isEnabled()) {
                    return true;
                }
                this.plugin.getLogger().warning(pluginName + " was detected, but is not enabled! Fix " + pluginName + " to allow linkage.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean setupEconomy() {
        try {
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                economy = (Economy)rsp.getProvider();
            }
            return economy != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            permission = (Permission)rsp.getProvider();
        }
        return permission != null;
    }
}

