/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.gear.type.boat;

import java.util.List;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.gear.PirateGear;
import org.browsit.seaofsteves.util.ItemUtil;
import org.browsit.seaofsteves.util.NBTAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PirateFireball
implements PirateGear {
    public static SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");
    private static final Material material = Material.FIRE_CHARGE;
    private static final String display = ItemUtil.getGearDisplay(PirateFireball.class);
    private static final List<String> lore = ItemUtil.getGearLore(PirateFireball.class);

    public static ItemStack get(Player player) {
        ItemStack is;
        String mythic = plugin.getGearSettings().getFireballMythic();
        if (!mythic.equals("NAME_OF_ITEM_TO_USE_INSTEAD") && plugin.getDependencies().getMythicMobs() != null && (is = plugin.getDependencies().getMythicMobs().getItemManager().getItemStack(mythic)) != null) {
            return is;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(display);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        NBTAPI.addNBT(item, "sos_owner", player.getUniqueId().toString());
        NBTAPI.addNBT(item, "sos_world", player.getWorld().getUID().toString());
        return item;
    }

    public static boolean equals(ItemStack itemStack) {
        String mythic = plugin.getGearSettings().getFireballMythic();
        if (!mythic.equals("NAME_OF_ITEM_TO_USE_INSTEAD") && plugin.getDependencies().getMythicMobs() != null && plugin.getDependencies().getMythicMobs().getItemManager().isMythicItem(itemStack)) {
            ItemStack is = plugin.getDependencies().getMythicMobs().getItemManager().getItemStack(mythic);
            return is.isSimilar(itemStack);
        }
        if (itemStack.getType().equals((Object)material)) {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null) {
                return false;
            }
            return meta.getDisplayName().equals(display) && NBTAPI.hasNBT(itemStack, "sos_owner");
        }
        return false;
    }
}

