/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.abstraction.v1_21_R5;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.browsit.seaofsteves.libs.mobchip.EntityBody;
import org.browsit.seaofsteves.libs.mobchip.abstraction.ChipUtil;
import org.browsit.seaofsteves.libs.mobchip.abstraction.v1_21_R5.ChipUtil1_21_R5;
import org.browsit.seaofsteves.libs.mobchip.ai.animation.EntityAnimation;
import org.browsit.seaofsteves.libs.mobchip.util.Position;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EntityBody1_21_R5
implements EntityBody {
    private final EntityInsentient nmsMob;
    private final Mob m;

    public EntityBody1_21_R5(Mob m) {
        this.m = m;
        this.nmsMob = ChipUtil1_21_R5.toNMS(m);
    }

    private void update() {
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(this.nmsMob.ar(), this.nmsMob.au().b());
        for (Player p : this.m.getWorld().getPlayers()) {
            ((CraftPlayer)p).getHandle().g.b((Packet)packet);
        }
    }

    @Override
    public boolean isLeftHanded() {
        return this.nmsMob.gx();
    }

    @Override
    public void setLeftHanded(boolean leftHanded) {
        this.nmsMob.v(leftHanded);
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.nmsMob.ek();
    }

    @Override
    public boolean shouldDiscardFriction() {
        return this.nmsMob.eC();
    }

    @Override
    public void setDiscardFriction(boolean discard) {
        this.nmsMob.r(discard);
    }

    @Override
    public EntityBody.InteractionResult interact(@NotNull Player p, @Nullable EntityBody.InteractionHand hand) {
        EnumHand h = hand == EntityBody.InteractionHand.OFF_HAND ? EnumHand.b : EnumHand.a;
        EnumInteractionResult result = this.nmsMob.a((EntityHuman)ChipUtil1_21_R5.toNMS(p), h);
        if (result == EnumInteractionResult.d) {
            return EntityBody.InteractionResult.FAIL;
        }
        if (result == EnumInteractionResult.c) {
            return EntityBody.InteractionResult.CONSUME;
        }
        if (result == EnumInteractionResult.e) {
            return EntityBody.InteractionResult.PASS;
        }
        return EntityBody.InteractionResult.SUCCESS;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.nmsMob.fx();
    }

    @Override
    public boolean isAffectedByPotions() {
        return this.nmsMob.fS();
    }

    @Override
    public boolean isBlocking() {
        return this.nmsMob.fN();
    }

    @Override
    public float getArmorCoverPercentage() {
        return this.nmsMob.fj();
    }

    @Override
    public void useItem(@Nullable EntityBody.InteractionHand hand) {
        if (hand == null) {
            return;
        }
        EnumHand h = hand == EntityBody.InteractionHand.OFF_HAND ? EnumHand.b : EnumHand.a;
        this.nmsMob.c(h);
    }

    @Override
    public boolean isUsingItem() {
        return this.nmsMob.fG();
    }

    @Override
    public boolean isFireImmune() {
        return this.nmsMob.bl();
    }

    @Override
    public boolean isSwinging() {
        return this.nmsMob.be;
    }

    @Override
    public boolean canRideUnderwater() {
        return false;
    }

    @Override
    public boolean isInvisibleTo(@Nullable Player p) {
        return this.nmsMob.f((EntityHuman)ChipUtil1_21_R5.toNMS(p));
    }

    @Override
    @NotNull
    public EntityBody.InteractionHand getMainHand() {
        if (this.nmsMob.fF() == EnumMainHand.a) {
            return EntityBody.InteractionHand.OFF_HAND;
        }
        return EntityBody.InteractionHand.MAIN_HAND;
    }

    @Override
    public List<ItemStack> getDefaultDrops() {
        return this.nmsMob.drops;
    }

    @Override
    public void setDefaultDrops(ItemStack ... drops) {
        this.nmsMob.drops = new ArrayList<ItemStack>(Arrays.asList(drops));
    }

    @Override
    public boolean isInCombat() {
        try {
            Field inCombatF = CombatTracker.class.getDeclaredField("i");
            inCombatF.setAccessible(true);
            return inCombatF.getBoolean(this.nmsMob.cd);
        }
        catch (ReflectiveOperationException e) {
            ChipUtil.printStackTrace(e);
            return false;
        }
    }

    @Override
    public float getFlyingSpeed() {
        return 0.0f;
    }

    @Override
    public void setFlyingSpeed(float speed) throws IllegalArgumentException {
    }

    @Override
    public boolean isForcingDrops() {
        return this.nmsMob.forceDrops;
    }

    @Override
    public void setForcingDrops(boolean drop) {
        this.nmsMob.forceDrops = drop;
    }

    @Override
    public boolean isMoving() {
        double z;
        double x = this.nmsMob.dC() - this.nmsMob.X;
        return x * x + (z = this.nmsMob.dI() - this.nmsMob.Z) * z > 2.500000277905201E-7;
    }

    @Override
    public float getBodyRotation() {
        return this.nmsMob.br;
    }

    @Override
    public void setBodyRotation(float rotation) {
        this.nmsMob.br = EntityBody.normalizeRotation(rotation);
    }

    @Override
    public float getHeadRotation() {
        return this.nmsMob.bt;
    }

    @Override
    public void setHeadRotation(float rotation) {
        this.nmsMob.bt = EntityBody.normalizeRotation(rotation);
    }

    @Override
    public Set<? extends Entity> getCollideExemptions() {
        return this.nmsMob.collidableExemptions.stream().map(Bukkit::getEntity).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void addCollideExemption(@NotNull Entity en) throws IllegalArgumentException {
        if (en == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        this.nmsMob.collidableExemptions.add(en.getUniqueId());
    }

    @Override
    public void removeCollideExemption(@NotNull Entity en) throws IllegalArgumentException {
        if (en == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        this.nmsMob.collidableExemptions.remove(en.getUniqueId());
    }

    @Override
    public int getDroppedExperience() {
        return this.nmsMob.expToDrop;
    }

    @Override
    public void setDroppedExperience(int exp) throws IllegalArgumentException {
        if (exp < 0) {
            throw new IllegalArgumentException("Experience cannot be negative");
        }
        this.nmsMob.expToDrop = exp;
    }

    @Override
    public void playAnimation(@NotNull EntityAnimation anim) {
        switch (anim) {
            case SPAWN: {
                this.nmsMob.Y();
                break;
            }
            case DAMAGE: {
                this.nmsMob.q(1.0f);
                break;
            }
            case CRITICAL_DAMAGE: {
                PacketPlayOutAnimation pkt = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)this.nmsMob, 4);
                for (Player p : ChipUtil1_21_R5.fromNMS(this.nmsMob).getWorld().getPlayers()) {
                    ChipUtil1_21_R5.toNMS((Player)p).g.b((Packet)pkt);
                }
                break;
            }
            case MAGICAL_CRITICAL_DAMAGE: {
                PacketPlayOutAnimation pkt = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)this.nmsMob, 5);
                for (Player p : ChipUtil1_21_R5.fromNMS(this.nmsMob).getWorld().getPlayers()) {
                    ChipUtil1_21_R5.toNMS((Player)p).g.b((Packet)pkt);
                }
                break;
            }
        }
    }

    @Override
    public float getAnimationSpeed() {
        return 0.0f;
    }

    @Override
    public void setAnimationSpeed(float speed) throws IllegalArgumentException {
    }

    @Override
    public boolean hasVerticalCollision() {
        return this.nmsMob.ad;
    }

    @Override
    public void setVerticalCollision(boolean collision) {
        this.nmsMob.ad = collision;
    }

    @Override
    public boolean hasHorizontalCollision() {
        return this.nmsMob.ac;
    }

    @Override
    public void setHorizontalCollision(boolean collision) {
        this.nmsMob.ac = collision;
    }

    @Override
    public float getWalkDistance() {
        return this.nmsMob.ak;
    }

    @Override
    public float getMoveDistance() {
        return this.nmsMob.ak;
    }

    @Override
    public float getFlyDistance() {
        return this.nmsMob.al;
    }

    @Override
    public boolean isImmuneToExplosions() {
        return this.nmsMob.a(null);
    }

    @Override
    public boolean isPeacefulCompatible() {
        try {
            Method m = EntityInsentient.class.getDeclaredMethod("Q", new Class[0]);
            m.setAccessible(true);
            return (Boolean)m.invoke((Object)this.nmsMob, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isInBubbleColumn() {
        return this.nmsMob.ai().a_(this.nmsMob.dx()).a(Blocks.nK);
    }

    @Override
    public boolean isInvulnerableTo(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityDamageEvent.DamageCause cause) {
        return this.nmsMob.a(this.nmsMob.ai().getMinecraftWorld(), ChipUtil1_21_R5.toNMS(cause, (Entity)this.m));
    }

    @Override
    public int getMaxFallDistance() {
        return this.nmsMob.cI();
    }

    @Override
    public boolean isPushableBy(@Nullable Entity entity) {
        return IEntitySelector.a((net.minecraft.world.entity.Entity)ChipUtil1_21_R5.toNMS(entity)).test(ChipUtil1_21_R5.toNMS(entity));
    }

    @Override
    public float getYaw() {
        return this.nmsMob.dP();
    }

    @Override
    public void setYaw(float rotation) {
        this.nmsMob.v(EntityBody.normalizeRotation(rotation));
    }

    @Override
    public float getPitch() {
        return this.nmsMob.dR();
    }

    @Override
    public void setPitch(float rotation) {
        this.nmsMob.w(EntityBody.normalizeRotation(rotation));
    }

    @Override
    public float getMaxUpStep() {
        return this.nmsMob.dT();
    }

    @Override
    public void setMaxUpStep(float maxUpStep) {
        this.nmsMob.fg().a(GenericAttributes.C).a((double)maxUpStep);
    }

    @Override
    public Position getLastLavaContact() {
        BlockPosition p = this.nmsMob.lastLavaContact;
        if (p == null) {
            return null;
        }
        return new Position(p.u(), p.v(), p.w());
    }

    @Override
    public void setRiptideTicks(int ticks) {
        block4: {
            if (ticks < 0) {
                throw new IllegalArgumentException("Riptide ticks cannot be negative");
            }
            try {
                Field f = EntityLiving.class.getDeclaredField("bC");
                f.setAccessible(true);
                f.setInt(this.nmsMob, ticks);
                if (this.nmsMob.ai().C) break block4;
                Method setFlags = EntityLiving.class.getDeclaredMethod("c", Integer.TYPE, Boolean.TYPE);
                setFlags.setAccessible(true);
                setFlags.invoke((Object)this.nmsMob, 4, true);
            }
            catch (ReflectiveOperationException e) {
                Bukkit.getLogger().severe(e.getMessage());
                for (StackTraceElement ste : e.getStackTrace()) {
                    Bukkit.getLogger().severe(ste.toString());
                }
            }
        }
        this.update();
    }

    @Override
    public int getRiptideTicks() {
        try {
            Field f = EntityLiving.class.getDeclaredField("bC");
            f.setAccessible(true);
            return f.getInt(this.nmsMob);
        }
        catch (ReflectiveOperationException e) {
            return 0;
        }
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return this.m;
    }

    @Override
    public boolean shouldRenderFrom(double x, double y, double z) {
        return this.nmsMob.j(x, y, z);
    }

    @Override
    public boolean shouldRenderFromSqr(double dist) {
        return this.nmsMob.a(dist);
    }

    @Override
    public void sendTo(@NotNull Player p) {
        PlayerChunkMap.EntityTracker tracked = (PlayerChunkMap.EntityTracker)((WorldServer)this.nmsMob.ai()).n().a.L.get(this.nmsMob.ar());
        Packet packet = this.nmsMob.a(tracked.b);
        ((CraftPlayer)p).getHandle().g.b(packet);
    }

    @Override
    public void resetFallDistance() {
        this.nmsMob.j();
    }

    @Override
    public boolean isInUnloadedChunk() {
        return this.nmsMob.dq();
    }

    @Override
    public void naturalKnockback(double force, double xForce, double zForce) {
        this.nmsMob.p(force, xForce, zForce);
    }

    @Override
    public void eat(@NotNull ItemStack item) {
        this.nmsMob.ai().a(null, this.nmsMob.dC(), this.nmsMob.dE(), this.nmsMob.dI(), (Holder)SoundEffects.kQ, this.nmsMob.do(), 1.0f, 1.0f);
        this.nmsMob.c((Holder)GameEvent.m);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        try {
            if (this.m instanceof Slime) {
                ControllerMove moveControl = this.nmsMob.Q();
                Method setRotation = moveControl.getClass().getDeclaredMethod("a", Float.TYPE, Boolean.TYPE);
                setRotation.setAccessible(true);
                setRotation.invoke((Object)moveControl, Float.valueOf(yaw), true);
            } else {
                this.m.setRotation(yaw, pitch);
            }
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().severe(e.getMessage());
            for (StackTraceElement ste : e.getStackTrace()) {
                Bukkit.getLogger().severe(ste.toString());
            }
        }
    }

    @Override
    public int getHurtTime() {
        return this.nmsMob.bj;
    }

    @Override
    public void setHurtTime(int hurtTime) {
        this.nmsMob.bj = hurtTime;
    }

    @Override
    public int getHurtDuration() {
        return this.nmsMob.bk;
    }

    @Override
    public void setHurtDuration(int hurtDuration) {
        this.nmsMob.bk = hurtDuration;
    }

    @Override
    public int getDeathTime() {
        return this.nmsMob.bl;
    }

    @Override
    public void setDeathTime(int deathTime) {
        this.nmsMob.bl = deathTime;
    }

    @Override
    public float getForwardSpeed() {
        return this.nmsMob.bE;
    }

    @Override
    public void setForwardSpeed(float speed) {
        this.nmsMob.G(speed);
    }

    @Override
    public float getSidewaysSpeed() {
        return this.nmsMob.bC;
    }

    @Override
    public void setSidewaysSpeed(float speed) {
        this.nmsMob.I(speed);
    }

    @Override
    public float getUpwardSpeed() {
        return this.nmsMob.bD;
    }

    @Override
    public void setUpwardSpeed(float speed) {
        this.nmsMob.H(speed);
    }
}

