/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.ai.goal;

import java.util.function.BooleanSupplier;
import org.browsit.seaofsteves.libs.mobchip.ai.SpeedModifier;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Pathfinder;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Ranged;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

public final class PathfinderMoveThroughVillage
extends Pathfinder
implements SpeedModifier,
Ranged {
    public static final int DEFAULT_MIN_DISTANCE = 10;
    public static final BooleanSupplier DEFAULT_USE_DOORS = () -> true;
    private boolean atNight;
    private double speedMod;
    private int minDistance;
    private BooleanSupplier canUseDoors;

    public PathfinderMoveThroughVillage(@NotNull Creature c) {
        this(c, DEFAULT_USE_DOORS);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, boolean useDoors) {
        this(c, () -> useDoors);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, @NotNull BooleanSupplier useDoors) {
        this(c, useDoors, 1.0);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, @NotNull BooleanSupplier useDoors, double speedMod) {
        this(c, useDoors, speedMod, 10);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, boolean useDoors, double speedMod) {
        this(c, () -> useDoors, speedMod, 10);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, @NotNull BooleanSupplier useDoors, double speedMod, int minDistance) {
        this(c, useDoors, speedMod, minDistance, false);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, boolean useDoors, double speedMod, int minDistance) {
        this(c, () -> useDoors, speedMod, minDistance, false);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, boolean useDoors, double speedMod, int minDistance, boolean onlyAtNight) {
        this(c, () -> useDoors, speedMod, minDistance, onlyAtNight);
    }

    public PathfinderMoveThroughVillage(@NotNull Creature c, @NotNull BooleanSupplier useDoors, double speedMod, int minDistance, boolean onlyAtNight) {
        super((Mob)c);
        this.atNight = onlyAtNight;
        this.speedMod = speedMod;
        this.minDistance = minDistance;
        this.canUseDoors = useDoors;
    }

    public BooleanSupplier canUseDoors() {
        return this.canUseDoors;
    }

    public void setCanUseDoors(@NotNull BooleanSupplier b) {
        this.canUseDoors = b;
    }

    public void setCanUseDoors(boolean use) {
        this.canUseDoors = () -> use;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(int min) {
        this.minDistance = min;
    }

    public boolean mustBeNight() {
        return this.atNight;
    }

    public void setMustBeNight(boolean night) {
        this.atNight = night;
    }

    @Override
    public double getSpeedModifier() {
        return this.speedMod;
    }

    @Override
    public void setSpeedModifier(double mod) {
        this.speedMod = mod;
    }

    @Override
    public float getRange() {
        return this.minDistance;
    }

    @Override
    public void setRange(float range) throws IllegalArgumentException {
        if (range > 2.1474836E9f) {
            throw new IllegalArgumentException("Range is an integer");
        }
        this.minDistance = (int)Math.floor(range);
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.MOVEMENT};
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalMoveThroughVillage";
    }
}

