/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.ai.goal;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.browsit.seaofsteves.libs.mobchip.ai.SpeedModifier;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Pathfinder;
import org.bukkit.Material;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PathfinderTempt
extends Pathfinder
implements SpeedModifier {
    private Predicate<ItemStack> predicate;
    private Set<ItemStack> items;
    private double speedMod;

    public PathfinderTempt(@NotNull Creature m, ItemStack ... items) throws IllegalArgumentException {
        this(m, 1.5, items);
    }

    public PathfinderTempt(@NotNull Creature m, double speedMod, ItemStack ... items) throws IllegalArgumentException {
        this(m, speedMod, Arrays.asList(items));
    }

    public PathfinderTempt(@NotNull Creature m, double speedMod, @NotNull Iterable<? extends ItemStack> items) throws IllegalArgumentException {
        super((Mob)m);
        if (!items.iterator().hasNext()) {
            throw new IllegalArgumentException("items cannot be empty");
        }
        this.items = new HashSet<ItemStack>((Collection<ItemStack>)ImmutableList.copyOf(items));
        this.speedMod = speedMod;
        this.predicate = this.items::contains;
    }

    public PathfinderTempt(@NotNull Creature m, double speedMod, @NotNull Predicate<ItemStack> predicate) {
        super((Mob)m);
        this.speedMod = speedMod;
        this.predicate = predicate;
    }

    @NotNull
    public Set<ItemStack> getItems() {
        if (this.items == null) {
            this.items = new HashSet<ItemStack>();
            for (Material mat : Material.values()) {
                ItemStack item = new ItemStack(mat);
                if (!this.predicate.test(item)) continue;
                this.items.add(item);
            }
            this.predicate = this.items::contains;
        }
        return this.items;
    }

    public Predicate<ItemStack> getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate<ItemStack> predicate) {
        this.predicate = predicate;
        this.items = null;
    }

    public void addItems(ItemStack ... items) throws IllegalArgumentException {
        this.addItems(Arrays.asList(items));
    }

    public void addItems(@NotNull Iterable<? extends ItemStack> items) throws IllegalArgumentException {
        this.getItems().addAll((Collection<ItemStack>)ImmutableList.copyOf(items));
    }

    public void removeItems(ItemStack ... items) throws IllegalArgumentException {
        this.removeItems(Arrays.asList(items));
    }

    public void removeItems(@NotNull Iterable<? extends ItemStack> items) throws IllegalArgumentException {
        ImmutableList.copyOf(items).forEach(this.getItems()::remove);
    }

    public void setItems(@NotNull Iterable<? extends ItemStack> items) throws IllegalArgumentException {
        if (!items.iterator().hasNext()) {
            throw new IllegalArgumentException("items cannot be empty");
        }
        this.items = new HashSet<ItemStack>((Collection<ItemStack>)ImmutableList.copyOf(items));
        this.predicate = this.items::contains;
    }

    public void setItems(ItemStack ... items) throws IllegalArgumentException {
        if (items == null) {
            throw new IllegalArgumentException("Items cannot be null");
        }
        this.setItems(Arrays.asList(items));
    }

    @Override
    public double getSpeedModifier() {
        return this.speedMod;
    }

    @Override
    public void setSpeedModifier(double mod) {
        this.speedMod = mod;
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.MOVEMENT, Pathfinder.PathfinderFlag.LOOKING};
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalTempt";
    }
}

