/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.bukkit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.browsit.seaofsteves.libs.mobchip.abstraction.ChipUtil;
import org.browsit.seaofsteves.libs.mobchip.ai.EntityAI;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Pathfinder;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.WrappedPathfinder;
import org.browsit.seaofsteves.libs.mobchip.bukkit.events.pathfinder.PathfinderAddEvent;
import org.browsit.seaofsteves.libs.mobchip.bukkit.events.pathfinder.PathfinderClearEvent;
import org.browsit.seaofsteves.libs.mobchip.bukkit.events.pathfinder.PathfinderRemoveEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BukkitAI
implements EntityAI {
    private final Set<WrappedPathfinder> goals = new HashSet<WrappedPathfinder>();
    private final boolean target;
    private final Mob m;
    private static final ChipUtil wrapper = ChipUtil.getWrapper();

    BukkitAI(Mob m, boolean target) {
        this.target = target;
        this.m = m;
        this.updateMap();
    }

    private void updateMap() {
        this.goals.clear();
        this.goals.addAll(wrapper.getGoals(this.m, this.target));
    }

    private void updateAI() {
        wrapper.clearPathfinders(this.m, this.target);
        wrapper.addPathfinders(this.goals, this.target);
    }

    @Override
    public int size() {
        return this.goals.size();
    }

    @Override
    public boolean isEmpty() {
        return this.goals.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof WrappedPathfinder)) {
            return false;
        }
        WrappedPathfinder p = (WrappedPathfinder)o;
        return wrapper.getGoals(this.m, this.target).contains(p);
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return this.m;
    }

    @Override
    public boolean contains(@NotNull Pathfinder value) {
        return wrapper.getGoals(this.m, this.target).stream().map(WrappedPathfinder::getPathfinder).collect(Collectors.toList()).contains(value);
    }

    @Override
    public Pathfinder put(@NotNull Pathfinder p, int priority) {
        this.add(new WrappedPathfinder(p, priority));
        return p;
    }

    @Override
    public void putAll(@NotNull Map<? extends Pathfinder, Integer> map) {
        map.forEach(this::put);
    }

    @Override
    public boolean remove(@NotNull Pathfinder p) {
        for (WrappedPathfinder w : wrapper.getGoals(this.m, this.target)) {
            if (!w.getPathfinder().equals(p)) continue;
            return this.remove(w);
        }
        return false;
    }

    @Override
    public boolean isRunning(@NotNull Pathfinder p) {
        return wrapper.getRunningGoals(this.m, this.target).stream().map(WrappedPathfinder::getPathfinder).collect(Collectors.toList()).contains(p);
    }

    @Override
    @NotNull
    public Iterator<WrappedPathfinder> iterator() {
        return this.goals.iterator();
    }

    @NotNull
    public @NotNull WrappedPathfinder @NotNull [] toArray() {
        return this.goals.toArray(new WrappedPathfinder[0]);
    }

    @Override
    public <T> T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return a;
    }

    @Override
    public boolean add(WrappedPathfinder p) {
        boolean success = this.goals.add(p);
        PathfinderAddEvent event = new PathfinderAddEvent(this, p.getPathfinder(), this.target, p.getPriority());
        Bukkit.getPluginManager().callEvent((Event)event);
        this.updateAI();
        return success;
    }

    @Override
    public boolean remove(Object key) {
        if (!(key instanceof WrappedPathfinder)) {
            return false;
        }
        WrappedPathfinder p = (WrappedPathfinder)key;
        boolean success = this.goals.remove(key);
        PathfinderRemoveEvent event = new PathfinderRemoveEvent(this, p.getPathfinder(), this.target);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.updateAI();
        return success;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.goals.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends WrappedPathfinder> c) {
        AtomicBoolean success = new AtomicBoolean(true);
        c.forEach(w -> {
            if (!this.add((WrappedPathfinder)w)) {
                success.set(false);
            }
        });
        return success.get();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.goals.retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.goals.removeAll(c);
    }

    @Override
    public void clear() {
        this.goals.clear();
        this.updateAI();
        PathfinderClearEvent event = new PathfinderClearEvent(this, this.target);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    @NotNull
    public Set<WrappedPathfinder> getRunningGoals() {
        return new HashSet<WrappedPathfinder>(wrapper.getRunningGoals(this.m, this.target));
    }

    @Override
    public void disableFlag(@Nullable Pathfinder.PathfinderFlag flag) {
        wrapper.setFlag(this.m, flag, this.target, false);
    }

    @Override
    public void enableFlag(@Nullable Pathfinder.PathfinderFlag flag) {
        wrapper.setFlag(this.m, flag, this.target, true);
    }
}

