/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.gear.type.PirateEmpty;
import org.browsit.seaofsteves.gear.type.hand.PirateScoop;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockListener
implements Listener {
    private final ConfigSettings config;
    private final GearSettings gear;

    public BlockListener(SeaOfSteves plugin) {
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.gear.isScoopEnabled()) {
            return;
        }
        if (!PirateScoop.equals(event.getPlayer().getInventory().getItemInMainHand())) {
            event.setCancelled(true);
        }
        if (event.getBlock().getType().equals((Object)Material.CHEST) || event.getBlock().getType().equals((Object)Material.BARREL) || event.getBlock().getType().equals((Object)Material.TRAPPED_CHEST)) {
            IO.sendMessage(event.getPlayer(), ChatMessageType.CHAT, String.valueOf(ChatColor.RED) + IO.getLang("breakChestFailed"));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (PirateEmpty.equals(event.getItemInHand())) {
            event.setCancelled(true);
        }
        if (!event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE) && (event.getBlock().getType().equals((Object)Material.CHEST) || event.getBlock().getType().equals((Object)Material.BARREL) || event.getBlock().getType().equals((Object)Material.TRAPPED_CHEST))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getBlock().getWorld().getName())) {
            return;
        }
        if (!this.config.canGeneralBlockExplode()) {
            event.setCancelled(true);
        }
    }
}

