/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.gear.type.boat.PirateDingy;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.NBTAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class EntityUtil {
    public static SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");
    private static FoliaLib foliaLib;

    public static boolean isShipAllowedOrCancel(EntityPlaceEvent event) {
        Player player;
        if (foliaLib == null && plugin != null) {
            foliaLib = plugin.getFoliaLib();
        }
        if ((player = event.getPlayer()) == null) {
            return false;
        }
        if (plugin.getConfigSettings().isVotsEnabled() && plugin.getDependencies().getMythicMobs() == null) {
            event.setCancelled(true);
            plugin.getLogger().warning("Boats for MythicMobs is enabled in config, but not installed on server");
            return false;
        }
        if (!NBTAPI.hasNBT(player.getInventory().getItemInMainHand(), "sos_owner")) {
            event.setCancelled(true);
            IO.sendMessage(player, ChatMessageType.ACTION_BAR, String.valueOf(ChatColor.RED) + IO.getLang("dropDenied"));
            return false;
        }
        if (event.getBlock().getType() != Material.WATER) {
            event.setCancelled(true);
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.RED) + IO.getLang("placeShipFailed"));
            ItemStack dingy = PirateDingy.get(player);
            foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> player.getInventory().setItem(plugin.getGearSettings().getDingySlot(), dingy), 2L);
            return false;
        }
        return true;
    }
}

