/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.loot.Item;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.gear.type.PirateEmpty;
import org.browsit.seaofsteves.gear.type.boat.PirateDingy;
import org.browsit.seaofsteves.gear.type.boat.PirateFireball;
import org.browsit.seaofsteves.gear.type.boat.PirateSurveyor;
import org.browsit.seaofsteves.gear.type.hand.PirateArrow;
import org.browsit.seaofsteves.gear.type.hand.PirateDiviningRod;
import org.browsit.seaofsteves.gear.type.hand.PirateFishingRod;
import org.browsit.seaofsteves.gear.type.hand.PirateLongbow;
import org.browsit.seaofsteves.gear.type.hand.PiratePickaxe;
import org.browsit.seaofsteves.gear.type.hand.PirateSabre;
import org.browsit.seaofsteves.gear.type.hand.PirateScoop;
import org.browsit.seaofsteves.gear.type.hand.PirateSpyglass;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ItemUtil {
    public static SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");
    private static final ConcurrentHashMap<UUID, Material> lastUsedItem = new ConcurrentHashMap();
    private static final Set<ItemStack> lootItems = new HashSet<ItemStack>();

    public static void addItem(Player player, ItemStack item) throws NullPointerException {
        if (player == null) {
            return;
        }
        if (item == null) {
            throw new NullPointerException("Null item while trying to add to inventory of " + player.getName());
        }
        PlayerInventory inv = player.getInventory();
        HashMap leftovers = inv.addItem(new ItemStack[]{item});
        if (!leftovers.isEmpty()) {
            for (ItemStack leftover : leftovers.values()) {
                player.getWorld().dropItem(player.getLocation(), leftover);
            }
        }
    }

    public static boolean isGear(ItemStack itemStack) {
        return PirateFireball.equals(itemStack) || PirateSurveyor.equals(itemStack) || PirateDingy.equals(itemStack) || PirateDiviningRod.equals(itemStack) || PirateFishingRod.equals(itemStack) || PirateSabre.equals(itemStack) || PirateScoop.equals(itemStack) || PirateLongbow.equals(itemStack) || PirateSpyglass.equals(itemStack) || PiratePickaxe.equals(itemStack) || PirateEmpty.equals(itemStack) || PirateArrow.equals(itemStack);
    }

    public static String getGearDisplay(Class<?> gearClazz) {
        if (plugin == null) {
            return "";
        }
        GearSettings gear = plugin.getGearSettings();
        if (PirateSabre.class.isAssignableFrom(gearClazz)) {
            return gear.getSabreDisplay();
        }
        if (PirateLongbow.class.isAssignableFrom(gearClazz)) {
            return gear.getLongbowDisplay();
        }
        if (PirateScoop.class.isAssignableFrom(gearClazz)) {
            return gear.getScoopDisplay();
        }
        if (PirateDiviningRod.class.isAssignableFrom(gearClazz)) {
            return gear.getDiviningRodDisplay();
        }
        if (PirateDingy.class.isAssignableFrom(gearClazz)) {
            return gear.getDingyDisplay();
        }
        if (PirateSpyglass.class.isAssignableFrom(gearClazz)) {
            return gear.getSpyglassDisplay();
        }
        if (PirateFireball.class.isAssignableFrom(gearClazz)) {
            return gear.getFireballDisplay();
        }
        if (PirateSurveyor.class.isAssignableFrom(gearClazz)) {
            return gear.getSurveyorDisplay();
        }
        if (PirateFishingRod.class.isAssignableFrom(gearClazz)) {
            return gear.getFishingRodDisplay();
        }
        if (PiratePickaxe.class.isAssignableFrom(gearClazz)) {
            return gear.getPickaxeDisplay();
        }
        if (PirateArrow.class.isAssignableFrom(gearClazz)) {
            return String.valueOf(ChatColor.GOLD) + "Arrow";
        }
        return "";
    }

    public static List<String> getGearLore(Class<?> gearClazz) {
        if (plugin == null) {
            return Collections.emptyList();
        }
        GearSettings gear = plugin.getGearSettings();
        if (PirateSabre.class.isAssignableFrom(gearClazz)) {
            return gear.getSabreLore();
        }
        if (PirateLongbow.class.isAssignableFrom(gearClazz)) {
            return gear.getLongbowLore();
        }
        if (PirateScoop.class.isAssignableFrom(gearClazz)) {
            return gear.getScoopLore();
        }
        if (PirateDiviningRod.class.isAssignableFrom(gearClazz)) {
            return gear.getDiviningRodLore();
        }
        if (PirateDingy.class.isAssignableFrom(gearClazz)) {
            return gear.getDingyLore();
        }
        if (PirateSpyglass.class.isAssignableFrom(gearClazz)) {
            return gear.getSpyglassLore();
        }
        if (PirateFireball.class.isAssignableFrom(gearClazz)) {
            return gear.getFireballLore();
        }
        if (PirateSurveyor.class.isAssignableFrom(gearClazz)) {
            return gear.getSurveyorLore();
        }
        if (PirateFishingRod.class.isAssignableFrom(gearClazz)) {
            return gear.getFishingRodLore();
        }
        if (PiratePickaxe.class.isAssignableFrom(gearClazz)) {
            return gear.getPickaxeLore();
        }
        return Collections.emptyList();
    }

    public static void renewGear(Player player, boolean allowShip) {
        if (!WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            return;
        }
        GearSettings gear = plugin.getGearSettings();
        if (gear.isSabreEnabled()) {
            player.getInventory().setItem(gear.getSabreSlot(), PirateSabre.get(player));
        }
        if (gear.isLongbowEnabled()) {
            player.getInventory().setItem(gear.getLongbowSlot(), PirateLongbow.get(player));
        }
        if (gear.isScoopEnabled()) {
            player.getInventory().setItem(gear.getScoopSlot(), PirateScoop.get(player));
        }
        if (gear.isDiviningRodEnabled()) {
            player.getInventory().setItem(gear.getDiviningRodSlot(), PirateDiviningRod.get(player));
        }
        if (gear.isDingyEnabled()) {
            if (!player.isInsideVehicle() && allowShip) {
                player.getInventory().setItem(gear.getDingySlot(), PirateDingy.get(player));
                player.setCooldown(PirateDingy.get(player).getType(), 180);
            } else {
                player.getInventory().setItem(gear.getDingySlot(), PirateEmpty.get(player));
            }
        }
        if (gear.isFireballEnabled()) {
            player.getInventory().setItem(gear.getFireballSlot(), PirateFireball.get(player));
        }
        if (gear.isSpyglassEnabled()) {
            player.getInventory().setItem(gear.getSpyglassSlot(), PirateSpyglass.get(player));
        }
        if (gear.isSurveyorEnabled()) {
            player.getInventory().setItem(gear.getSurveyorSlot(), PirateSurveyor.get(player));
        }
        if (gear.isFishingRodEnabled()) {
            player.getInventory().setItem(gear.getFishingRodSlot(), PirateFishingRod.get(player));
        }
        if (gear.isPickaxeEnabled()) {
            player.getInventory().setItem(gear.getPickaxeSlot(), PiratePickaxe.get(player));
        }
    }

    public static void renewGearNaval(Player player, String shipType) {
        if (!WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            return;
        }
        if (shipType == null) {
            plugin.getLogger().severe("Missing ship type from player of UUID " + String.valueOf(player.getUniqueId()));
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.RED) + IO.getLang("problemOccurred"));
            return;
        }
        int slot = -1;
        for (String item : plugin.getGearSettings().getNavalSlotsMythic()) {
            ++slot;
            if (item.equals("NAME_OF_ITEM_TO_USE_INSTEAD") || item.equals("VOTSAmmoCannonBall") && shipType.equals("Catamaran")) continue;
            ItemStack mythic = plugin.getDependencies().getMythicMobs().getItemManager().getItemStack(item);
            if (mythic == null) {
                plugin.getLogger().severe("Unknown mythic gear " + item + ", using default gear for this slot");
                continue;
            }
            player.getInventory().setItem(slot, mythic);
        }
    }

    public static void renewInventory(Player player) {
        if (!WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            return;
        }
        player.getInventory().clear();
        ItemUtil.renewGear(player, true);
    }

    public static boolean isSimilar(ItemStack one, ItemStack two) {
        if (!one.hasItemMeta() || !two.hasItemMeta()) {
            return false;
        }
        return one.getType().equals((Object)two.getType()) && one.getDurability() == two.getDurability() && one.getItemMeta().getCustomModelData() == two.getItemMeta().getCustomModelData();
    }

    public static boolean isOnCooldown(Player player, Material material) {
        if (lastUsedItem.containsKey(player.getUniqueId())) {
            IO.sendMessage(player, ChatMessageType.ACTION_BAR, String.valueOf(ChatColor.DARK_RED) + IO.getLang("interactTooFast"));
            return true;
        }
        lastUsedItem.put(player.getUniqueId(), material);
        player.setCooldown(material, 40);
        plugin.getFoliaLib().getScheduler().runLater(() -> lastUsedItem.remove(player.getUniqueId()), 40L);
        return false;
    }

    public static Set<ItemStack> getLootItems() {
        if (lootItems.isEmpty()) {
            ItemUtil.initLootItems();
        }
        return lootItems;
    }

    public static void initLootItems() {
        if (plugin == null) {
            return;
        }
        ConfigSettings settings = plugin.getConfigSettings();
        if (settings.isPhatLootEnabled() && plugin.getDependencies().isPluginAvailable("PhatLoots")) {
            PhatLoot phatLoot = PhatLoots.getPhatLoot((String)settings.getPhatLootNameChest());
            if (phatLoot == null) {
                plugin.getLogger().severe("Invalid name of PhatLoot in config: " + settings.getPhatLootNameChest());
                return;
            }
            lootItems.clear();
            for (Loot loot : phatLoot.lootList) {
                ItemUtil.extractItem(loot);
                if (!(loot instanceof LootCollection)) continue;
                for (Loot loot2 : ((LootCollection)loot).getLootList()) {
                    ItemUtil.extractItem(loot2);
                    if (!(loot2 instanceof LootCollection)) continue;
                    for (Loot loot3 : ((LootCollection)loot2).getLootList()) {
                        ItemUtil.extractItem(loot3);
                        if (!(loot3 instanceof LootCollection)) continue;
                        for (Loot loot4 : ((LootCollection)loot3).getLootList()) {
                            ItemUtil.extractItem(loot4);
                        }
                    }
                }
            }
        }
    }

    private static void extractItem(Loot loot) {
        if (loot instanceof Item) {
            lootItems.add(((Item)loot).getItem());
        }
    }
}

