/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import org.browsit.seaofsteves.SeaOfSteves;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTAPI {
    private static final SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");

    @Nullable
    public static String getNBT(@NotNull ItemStack item, String key) {
        NamespacedKey namespacedKey;
        if (plugin == null) {
            return null;
        }
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.has(namespacedKey = new NamespacedKey((Plugin)plugin, key), PersistentDataType.STRING)) {
            return (String)pdc.get(namespacedKey, PersistentDataType.STRING);
        }
        return null;
    }

    @Nullable
    public static String getNBT(@NotNull Entity entity, String key) {
        NamespacedKey namespacedKey;
        if (plugin == null) {
            return null;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (pdc.has(namespacedKey = new NamespacedKey((Plugin)plugin, key), PersistentDataType.STRING)) {
            return (String)pdc.get(namespacedKey, PersistentDataType.STRING);
        }
        return null;
    }

    public static void addNBT(@NotNull ItemStack item, String key, String value) {
        ItemMeta meta;
        if (plugin == null) {
            return;
        }
        ItemMeta itemMeta = meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
        if (meta == null) {
            return;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)plugin, key);
        pdc.set(namespacedKey, PersistentDataType.STRING, (Object)value);
        item.setItemMeta(meta);
    }

    public static void addNBT(@NotNull Entity entity, String key, String value) {
        if (plugin == null) {
            return;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)plugin, key);
        pdc.set(namespacedKey, PersistentDataType.STRING, (Object)value);
    }

    public static boolean hasNBT(@NotNull ItemStack item, String key) {
        if (plugin == null) {
            return false;
        }
        if (item.getItemMeta() == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(new NamespacedKey((Plugin)plugin, key), PersistentDataType.STRING);
    }

    public static boolean hasNBT(@NotNull Entity entity, String key) {
        if (plugin == null) {
            return false;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        return pdc.has(new NamespacedKey((Plugin)plugin, key), PersistentDataType.STRING);
    }

    public static void removeNBT(@NotNull ItemStack item, String key) {
        if (plugin == null) {
            return;
        }
        if (item.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.remove(new NamespacedKey((Plugin)plugin, key));
        item.setItemMeta(meta);
    }

    public static void removeNBT(@NotNull Entity entity, String key) {
        if (plugin == null) {
            return;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        pdc.remove(new NamespacedKey((Plugin)plugin, key));
    }
}

