/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.Optional;
import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.api.event.PirateSellTreasureEvent;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.player.Pirate;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.ItemUtil;
import org.browsit.seaofsteves.util.NBTAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PlayerUtil {
    public static SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");
    private static FoliaLib foliaLib;

    public static void adios(Player player) {
        if (plugin.getConfigSettings().isVotsEnabled() && plugin.getDependencies().getMythicMobs() != null) {
            for (Entity e : player.getNearbyEntities(250.0, 50.0, 250.0)) {
                if (!NBTAPI.hasNBT(e, "sos_owner")) continue;
                String owner = NBTAPI.getNBT(e, "sos_owner");
                if (owner == null) {
                    return;
                }
                if (!owner.equals(player.getUniqueId().toString())) continue;
                Optional am = plugin.getDependencies().getMythicMobs().getMobManager().getActiveMob(e.getUniqueId());
                am.ifPresent(ActiveMob::despawn);
            }
        }
        Pirate pirate = plugin.getPirate(player.getUniqueId());
        if (plugin.getAllPirates().contains(pirate) && player.isInsideVehicle()) {
            Entity vehicle = player.getVehicle();
            if (vehicle == null) {
                return;
            }
            vehicle.eject();
            vehicle.remove();
        }
        plugin.removePirate(pirate);
    }

    public static void sellTreasure(Player player, Entity merchant) {
        boolean useVault = plugin.getConfigSettings().canMerchantUseVault() && plugin.getDependencies().isPluginAvailable("Vault");
        int totalWorth = 0;
        for (ItemStack itemStack : player.getInventory().getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || ItemUtil.isGear(itemStack)) continue;
            for (ItemStack lootItem : ItemUtil.getLootItems()) {
                if (!lootItem.isSimilar(itemStack)) continue;
                totalWorth += itemStack.getAmount() * plugin.getConfigSettings().getMerchantReward();
                player.getInventory().remove(itemStack);
            }
        }
        if (totalWorth > 0) {
            Pirate pirate = plugin.getPirate(player.getUniqueId());
            pirate.setGoldEarned(pirate.getGoldEarned() + totalWorth);
            if (useVault) {
                plugin.getDependencies().getVaultEconomy().depositPlayer((OfflinePlayer)player, (double)totalWorth);
            }
            String amount = useVault ? plugin.getDependencies().getVaultEconomy().format((double)totalWorth) : String.valueOf(totalWorth);
            String points = useVault ? "" : IO.getLang("interactMerchantPoints");
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.GREEN) + IO.getLang("interactMerchantSold").replace("<name>", plugin.getConfigSettings().getMerchantName()).replace("<amount>", amount).replace("<points>", points));
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_CLUSTER_HIT, 1.0f, 1.0f);
            PirateSellTreasureEvent pEvent = new PirateSellTreasureEvent(plugin.getPirate(player.getUniqueId()), merchant, totalWorth);
            plugin.getServer().getPluginManager().callEvent((Event)pEvent);
            plugin.getLogger().info(player.getName() + " sold all treasures to " + plugin.getConfigSettings().getMerchantName() + " for " + amount + " points");
        } else {
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.YELLOW) + IO.getLang("interactMerchantFailed"));
        }
    }

    public static void sellFish(Player player, Entity fishmonger) {
        boolean useVault = plugin.getConfigSettings().canFishmongerUseVault() && plugin.getDependencies().isPluginAvailable("Vault");
        int totalWorth = 0;
        for (ItemStack itemStack : player.getInventory().getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || ItemUtil.isGear(itemStack) || !itemStack.getType().equals((Object)Material.LEGACY_RAW_FISH)) continue;
            totalWorth += itemStack.getAmount() * plugin.getConfigSettings().getFishmongerReward();
            player.getInventory().remove(itemStack);
        }
        if (totalWorth > 0) {
            Pirate pirate = plugin.getPirate(player.getUniqueId());
            pirate.setGoldEarned(pirate.getGoldEarned() + totalWorth);
            if (useVault) {
                plugin.getDependencies().getVaultEconomy().depositPlayer((OfflinePlayer)player, (double)totalWorth);
            }
            String amount = useVault ? plugin.getDependencies().getVaultEconomy().format((double)totalWorth) : String.valueOf(totalWorth);
            String points = useVault ? "" : IO.getLang("interactFishmongerPoints");
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.GREEN) + IO.getLang("interactFishmongerSold").replace("<name>", plugin.getConfigSettings().getFishmongerName()).replace("<amount>", amount).replace("<points>", points));
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_CLUSTER_HIT, 1.0f, 1.0f);
            PirateSellTreasureEvent pEvent = new PirateSellTreasureEvent(plugin.getPirate(player.getUniqueId()), fishmonger, totalWorth);
            plugin.getServer().getPluginManager().callEvent((Event)pEvent);
            plugin.getLogger().info(player.getName() + " sold all treasures to " + plugin.getConfigSettings().getFishmongerName() + " for " + amount + " points");
        } else {
            IO.sendMessage(player, ChatMessageType.CHAT, String.valueOf(ChatColor.YELLOW) + IO.getLang("interactFishmongerFailed"));
        }
    }

    public static void spawnEnemyVotsShipSpawn(Player player) {
        if (foliaLib == null && plugin != null) {
            foliaLib = plugin.getFoliaLib();
        }
        foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> {
            Location loc = player.getLocation();
            Vector inverseDirectionVec = loc.getDirection().normalize().multiply(-20);
            loc.add(inverseDirectionVec);
            loc.setY(60.0);
            if (loc.getBlock().isLiquid()) {
                Optional opt = plugin.getDependencies().getMythicMobs().getSkillManager().getSkill("VOTSNPCGalleonShipDeathSound");
                if (opt.isPresent()) {
                    BukkitEntity bukkitEntity = new BukkitEntity((Entity)player);
                    SkillCaster c = plugin.getDependencies().getMythicMobs().getSkillManager().getCaster((AbstractEntity)bukkitEntity);
                    SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.API, c, (AbstractEntity)bukkitEntity);
                    ((Skill)opt.get()).execute((SkillMetadata)meta);
                }
                plugin.getDependencies().getMythicMobs().getMobManager().spawnMob("VOTSNPCGalleon", loc);
                IO.sendMessage(player, ChatMessageType.ACTION_BAR, String.valueOf(ChatColor.RED) + IO.getLang("enemyVesselChase"));
            }
        }, 40L);
    }
}

