/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.boss.lavablock;

import java.util.ArrayList;
import java.util.Arrays;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class EffectTask
implements Runnable {
    private final ConfigSettings config;
    private final Entity vehicle;
    private final Display tephra;
    private final Location target;

    public EffectTask(SeaOfSteves plugin, Entity vehicle, Display tephra, Location target) {
        this.config = plugin.getConfigSettings();
        this.vehicle = vehicle;
        this.tephra = tephra;
        this.target = target;
    }

    @Override
    public void run() {
        if (!this.tephra.isValid()) {
            return;
        }
        World world = this.vehicle.getWorld();
        if (this.vehicle.getLocation().getY() <= this.target.getY() || this.vehicle.isOnGround()) {
            world.spawnParticle(Particle.EXPLOSION_EMITTER, this.tephra.getLocation(), 10);
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (player.getWorld() == this.tephra.getWorld() && player.getLocation().distance(this.tephra.getLocation()) < 4.0) {
                    Vector velocity = player.getLocation().toVector().subtract(this.tephra.getLocation().toVector());
                    player.setVelocity(new Vector(velocity.getX(), 1.2, velocity.getZ()));
                }
            });
            Location l = new Location(this.tephra.getLocation().getWorld(), this.tephra.getLocation().getX(), this.tephra.getLocation().getY() - 1.0, this.tephra.getLocation().getZ());
            if (l.getWorld() == null) {
                return;
            }
            ArrayList<FallingBlock> blocks = new ArrayList<FallingBlock>(Arrays.asList(this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(1.0, 0.0, 0.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(0.0, 0.0, 1.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(-1.0, 0.0, 0.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(-1.0, 0.0, 0.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(0.0, 0.0, -1.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(0.0, 0.0, -1.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(1.0, 0.0, 0.0)).getType().createBlockData()), this.tephra.getWorld().spawnFallingBlock(this.tephra.getLocation(), l.getWorld().getBlockAt(l.add(1.0, 0.0, 0.0)).getType().createBlockData())));
            ((FallingBlock)blocks.get(0)).setVelocity(new Vector(-0.3, 0.5, -0.6));
            ((FallingBlock)blocks.get(1)).setVelocity(new Vector(-0.5, 0.4, 0.2));
            ((FallingBlock)blocks.get(2)).setVelocity(new Vector(0.5, 0.3, 0.5));
            ((FallingBlock)blocks.get(3)).setVelocity(new Vector(0.3, 0.4, 0.4));
            ((FallingBlock)blocks.get(4)).setVelocity(new Vector(0.2, 0.3, -0.5));
            ((FallingBlock)blocks.get(5)).setVelocity(new Vector(0.4, 0.3, -0.3));
            ((FallingBlock)blocks.get(6)).setVelocity(new Vector(-0.6, 0.4, -0.5));
            ((FallingBlock)blocks.get(7)).setVelocity(new Vector(-0.4, 0.5, -0.2));
            ((FallingBlock)blocks.get(8)).setVelocity(new Vector(0.2, 0.6, -0.1));
            if (this.config.getEruptionCancelDrop()) {
                ((FallingBlock)blocks.get(0)).setCancelDrop(true);
                ((FallingBlock)blocks.get(1)).setCancelDrop(true);
                ((FallingBlock)blocks.get(2)).setCancelDrop(true);
                ((FallingBlock)blocks.get(3)).setCancelDrop(true);
                ((FallingBlock)blocks.get(4)).setCancelDrop(true);
                ((FallingBlock)blocks.get(5)).setCancelDrop(true);
                ((FallingBlock)blocks.get(6)).setCancelDrop(true);
                ((FallingBlock)blocks.get(7)).setCancelDrop(true);
                ((FallingBlock)blocks.get(8)).setCancelDrop(true);
            }
            blocks.forEach(b -> {
                b.setHurtEntities(true);
                b.setDropItem(false);
            });
            world.playSound(this.tephra.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
            this.tephra.remove();
            this.vehicle.remove();
            return;
        }
        world.spawnParticle(Particle.LARGE_SMOKE, this.tephra.getLocation().add(2.0, -1.0, 4.0), 1);
        world.playSound(this.tephra.getLocation(), Sound.ENTITY_HORSE_BREATHE, 2.0f, 1.0f);
    }
}

