/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.command;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.boss.lavablock.Tephra;
import org.browsit.seaofsteves.player.Pirate;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.ItemUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SosExecutor
implements CommandExecutor {
    private final SeaOfSteves plugin;

    public SosExecutor(SeaOfSteves plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase("sos")) {
            if (!sender.hasPermission("seaofsteves.sos")) {
                sender.sendMessage(ChatColor.RED + IO.getLang("noPermission"));
                return false;
            }
            if (args.length < 1) {
                return this.showInfo(sender);
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("seaofsteves.sos.reload")) {
                    sender.sendMessage(ChatColor.RED + IO.getLang("noPermission"));
                    return false;
                }
                this.plugin.reloadAllSettings();
                ItemUtil.initLootItems();
                String worlds = this.plugin.getConfigSettings().getWorldNames().stream().map(Object::toString).collect(Collectors.joining(", "));
                sender.sendMessage(ChatColor.GREEN + IO.getLang("commandReloadDone").replace("<worlds>", ChatColor.RESET + worlds));
                return true;
            }
            if (args[0].equals("tephra")) {
                if (!sender.hasPermission("seaofsteves.sos.tephra")) {
                    sender.sendMessage(ChatColor.RED + IO.getLang("noPermission"));
                    return false;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + IO.getLang("consoleError"));
                    return false;
                }
                new Tephra(this.plugin, ((Player)sender).getLocation());
                return true;
            }
            if (args[0].equals("top")) {
                if (!sender.hasPermission("seaofsteves.sos.top")) {
                    sender.sendMessage(ChatColor.RED + IO.getLang("noPermission"));
                    return false;
                }
                Map<String, Integer> map = this.sort(this.plugin.getAllPirates().stream().collect(Collectors.toMap(Pirate::getName, Pirate::getGoldEarned)));
                for (int i = 0; i < map.size() && i <= 9; ++i) {
                    String key = (String)map.keySet().toArray()[i];
                    sender.sendMessage(ChatColor.YELLOW + (i + 1) + ". " + key + " - " + ChatColor.DARK_PURPLE + map.get(key));
                }
                return true;
            }
        }
        return false;
    }

    private boolean showInfo(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "Sea of Steves v" + this.plugin.getDescription().getVersion());
        int worlds = this.plugin.getConfigSettings().getWorldNames().size();
        sender.sendMessage(ChatColor.YELLOW + IO.getLang("commandCurrentlyEnabled").replace("<worlds>", ChatColor.RESET + String.valueOf(worlds) + ChatColor.YELLOW));
        return true;
    }

    private Map<String, Integer> sort(Map<String, Integer> unsortedMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortedMap.entrySet());
        list.sort((o1, o2) -> {
            int i = (Integer)o1.getValue();
            int i2 = (Integer)o2.getValue();
            return Integer.compare(i2, i);
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }
}

