/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.expansion;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.player.Pirate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class SOSExpansion
extends PlaceholderExpansion {
    private final SeaOfSteves plugin;

    public SOSExpansion(SeaOfSteves plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "sos";
    }

    @NotNull
    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.startsWith("reset_timer_")) {
            if (!this.plugin.getConfig().getBoolean("sos.multiverse-reset.enabled")) {
                return null;
            }
            String worldName = params.substring(params.lastIndexOf("_") + 1);
            if (Bukkit.getWorld((String)worldName) != null) {
                return this.plugin.getResetTimer().formatTime(this.plugin.getResetTimer().getTimerRemaining(worldName));
            }
        } else if (params.startsWith("gold_rank_")) {
            int i;
            if (!this.plugin.getConfig().getBoolean("sos.merchants.enabled")) {
                return null;
            }
            try {
                i = Integer.parseInt(params.substring(params.lastIndexOf("_") + 1));
                if (i < 1) {
                    this.plugin.getLogger().severe("Placeholder rank must be a positive number");
                    return null;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Invalid placeholder rank " + params.substring(params.lastIndexOf("_") + 1));
                return null;
            }
            Map<String, Integer> map = SOSExpansion.sort(this.plugin.getAllPirates().stream().collect(Collectors.toMap(Pirate::getName, Pirate::getGoldEarned)));
            if (map.size() >= i) {
                String key = (String)map.keySet().toArray()[i - 1];
                return key + " - " + map.get(key);
            }
            return "";
        }
        return null;
    }

    public static Map<String, Integer> sort(Map<String, Integer> unsortedMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortedMap.entrySet());
        list.sort((o1, o2) -> {
            int i = (Integer)o1.getValue();
            int i2 = (Integer)o2.getValue();
            return Integer.compare(i2, i);
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }
}

