/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip;

import java.util.Map;
import org.browsit.seaofsteves.libs.mobchip.EntityBody;
import org.browsit.seaofsteves.libs.mobchip.ai.EntityAI;
import org.browsit.seaofsteves.libs.mobchip.ai.attribute.Attribute;
import org.browsit.seaofsteves.libs.mobchip.ai.attribute.AttributeInstance;
import org.browsit.seaofsteves.libs.mobchip.ai.behavior.EntityBehavior;
import org.browsit.seaofsteves.libs.mobchip.ai.controller.EntityController;
import org.browsit.seaofsteves.libs.mobchip.ai.memories.Memory;
import org.browsit.seaofsteves.libs.mobchip.ai.memories.MemoryStatus;
import org.browsit.seaofsteves.libs.mobchip.ai.navigation.EntityNavigation;
import org.browsit.seaofsteves.libs.mobchip.ai.schedule.EntityScheduleManager;
import org.browsit.seaofsteves.libs.mobchip.ai.sensing.EntitySenses;
import org.browsit.seaofsteves.libs.mobchip.combat.EntityCombatTracker;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityBrain {
    @NotNull
    public Mob getEntity();

    @NotNull
    public EntityAI getGoalAI();

    @NotNull
    public AttributeInstance getAttributeInstance(@NotNull Attribute var1);

    @NotNull
    public EntityAI getTargetAI();

    @NotNull
    public EntityNavigation createNavigation();

    @NotNull
    public EntityController getController();

    @NotNull
    public EntityScheduleManager getScheduleManager();

    public EntityBehavior getBehaviors();

    public <T> void setMemory(@NotNull Memory<T> var1, @Nullable T var2) throws IllegalArgumentException;

    public <T> void setMemory(@NotNull Memory<T> var1, @Nullable T var2, long var3) throws IllegalArgumentException;

    default public void setMemories(@NotNull Map<Memory, ?> map) {
        for (Map.Entry<Memory, ?> entry : map.entrySet()) {
            this.setMemory(entry.getKey(), entry.getValue());
        }
    }

    default public void setMemories(@NotNull Map<Memory, ?> map, long expire) {
        for (Map.Entry<Memory, ?> entry : map.entrySet()) {
            this.setMemory(entry.getKey(), entry.getValue(), expire);
        }
    }

    @Nullable
    public <T> T getMemory(@NotNull Memory<T> var1);

    public long getExpiration(@NotNull Memory<?> var1);

    public boolean containsMemory(@NotNull Memory<?> var1);

    public void removeMemory(@NotNull Memory<?> var1);

    public MemoryStatus getMemoryStatus(@NotNull Memory<?> var1);

    default public boolean containsAllMemories(Memory<?> ... memories) {
        boolean contains = true;
        for (Memory<?> m : memories) {
            if (this.containsMemory(m)) continue;
            contains = false;
            break;
        }
        return contains;
    }

    public boolean isInRestriction();

    public void setRestrictionArea(Location var1, int var2);

    public void clearRestrictionArea();

    public Location getRestrictionArea();

    public boolean hasRestriction();

    public int getRestrictionRadius();

    public boolean canSee(@Nullable Entity var1);

    default public boolean canSee(@Nullable EntityBrain brain) {
        if (brain == null) {
            return false;
        }
        return this.canSee((Entity)brain.getEntity());
    }

    @NotNull
    public EntityBody getBody();

    @NotNull
    public EntityCombatTracker getCombatTracker();

    @NotNull
    public EntitySenses getSenses();
}

