/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.abstraction.v1_20_R2;

import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.phys.Vec3D;
import org.browsit.seaofsteves.libs.mobchip.abstraction.v1_20_R2.ChipUtil1_20_R2;
import org.browsit.seaofsteves.libs.mobchip.ai.controller.EntityController;
import org.browsit.seaofsteves.libs.mobchip.ai.controller.NaturalMoveType;
import org.bukkit.Location;
import org.bukkit.entity.Mob;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

final class EntityController1_20_R2
implements EntityController {
    private final ControllerJump jumpC;
    private final ControllerMove moveC;
    private final ControllerLook lookC;
    private final Mob m;
    private final EntityInsentient nms;

    public EntityController1_20_R2(Mob m) {
        EntityInsentient nms = ChipUtil1_20_R2.toNMS(m);
        this.lookC = nms.G();
        this.moveC = nms.I();
        this.jumpC = nms.K();
        this.m = m;
        this.nms = nms;
    }

    @Override
    public EntityController jump() {
        this.jumpC.a();
        this.jumpC.b();
        return this;
    }

    @Override
    public boolean isLookingAtTarget() {
        Vector dir = this.m.getLocation().getDirection();
        int x = dir.getBlockX();
        int y = dir.getBlockY();
        int z = dir.getBlockZ();
        return this.lookC.e() == (double)x && this.lookC.f() == (double)y && this.lookC.g() == (double)z;
    }

    @Override
    public EntityController moveTo(double x, double y, double z, double speedMod) {
        this.moveC.a(x, y, z, speedMod);
        this.moveC.a();
        this.nms.L().a(this.moveC.d(), this.moveC.e(), this.moveC.f(), this.moveC.c());
        this.nms.L().c();
        return this;
    }

    @Override
    public EntityController naturalMoveTo(double x, double y, double z, NaturalMoveType type) {
        Vec3D vec = new Vec3D(x, y, z);
        EnumMoveType m = switch (type) {
            default -> EnumMoveType.a;
            case NaturalMoveType.PLAYER -> EnumMoveType.b;
            case NaturalMoveType.PISTON -> EnumMoveType.c;
            case NaturalMoveType.SHULKER_BOX -> EnumMoveType.d;
            case NaturalMoveType.SHULKER -> EnumMoveType.e;
        };
        this.nms.a(m, vec);
        return this;
    }

    @Override
    public EntityController strafe(float fwd, float right) {
        this.moveC.a(fwd, right);
        this.moveC.a();
        this.nms.L().a(this.moveC.d(), this.moveC.e(), this.moveC.f(), this.moveC.c());
        this.nms.L().c();
        return this;
    }

    @Override
    public double getCurrentSpeedModifier() {
        return this.moveC.c();
    }

    @Override
    public Location getTargetMoveLocation() {
        return new Location(this.m.getWorld(), this.moveC.d(), this.moveC.e(), this.moveC.f());
    }

    @Override
    public Location getTargetLookLocation() {
        return new Location(this.m.getWorld(), this.lookC.e(), this.lookC.f(), this.lookC.g());
    }

    @Override
    public EntityController lookAt(double x, double y, double z) {
        this.lookC.a(x, y, z);
        this.lookC.a();
        return this;
    }

    @Override
    @NotNull
    public Vector getDeltaMovement() {
        Vec3D delta = this.nms.do();
        return new Vector(delta.c, delta.d, delta.e);
    }

    @Override
    public void setDeltaMovement(@NotNull Vector delta) {
        Vec3D vec = new Vec3D(delta.getX(), delta.getY(), delta.getZ());
        this.nms.f(vec);
    }
}

