/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.abstraction.v1_21_R2;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.browsit.seaofsteves.libs.mobchip.abstraction.v1_21_R2.ChipUtil1_21_R2;
import org.browsit.seaofsteves.libs.mobchip.ai.sensing.EntitySenses;
import org.browsit.seaofsteves.libs.mobchip.ai.sensing.Sensor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

final class EntitySenses1_21_R2
implements EntitySenses {
    private final Mob m;
    private final EntityInsentient nmsMob;
    private final Map<SensorType<?>, net.minecraft.world.entity.ai.sensing.Sensor<?>> sensorsHandle = new HashMap();

    public EntitySenses1_21_R2(Mob m) {
        this.m = m;
        this.nmsMob = ChipUtil1_21_R2.toNMS(m);
        try {
            Field sensorsF = BehaviorController.class.getDeclaredField("e");
            sensorsF.setAccessible(true);
            Map sensors = (Map)sensorsF.get(this.nmsMob.ec());
            this.sensorsHandle.putAll(sensors);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().severe(e.getMessage());
            for (StackTraceElement st : e.getStackTrace()) {
                Bukkit.getLogger().severe(st.toString());
            }
        }
    }

    private void save() {
        try {
            Field sensorsF = BehaviorController.class.getDeclaredField("e");
            sensorsF.setAccessible(true);
            sensorsF.set(this.nmsMob.ec(), this.sensorsHandle);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().severe(e.getMessage());
            for (StackTraceElement st : e.getStackTrace()) {
                Bukkit.getLogger().severe(st.toString());
            }
        }
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return this.m;
    }

    @Override
    @NotNull
    public List<Sensor<?>> getSensors() {
        return this.sensorsHandle.values().stream().map(ChipUtil1_21_R2::fromNMS).collect(Collectors.toList());
    }

    @Override
    public void addSensor(@NotNull Sensor<?> sensor) throws IllegalArgumentException {
        if (!new ChipUtil1_21_R2().existsSensor(sensor.getKey())) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(sensor.getKey()));
        }
        this.sensorsHandle.put(ChipUtil1_21_R2.toNMSType(sensor), ChipUtil1_21_R2.toNMS(sensor));
        this.save();
    }

    @Override
    public void removeSensor(@NotNull Sensor<?> sensor) {
        if (!new ChipUtil1_21_R2().existsSensor(sensor.getKey())) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(sensor.getKey()));
        }
        this.removeSensor(sensor.getKey());
    }

    @Override
    public void removeSensor(@NotNull NamespacedKey key) {
        if (!new ChipUtil1_21_R2().existsSensor(key)) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(key));
        }
        MinecraftKey keyH = ChipUtil1_21_R2.toNMS(key);
        Iterator<Map.Entry<SensorType<?>, net.minecraft.world.entity.ai.sensing.Sensor<?>>> it = this.sensorsHandle.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SensorType<?>, net.minecraft.world.entity.ai.sensing.Sensor<?>> entry = it.next();
            SensorType<?> currentType = entry.getKey();
            MinecraftKey currentKey = BuiltInRegistries.A.b(currentType);
            if (!currentKey.equals((Object)keyH)) continue;
            it.remove();
            break;
        }
        this.sensorsHandle.clear();
        this.sensorsHandle.putAll(ImmutableList.copyOf(it).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.save();
    }

    @Override
    public boolean hasSensor(@NotNull NamespacedKey key) {
        AtomicBoolean b = new AtomicBoolean(false);
        for (SensorType<?> t : this.sensorsHandle.keySet()) {
            MinecraftKey currentKey = BuiltInRegistries.A.b(t);
            if (!ChipUtil1_21_R2.toNMS(key).equals((Object)currentKey)) continue;
            b.set(true);
            break;
        }
        return b.get();
    }
}

