/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.ai.goal;

import java.util.function.Predicate;
import org.browsit.seaofsteves.libs.mobchip.ai.SpeedModifier;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Pathfinder;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Ranged;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathfinderMoveToBlock
extends Pathfinder
implements SpeedModifier,
Ranged {
    public static final int DEFAULT_RANGE = 25;
    private int range;
    private int vrange;
    private Predicate<Location> validBlock;
    private double speedMod;

    public PathfinderMoveToBlock(@NotNull Creature c) {
        this(c, null);
    }

    public PathfinderMoveToBlock(@NotNull Creature c, @Nullable Predicate<Location> validBlock) {
        this(c, validBlock, 1.5);
    }

    public PathfinderMoveToBlock(@NotNull Creature c, @Nullable Predicate<Location> validBlock, double speedMod) {
        this(c, validBlock, speedMod, 25);
    }

    public PathfinderMoveToBlock(@NotNull Creature c, @Nullable Predicate<Location> validBlock, double speedMod, int range) {
        this(c, validBlock, speedMod, range, range);
    }

    public PathfinderMoveToBlock(@NotNull Creature c, @Nullable Predicate<Location> validBlock, double speedMod, int range, int vrange) {
        super((Mob)c);
        this.speedMod = speedMod;
        this.validBlock = validBlock == null ? l -> true : validBlock;
        this.range = range;
        this.vrange = vrange;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    public float getVerticalRange() {
        return this.vrange;
    }

    public void setVerticalRange(int vrange) {
        this.vrange = vrange;
    }

    @Override
    public void setRange(float range) throws IllegalArgumentException {
        if (range > 2.1474836E9f) {
            throw new IllegalArgumentException("Range must be an integer");
        }
        this.range = (int)Math.floor(range);
    }

    @Override
    public double getSpeedModifier() {
        return this.speedMod;
    }

    @Override
    public void setSpeedModifier(double mod) {
        this.speedMod = mod;
    }

    @NotNull
    public Predicate<Location> getValidBlock() {
        return this.validBlock;
    }

    public void setValidBlock(@Nullable Predicate<Location> valid) {
        this.validBlock = valid == null ? l -> true : valid;
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.MOVEMENT, Pathfinder.PathfinderFlag.JUMPING};
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalGotoTarget";
    }
}

