/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.ai.goal;

import java.util.function.Predicate;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Conditional;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.Pathfinder;
import org.bukkit.Sound;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathfinderUseItem
extends Pathfinder
implements Conditional<Mob> {
    private Sound finishSound;
    private ItemStack item;
    private Predicate<Mob> requirements;

    public PathfinderUseItem(@NotNull Mob m, @NotNull ItemStack item, @NotNull Predicate<Mob> requirements) throws IllegalArgumentException {
        this(m, item, requirements, null);
    }

    public PathfinderUseItem(@NotNull Mob m, @NotNull ItemStack item, @NotNull Predicate<Mob> requirements, @Nullable Sound finishSound) throws IllegalArgumentException {
        super(m);
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        if (requirements == null) {
            throw new IllegalArgumentException("Requirements cannot be null");
        }
        this.item = item;
        this.requirements = requirements;
        this.finishSound = finishSound == null ? Sound.ENTITY_PLAYER_BURP : finishSound;
    }

    @NotNull
    public Sound getFinishSound() {
        return this.finishSound;
    }

    public void setFinishSound(@Nullable Sound s) {
        this.finishSound = s == null ? Sound.ENTITY_PLAYER_BURP : s;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(@NotNull ItemStack i) throws IllegalArgumentException {
        if (i == null) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        this.item = i;
    }

    @Override
    @NotNull
    public Predicate<Mob> getCondition() {
        return this.requirements;
    }

    @Override
    public void setCondition(@NotNull Predicate<Mob> req) throws IllegalArgumentException {
        if (req == null) {
            throw new IllegalArgumentException("Requirements cannot be null");
        }
        this.requirements = req;
    }

    @Override
    @NotNull
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[0];
    }

    @Override
    public String getInternalName() {
        return "PathfinderGoalUseItem";
    }
}

