/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.libs.mobchip.bosses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.browsit.seaofsteves.libs.mobchip.ai.attribute.AttributeInstance;
import org.browsit.seaofsteves.libs.mobchip.bosses.BossHandler;
import org.browsit.seaofsteves.libs.mobchip.bosses.annotations.Repeatable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Boss<T extends Mob> {
    public static final int DEFAULT_HEALTH = 20;
    @Nullable
    protected T mob;
    private static long idCounter = 0L;
    private static final Map<Long, Boss<?>> bosses = new HashMap();
    private Sound deathSound;
    private Sound spawnSound;
    private float volume;
    private float pitch;
    private double health = 20.0;
    private final Map<EquipmentSlot, ItemStack> equipment = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
    private final Map<AttributeInstance, Double> attributes = new HashMap<AttributeInstance, Double>();
    private final EntityType type;
    private final Plugin plugin;
    private final Class<T> mobClazz;
    private final BossHandler handler;
    protected final long id;

    protected Boss(@NotNull EntityType t, @NotNull Plugin plugin) throws IllegalArgumentException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin is null");
        }
        this.plugin = plugin;
        try {
            this.mobClazz = t.getEntityClass().asSubclass(Mob.class);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid EntityType: " + t.name());
        }
        this.type = t;
        this.mob = null;
        this.id = idCounter++;
        bosses.put(this.id, this);
        this.deathSound = Sound.ENTITY_WITHER_DEATH;
        this.spawnSound = Sound.ENTITY_WITHER_SPAWN;
        this.handler = new BossHandler(this, plugin);
    }

    @Nullable
    public static Boss<?> valueOf(long id) {
        for (Map.Entry<Long, Boss<?>> entry : bosses.entrySet()) {
            if (entry.getKey() != id) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static Boss<?> valueOf(@NotNull UUID uid) {
        if (uid == null) {
            return null;
        }
        for (Boss<?> boss : bosses.values()) {
            if (boss.getMob() == null || !boss.getMob().getUniqueId().equals(uid)) continue;
            return boss;
        }
        return null;
    }

    @Nullable
    public static <T extends Mob> Boss<T> valueOf(@NotNull T entity) {
        try {
            return Boss.valueOf(entity.getUniqueId());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @NotNull
    public final BossHandler getHandler() {
        return this.handler;
    }

    public final Class<T> getEntityClass() {
        return this.mobClazz;
    }

    public final EntityType getEntityType() {
        return this.type;
    }

    public final long getBossId() {
        return this.id;
    }

    public final void spawn(@NotNull Location l) {
        final Mob mob = (Mob)l.getWorld().spawn(l, this.getEntityClass());
        this.mob = mob;
        for (AttributeInstance attributeInstance : this.attributes.keySet()) {
            attributeInstance.setBaseValue(this.attributes.get(attributeInstance));
        }
        for (EquipmentSlot equipmentSlot : this.equipment.keySet()) {
            switch (equipmentSlot) {
                case HAND: {
                    mob.getEquipment().setItemInMainHand(this.equipment.get(equipmentSlot));
                    break;
                }
                case OFF_HAND: {
                    mob.getEquipment().setItemInOffHand(this.equipment.get(equipmentSlot));
                    break;
                }
                case FEET: {
                    mob.getEquipment().setBoots(this.equipment.get(equipmentSlot));
                    break;
                }
                case LEGS: {
                    mob.getEquipment().setLeggings(this.equipment.get(equipmentSlot));
                    break;
                }
                case CHEST: {
                    mob.getEquipment().setChestplate(this.equipment.get(equipmentSlot));
                    break;
                }
                case HEAD: {
                    mob.getEquipment().setHelmet(this.equipment.get(equipmentSlot));
                }
            }
        }
        if (this.spawnSound != null) {
            l.getWorld().playSound(l, this.deathSound, 3.0f, 1.0f);
        }
        final Boss inst = this;
        try {
            for (final Method m : this.getClass().getDeclaredMethods()) {
                m.setAccessible(true);
                if (m.getAnnotation(Repeatable.class) == null) continue;
                Repeatable r = m.getAnnotation(Repeatable.class);
                new BukkitRunnable(){

                    public void run() {
                        if (mob.isDead()) {
                            this.cancel();
                            return;
                        }
                        try {
                            m.invoke((Object)inst, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            Bukkit.getLogger().severe(e.getCause().getClass().getSimpleName());
                            Bukkit.getLogger().severe(e.getCause().getMessage());
                            for (StackTraceElement s : e.getCause().getStackTrace()) {
                                Bukkit.getLogger().severe(s.toString());
                            }
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().severe(e.getMessage());
                            for (StackTraceElement s : e.getStackTrace()) {
                                Bukkit.getLogger().severe(s.toString());
                            }
                        }
                    }
                }.runTaskTimer(this.plugin, r.delay(), r.interval());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CreatureSpawnEvent creatureSpawnEvent = new CreatureSpawnEvent((LivingEntity)mob, CreatureSpawnEvent.SpawnReason.CUSTOM);
        this.onSpawn(creatureSpawnEvent);
    }

    @NotNull
    public final Sound getDeathSound() {
        return this.deathSound;
    }

    public final void setDeathSound(@Nullable Sound s) {
        this.deathSound = s == null ? Sound.ENTITY_WITHER_DEATH : s;
    }

    @NotNull
    public final Sound getSpawnSound() {
        return this.spawnSound;
    }

    public final void setSpawnSound(@Nullable Sound s) {
        this.spawnSound = s == null ? s : Sound.ENTITY_WITHER_SPAWN;
    }

    public final float getSoundPitch() {
        return this.pitch;
    }

    public final float getSoundVolume() {
        return this.volume;
    }

    public final void setSoundPitch(float pitch) throws IllegalArgumentException {
        if (pitch < 2.0f || pitch > 2.0f) {
            throw new IllegalArgumentException("Pitch must be between -2F and 2F");
        }
        this.pitch = pitch;
    }

    public final void setSoundVolume(float volume) throws IllegalArgumentException {
        if (volume < 0.0f) {
            throw new IllegalArgumentException("Volume must be more than or equal to 0");
        }
        this.volume = volume;
    }

    @Nullable
    public final T getMob() {
        return this.mob;
    }

    @NotNull
    public final Map<AttributeInstance, Double> getAttributes() {
        return this.attributes;
    }

    public final double getHealth() {
        return this.health;
    }

    public final void setHealth(double health) {
        this.health = health;
    }

    public final void addAttribute(@NotNull AttributeInstance inst, double value) {
        this.attributes.put(inst, value);
    }

    public final void removeAttribute(@NotNull AttributeInstance inst) {
        this.attributes.remove(inst);
    }

    @NotNull
    public final Map<EquipmentSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    public final void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        if (item == null) {
            return;
        }
        this.equipment.put(slot, item);
    }

    public final void setHelmet(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.HEAD, item);
    }

    public final void setChestplate(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.CHEST, item);
    }

    public final void setLeggings(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.LEGS, item);
    }

    public final void setBoots(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.FEET, item);
    }

    public final void setMainhand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.HAND, item);
    }

    public final void setOffhand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.OFF_HAND, item);
    }

    public abstract List<ItemStack> getDrops();

    public void onSpawn(CreatureSpawnEvent e) {
    }

    public void onDeath(EntityDeathEvent death) {
    }

    public void onDamageDefensive(EntityDamageEvent e) {
    }

    public void onDamageOffensive(EntityDamageByEntityEvent e) {
    }
}

