/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import java.util.Random;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.api.event.PirateEnemyPlunderedEvent;
import org.browsit.seaofsteves.settings.ChanceSettings;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.ItemUtil;
import org.browsit.seaofsteves.util.TerraUtil;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    private final SeaOfSteves plugin;
    private final ChanceSettings chance;
    private final ConfigSettings config;
    private final GearSettings gear;
    private final Random random = new Random();

    public EntityListener(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.chance = plugin.getChanceSettings();
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        String terraBiomeID;
        if (!this.config.isCreatureEnabled()) {
            return;
        }
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.CUSTOM) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SLIME_SPLIT)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!WorldUtil.isAllowedWorld(entity.getWorld().getName())) {
            return;
        }
        if (entity.getLocation().getBlock().getType().equals((Object)Material.WATER)) {
            return;
        }
        if (!(entity instanceof Enemy)) {
            return;
        }
        if (entity.getLocation().getBlockY() < 36) {
            event.setCancelled(true);
            return;
        }
        if (entity.getType().equals((Object)EntityType.DROWNED) && this.random.nextInt(this.chance.getOceanSpawnDrowned()) == 1) {
            event.setCancelled(true);
            return;
        }
        if (entity.getType().equals((Object)EntityType.PILLAGER) || entity.getType().equals((Object)EntityType.RAVAGER)) {
            return;
        }
        event.setCancelled(true);
        try {
            terraBiomeID = TerraUtil.getTerraBiome(entity.getLocation()).getID();
        }
        catch (NoClassDefFoundError e) {
            this.plugin.getLogger().severe("This build of Terra is incompatible with your server environment. Did you accidentally install a Fabric version?");
            return;
        }
        String bossBiome = this.plugin.getBossSettings().getKingBlazeBiome();
        if (terraBiomeID.equals("VOLCANO_BASE_EDGE") || terraBiomeID.startsWith(bossBiome)) {
            return;
        }
        if (terraBiomeID.startsWith("VOLCAN")) {
            if (entity.getType().equals((Object)EntityType.WITCH)) {
                entity.getWorld().spawnEntity(entity.getLocation(), EntityType.BLAZE);
            } else if (entity.getType().equals((Object)EntityType.ENDERMAN)) {
                Entity wSkel = entity.getWorld().spawnEntity(entity.getLocation(), EntityType.WITHER_SKELETON);
                wSkel.setCustomName(null);
            } else if (entity.getType().equals((Object)EntityType.SKELETON) && this.random.nextInt(this.chance.getVolcanoSpawnMagmaCube()) == 1) {
                entity.getWorld().spawnEntity(entity.getLocation(), EntityType.MAGMA_CUBE);
            }
            return;
        }
        if (entity.getType().equals((Object)EntityType.ENDERMAN)) {
            Skeleton skel = (Skeleton)entity.getWorld().spawnEntity(entity.getLocation(), EntityType.SKELETON);
            if (this.random.nextInt(this.chance.getIslandSpawnSkeletonWithBow()) != 1) {
                AttributeInstance ai = skel.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (skel.getEquipment() != null && ai != null) {
                    ai.setBaseValue(10.0);
                    skel.getEquipment().setItemInMainHand(new ItemStack(Material.WOODEN_SWORD));
                }
            }
        } else if (entity.getType().equals((Object)EntityType.WITCH) && this.random.nextInt(this.chance.getIslandSpawnCaptain()) == 1) {
            Entity captain = entity.getWorld().spawnEntity(entity.getLocation(), EntityType.WITHER_SKELETON);
            captain.setCustomName(ChatColor.RED + this.config.getCreatureNameCaptain());
            captain.setCustomNameVisible(true);
        }
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getWorld().getName())) {
            return;
        }
        if (!this.config.isMerchantEnabled()) {
            return;
        }
        for (Entity entity : event.getEntities()) {
            if (!(entity instanceof Villager)) continue;
            entity.setCustomName(this.config.getMerchantName());
            entity.setCustomNameVisible(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.config.isMerchantEnabled()) {
            return;
        }
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER) {
            event.setCancelled(true);
            event.getEntity().setFireTicks(0);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.config.canGeneralBlockExplode()) {
            event.blockList().clear();
            return;
        }
        for (Block block : event.blockList()) {
            if (block.getType() != Material.CHEST) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (ItemUtil.isGear(event.getItem().getItemStack())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityBreedEvent(EntityBreedEvent event) {
        if (!this.config.isMerchantEnabled()) {
            return;
        }
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getMother() instanceof Villager) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (this.config.isCreatureEnabled() && event.getEntity().getType().equals((Object)EntityType.WITHER_SKELETON) && event.getEntity().getCustomName() != null && event.getEntity().getCustomName().equals(ChatColor.RED + "Captain")) {
            ItemUtil.addItem(event.getEntity().getKiller(), new ItemStack(Material.GOLD_NUGGET));
        }
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity().getKiller();
            if (player == null) {
                return;
            }
            Player plundered = (Player)event.getEntity();
            PirateEnemyPlunderedEvent pEvent = new PirateEnemyPlunderedEvent(this.plugin.getPirate(player.getUniqueId()), this.plugin.getPirate(plundered.getUniqueId()));
            this.plugin.getServer().getPluginManager().callEvent((Event)pEvent);
        }
    }
}

