/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import com.ticxo.modelengine.api.events.ModelDismountEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.depend.Dependencies;
import org.browsit.seaofsteves.gear.type.PirateEmpty;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.EntityUtil;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.ItemUtil;
import org.browsit.seaofsteves.util.NBTAPI;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;

public class MythicListener
implements Listener {
    private final SeaOfSteves plugin;
    private final Dependencies depends;
    private final ConfigSettings config;
    private final GearSettings gear;
    private final FoliaLib foliaLib;

    public MythicListener(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.depends = plugin.getDependencies();
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
        this.foliaLib = plugin.getFoliaLib();
    }

    @EventHandler
    public void onVehiclePlace(EntityPlaceEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled() || !this.config.isVotsEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Boat)) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!EntityUtil.isShipAllowedOrCancel(event)) {
            return;
        }
        NBTAPI.addNBT(event.getEntity(), "sos_owner", player.getUniqueId().toString());
        event.setCancelled(true);
        boolean isPlayerNearby = false;
        for (Entity nearby : event.getEntity().getNearbyEntities(7.0, 7.0, 7.0)) {
            if (!(nearby instanceof Player)) continue;
            if (isPlayerNearby) {
                IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.RED + IO.getLang("nearbyPlayerLimit"));
                return;
            }
            isPlayerNearby = true;
        }
        if (this.depends.getMythicCrucible() == null) {
            this.plugin.getLogger().severe("VOTS is enabled, but MythicCrucible is not installed!");
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.RED + "Unable to set sail. Notify an administrator!");
            return;
        }
        String shipType = NBTAPI.getNBT(player.getInventory().getItemInMainHand(), "sos_type");
        if (shipType == null) {
            this.plugin.getLogger().severe("Missing ship type from player of UUID " + player.getUniqueId());
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.RED + IO.getLang("problemOccurred"));
            return;
        }
        if (!event.getBlock().getLocation().add(0.0, -2.0, 0.0).getBlock().isLiquid()) {
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.RED + IO.getLang("placeShipFarther"));
            return;
        }
        Optional opt = this.depends.getMythicMobs().getSkillManager().getSkill("VOTS" + shipType + "Summon");
        if (opt.isPresent()) {
            BukkitEntity bukkitEntity = new BukkitEntity((Entity)player);
            SkillCaster c = this.depends.getMythicMobs().getSkillManager().getCaster((AbstractEntity)bukkitEntity);
            SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.API, c, (AbstractEntity)bukkitEntity);
            ((Skill)opt.get()).execute((SkillMetadata)meta);
        }
        player.getInventory().setItem(this.gear.getDingySlot(), PirateEmpty.get(player));
    }

    @EventHandler
    public void onMythicMount(PlayerInteractEntityEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.config.isVotsEnabled()) {
            return;
        }
        String name = ChatColor.stripColor((String)event.getRightClicked().getName());
        if (!this.config.getVotsShips().contains(name)) {
            return;
        }
        ItemUtil.renewGearNaval(event.getPlayer(), ChatColor.stripColor((String)event.getRightClicked().getName()));
    }

    @EventHandler
    public void onMythicDismount(ModelDismountEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPassenger().getWorld().getName())) {
            return;
        }
        if (!this.config.isVotsEnabled()) {
            return;
        }
        if (!(event.getPassenger() instanceof Player)) {
            return;
        }
        ActiveModel am = event.getVehicle();
        Object name = am.getBlueprint().getName().toLowerCase().replace("elitecreatures", "");
        String firstLetter = ((String)name).substring(0, 1).toUpperCase();
        name = firstLetter + ((String)name).substring(1);
        if (this.config.getVotsShips().contains(name) && this.depends.getMythicMobs() != null) {
            Player player = (Player)event.getPassenger();
            ItemStack dir = this.depends.getMythicMobs().getItemManager().getItemStack("VOTSDirectionControler");
            ItemStack spe = this.depends.getMythicMobs().getItemManager().getItemStack("VOTSSpecialControler");
            for (ItemStack i : player.getInventory().getContents()) {
                if (i != null && i.getItemMeta() != null && i.getItemMeta().getLore() != null && i.getItemMeta().getLore().equals(dir.getItemMeta().getLore())) {
                    this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> player.getInventory().remove(i), 20L);
                    continue;
                }
                if (i == null || i.getItemMeta() == null || i.getItemMeta().getLore() == null || !i.getItemMeta().getLore().equals(spe.getItemMeta().getLore())) continue;
                this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> player.getInventory().remove(i), 20L);
            }
            ItemUtil.renewGear(player, false);
        }
    }

    @EventHandler
    public void onMythicSpawn(MythicMobSpawnEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.config.isVotsEnabled()) {
            return;
        }
        if (event.getMob().getDisplayName() != null && !this.config.getVotsShips().contains(ChatColor.stripColor((String)event.getMob().getDisplayName()))) {
            return;
        }
        if (!event.getSpawnReason().equals((Object)SpawnReason.SUMMON)) {
            return;
        }
        List nearbyEntities = event.getEntity().getNearbyEntities(7.0, 7.0, 7.0);
        ArrayList<Player> nearbyPlayers = new ArrayList<Player>();
        for (Entity nearby : nearbyEntities) {
            if (!(nearby instanceof Player)) continue;
            nearbyPlayers.add((Player)nearby);
        }
        if (nearbyPlayers.size() != 1) {
            event.setCancelled(true);
            return;
        }
        Iterator iterator = nearbyPlayers.iterator();
        if (iterator.hasNext()) {
            Entity nearby;
            nearby = (Player)iterator.next();
            NBTAPI.addNBT(event.getEntity(), "sos_owner", nearby.getUniqueId().toString());
            return;
        }
    }

    @EventHandler
    public void onMythicDespawn(MythicMobDespawnEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled()) {
            return;
        }
        if (event.getMob().getDisplayName() != null && !this.config.getVotsShips().contains(ChatColor.stripColor((String)event.getMob().getDisplayName()))) {
            return;
        }
        this.rip(event.getEntity());
    }

    @EventHandler
    public void onMythicDeath(MythicMobDeathEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled()) {
            return;
        }
        if (event.getMob().getDisplayName() != null && !this.config.getVotsShips().contains(ChatColor.stripColor((String)event.getMob().getDisplayName()))) {
            return;
        }
        this.rip(event.getEntity());
    }

    public void rip(Entity boat) {
        if (NBTAPI.hasNBT(boat, "sos_owner")) {
            String owner = NBTAPI.getNBT(boat, "sos_owner");
            if (owner == null) {
                return;
            }
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(owner));
            if (player == null) {
                return;
            }
            IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.RED + IO.getLang("bonVoyage"));
            this.plugin.getFoliaLib().getScheduler().runAtEntityLater((Entity)player, () -> ItemUtil.renewGear(player, true), 2L);
        }
    }
}

