/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLootChest;
import com.codisimus.plugins.phatloots.PhatLoots;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.api.event.PirateFishCaughtEvent;
import org.browsit.seaofsteves.api.event.PirateOpenTreasureEvent;
import org.browsit.seaofsteves.api.event.PirateSellTreasureEvent;
import org.browsit.seaofsteves.boss.lavablock.Tephra;
import org.browsit.seaofsteves.depend.Dependencies;
import org.browsit.seaofsteves.gear.type.boat.PirateDingy;
import org.browsit.seaofsteves.gear.type.boat.PirateFireball;
import org.browsit.seaofsteves.gear.type.boat.PirateSurveyor;
import org.browsit.seaofsteves.gear.type.hand.PirateDiviningRod;
import org.browsit.seaofsteves.gear.type.hand.PirateFishingRod;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.libs.mobchip.EntityBrain;
import org.browsit.seaofsteves.libs.mobchip.ai.EntityAI;
import org.browsit.seaofsteves.libs.mobchip.ai.goal.PathfinderMeleeAttack;
import org.browsit.seaofsteves.libs.mobchip.bukkit.BukkitBrain;
import org.browsit.seaofsteves.player.Pirate;
import org.browsit.seaofsteves.settings.BossSettings;
import org.browsit.seaofsteves.settings.ChanceSettings;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.ItemUtil;
import org.browsit.seaofsteves.util.NBTAPI;
import org.browsit.seaofsteves.util.TerraUtil;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.StructureType;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PlayerListener
implements Listener {
    private final SeaOfSteves plugin;
    private final Dependencies depends;
    private final BossSettings bosses;
    private final ChanceSettings chance;
    private final ConfigSettings config;
    private final GearSettings gear;
    private final FoliaLib foliaLib;
    private final ConcurrentHashMap<UUID, Long> lastEnteredOcean = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Long> lastEnteredVolcano = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Long> lastKilledBoss = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, BossBar> bossBars = new ConcurrentHashMap();
    public static final List<String> BOAT_TYPE = Arrays.asList("OAK_BOAT", "ACACIA_BOAT", "BIRCH_BOAT", "CHERRY_BOAT", "DARK_OAK_BOAT", "JUNGLE_BOAT", "MANGROVE_BOAT", "BAMBOO_RAFT");
    public static List<String> VOTS_TYPE = null;
    private final Random random = new Random();

    public PlayerListener(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.depends = plugin.getDependencies();
        this.bosses = plugin.getBossSettings();
        this.chance = plugin.getChanceSettings();
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
        this.foliaLib = plugin.getFoliaLib();
        VOTS_TYPE = new ArrayList<String>(this.config.getVotsShips());
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            ItemUtil.renewInventory(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            Pirate pirate = new Pirate(player.getUniqueId());
            if (!this.plugin.getAllPirates().contains(pirate)) {
                this.plugin.addPirate(pirate);
            }
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || !ItemUtil.isGear(item) || !NBTAPI.hasNBT(item, "sos_world")) continue;
                if (!player.getWorld().getUID().toString().equals(NBTAPI.getNBT(item, "sos_owner"))) {
                    player.getInventory().clear();
                    IO.sendMessage(player, ChatMessageType.CHAT, IO.getLang("worldNew"));
                    break;
                }
                IO.sendMessage(player, ChatMessageType.CHAT, IO.getLang("worldBack"));
                break;
            }
            ItemUtil.renewInventory(player);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            ItemUtil.renewInventory(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerSwapHandItem(PlayerSwapHandItemsEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getWhoClicked().getWorld().getName())) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory().getType() == InventoryType.PLAYER && event.getSlot() >= 0 && event.getSlot() <= 8) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isFlying()) {
            return;
        }
        Biome biome = TerraUtil.getBukkitBiome(event.getPlayer().getLocation());
        if (biome == null) {
            return;
        }
        if (player.isInWater() || this.isLikelyInWater(player)) {
            if (biome.equals((Object)Biome.DEEP_LUKEWARM_OCEAN) || biome.equals((Object)Biome.DEEP_FROZEN_OCEAN) || biome.equals((Object)Biome.DEEP_COLD_OCEAN) || biome.equals((Object)Biome.DEEP_OCEAN) || biome.equals((Object)Biome.WARM_OCEAN) || biome.equals((Object)Biome.FROZEN_OCEAN) || biome.equals((Object)Biome.COLD_OCEAN) || biome.equals((Object)Biome.OCEAN)) {
                for (Entity nearby : player.getNearbyEntities(4.0, 4.0, 4.0)) {
                    if (!(nearby instanceof Zombie) || !nearby.getName().contains("Catamaran") || !player.getLocation().add(0.0, -2.0, 0.0).getBlock().isLiquid()) continue;
                    return;
                }
                if (!this.lastEnteredOcean.containsKey(player.getUniqueId())) {
                    this.lastEnteredOcean.put(player.getUniqueId(), System.currentTimeMillis());
                    return;
                }
                if (System.currentTimeMillis() - this.lastEnteredOcean.get(player.getUniqueId()) > 5000L) {
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.RED + IO.getLang("moveSharkWatch"));
                }
                if (System.currentTimeMillis() - this.lastEnteredOcean.get(player.getUniqueId()) > 11000L) {
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.DARK_RED + IO.getLang("moveSharkWarning"));
                }
                if (System.currentTimeMillis() - this.lastEnteredOcean.get(player.getUniqueId()) > 20000L) {
                    Dolphin shark = (Dolphin)player.getWorld().spawnEntity(player.getLocation(), EntityType.DOLPHIN);
                    shark.setTarget((LivingEntity)player);
                    try {
                        EntityBrain brain = BukkitBrain.getBrain((Mob)shark);
                        EntityAI target = brain.getTargetAI();
                        PathfinderMeleeAttack meleeAttack = new PathfinderMeleeAttack((Creature)shark, 1.0);
                        target.put(meleeAttack, 0);
                    }
                    catch (NoClassDefFoundError e) {
                        shark.remove();
                        this.plugin.getLogger().warning("Sharks are not yet supported on this server version!");
                    }
                    this.lastEnteredOcean.put(player.getUniqueId(), System.currentTimeMillis() - 11001L);
                }
            }
        } else {
            com.dfsek.terra.api.world.biome.Biome terraBiome;
            if (this.lastEnteredOcean.containsKey(player.getUniqueId())) {
                for (Entity nearby : player.getNearbyEntities(30.0, 20.0, 30.0)) {
                    if (!(nearby instanceof Dolphin)) continue;
                    nearby.remove();
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.YELLOW + IO.getLang("moveSharkFailed"));
                }
            }
            this.lastEnteredOcean.remove(player.getUniqueId());
            if (this.bosses.isKingBlazeEnabled() && (terraBiome = TerraUtil.getTerraBiome(event.getTo())) != null) {
                boolean hasBossNearby;
                String terraBiomeID = terraBiome.getID();
                String bossBiome = this.bosses.getKingBlazeBiome();
                String bossName = this.bosses.getKingBlazeName();
                if (terraBiomeID.equals("VOLCANIC_COAST") || terraBiomeID.equals("VOLCANIC_ISLAND")) {
                    if (!this.config.isEruptionEnabled()) {
                        return;
                    }
                    if (!(this.lastKilledBoss.containsKey(player.getUniqueId()) && System.currentTimeMillis() - this.lastKilledBoss.get(player.getUniqueId()) <= 1800000L || this.random.nextInt(50) != 1)) {
                        IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.RED + IO.getLang("moveKeepMoving"));
                        new Tephra(this.plugin, player.getLocation());
                    }
                }
                if (terraBiomeID.equals("VOLCANO_BASE_EDGE") || terraBiomeID.startsWith(bossBiome)) {
                    if (!this.lastEnteredVolcano.containsKey(player.getUniqueId())) {
                        this.lastEnteredVolcano.put(player.getUniqueId(), System.currentTimeMillis());
                        IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.YELLOW + IO.getLang("moveBossApproach"));
                        return;
                    }
                    hasBossNearby = false;
                    for (Entity nearby : player.getNearbyEntities(70.0, 25.0, 70.0)) {
                        if (!NBTAPI.hasNBT(nearby, "sos_boss") || !nearby.getType().equals((Object)EntityType.BLAZE)) continue;
                        if (!TerraUtil.getTerraBiome(nearby.getLocation()).getID().equals(bossBiome)) {
                            this.bossBars.get(nearby.getUniqueId()).removeAll();
                            this.bossBars.remove(nearby.getUniqueId());
                            nearby.remove();
                            IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.RED + IO.getLang("moveBossRetreated"));
                            this.plugin.getLogger().info("Despawned " + bossName + " by player of UUID " + player.getUniqueId());
                            return;
                        }
                        hasBossNearby = true;
                        break;
                    }
                    if (!hasBossNearby && (System.currentTimeMillis() - this.lastEnteredVolcano.get(player.getUniqueId()) > 600000L || this.lastKilledBoss.containsKey(player.getUniqueId()) && System.currentTimeMillis() - this.lastKilledBoss.get(player.getUniqueId()) > 900000L)) {
                        IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.YELLOW + IO.getLang("moveBossApproach"));
                    }
                }
                if (terraBiomeID.equals(bossBiome)) {
                    if (!this.lastKilledBoss.containsKey(player.getUniqueId())) {
                        this.lastKilledBoss.put(player.getUniqueId(), System.currentTimeMillis() - 1000000L);
                        return;
                    }
                    if (System.currentTimeMillis() - this.lastKilledBoss.get(player.getUniqueId()) > 900000L) {
                        hasBossNearby = false;
                        for (Entity nearby : player.getNearbyEntities(50.0, 25.0, 50.0)) {
                            if (!NBTAPI.hasNBT(nearby, "sos_boss")) continue;
                            hasBossNearby = true;
                            break;
                        }
                        if (!hasBossNearby) {
                            Location toSpawn = TerraUtil.getTerraBiomeCenter(terraBiome, event.getTo());
                            LivingEntity boss = null;
                            if (this.depends.getMythicMobs() != null && !this.bosses.getKingBlazeMythic().equals("NAME_OF_MOB_TO_USE_INSTEAD")) {
                                MythicMob mythicMob = this.depends.getMythicMobs().getMobManager().getMythicMob(this.bosses.getKingBlazeMythic()).orElse(null);
                                if (mythicMob != null) {
                                    ActiveMob activeMob = mythicMob.spawn(BukkitAdapter.adapt((Location)toSpawn), 1.0);
                                    boss = (LivingEntity)activeMob.getEntity().getBukkitEntity();
                                }
                            } else {
                                boss = (LivingEntity)player.getWorld().spawnEntity(toSpawn, EntityType.BLAZE);
                                boss.setCustomName(bossName);
                                boss.setCustomNameVisible(this.bosses.canKingBlazeUseNameTag());
                                boss.getAttribute(Attribute.GENERIC_SCALE).setBaseValue(this.bosses.getKingBlazeScale());
                                double health = this.bosses.getKingBlazeHealth();
                                boss.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
                                boss.setHealth(health);
                                if (this.bosses.canKingBlazeUseBossBar()) {
                                    BossBar bar = this.plugin.getServer().createBossBar(bossName, BarColor.RED, BarStyle.SOLID, new BarFlag[0]);
                                    bar.setProgress(1.0);
                                    for (Entity nearby : boss.getNearbyEntities(50.0, 25.0, 50.0)) {
                                        if (!(nearby instanceof Player)) continue;
                                        bar.addPlayer((Player)nearby);
                                    }
                                    this.bossBars.put(boss.getUniqueId(), bar);
                                }
                            }
                            if (boss == null) {
                                this.plugin.getLogger().severe("Unable to spawn king-blaze boss. Check boss.yml?");
                                return;
                            }
                            NBTAPI.addNBT((Entity)boss, "sos_boss", bossName);
                            this.plugin.getLogger().info(bossName + " spawned by player of UUID " + player.getUniqueId());
                        }
                    }
                }
            }
            if (this.gear.isDiviningRodEnabled() && PirateDiviningRod.equals(player.getInventory().getItemInMainHand())) {
                this.runDetector(event.getTo(), player);
            }
        }
    }

    @EventHandler
    public void onBossDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!WorldUtil.isAllowedWorld(entity.getWorld().getName())) {
            return;
        }
        if (!NBTAPI.hasNBT(entity, "sos_boss")) {
            return;
        }
        if (!this.bosses.getKingBlazeMythic().equals("NAME_OF_MOB_TO_USE_INSTEAD")) {
            return;
        }
        if (entity instanceof Blaze) {
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.DROWNING)) {
                event.setCancelled(true);
                return;
            }
            UUID uuid = entity.getUniqueId();
            if (this.bosses.canKingBlazeUseBossBar() && this.bossBars.containsKey(uuid)) {
                Blaze blaze = (Blaze)entity;
                double normalized = (blaze.getHealth() - event.getDamage()) / blaze.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue();
                normalized = Math.max(0.0, normalized);
                normalized = Math.min(1.0, normalized);
                this.bossBars.get(uuid).setProgress(normalized);
            }
        }
    }

    @EventHandler
    public void onBossDeathByPlayer(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!WorldUtil.isAllowedWorld(entity.getWorld().getName())) {
            return;
        }
        if (!NBTAPI.hasNBT((Entity)entity, "sos_boss")) {
            return;
        }
        if (entity.getKiller() == null) {
            for (Entity nearby : entity.getNearbyEntities(50.0, 25.0, 20.0)) {
                if (!(nearby instanceof Player)) continue;
                IO.sendMessage((Player)nearby, ChatMessageType.CHAT, ChatColor.YELLOW + IO.getLang("bossUnknown"));
                this.plugin.getLogger().warning("Boss died somehow near player of UUID " + nearby.getUniqueId());
            }
            return;
        }
        Player player = entity.getKiller();
        IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.GREEN + IO.getLang("bossDefeated").replace("<time>", this.plugin.getResetTimer().formatTime(this.plugin.getBossSettings().getKingBlazeRespawn()).replace("0d ", "").replace("0h ", "").replace("0m ", "")));
        this.lastKilledBoss.put(player.getUniqueId(), System.currentTimeMillis());
        if (!this.bosses.getKingBlazeMythic().equals("NAME_OF_MOB_TO_USE_INSTEAD")) {
            return;
        }
        if (entity instanceof Blaze) {
            Material material = Material.getMaterial((String)this.bosses.getKingBlazeDrop());
            if (material != null) {
                ItemUtil.addItem(player, new ItemStack(material));
            } else {
                this.plugin.getLogger().severe("Invalid king-blaze drop material " + this.bosses.getKingBlazeDrop());
            }
        }
        if (this.bosses.canKingBlazeUseBossBar() && this.bossBars.containsKey(entity.getUniqueId())) {
            this.bossBars.get(entity.getUniqueId()).removeAll();
            this.bossBars.remove(entity.getUniqueId());
        }
    }

    private boolean isLikelyInWater(Player player) {
        if (!player.isInsideVehicle()) {
            for (Entity nearby : player.getNearbyEntities(1.0, 1.0, 1.0)) {
                if (!(nearby instanceof Boat) || !player.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER)) continue;
                return false;
            }
        }
        return !player.isInsideVehicle() && !player.isSneaking() && player.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER);
    }

    private void runDetector(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Location underFoot = new Location(world, location.getX(), location.getY() - 1.0, location.getZ());
        Material ground = world.getBlockAt(underFoot).getType();
        if (ground.isAir()) {
            return;
        }
        if (!ground.equals((Object)Material.SAND)) {
            IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.GRAY + IO.getLang("moveDetectSand"));
            return;
        }
        int centerX = underFoot.getBlockX();
        int centerY = underFoot.getBlockY();
        int centerZ = underFoot.getBlockZ();
        int radius = 9;
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int y = centerY - 6; y <= centerY; ++y) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) continue;
                    Location chestSurface = new Location(world, (double)x, location.getY(), (double)z);
                    double distance = location.distance(chestSurface);
                    if (distance > (double)radius) {
                        distance = 9.0;
                    }
                    double soundPitch = (double)radius / distance / 10.0 + 1.0;
                    player.playSound(block.getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, 1.0f, (float)soundPitch);
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, this.getDetectorMsg(distance));
                    return;
                }
            }
        }
        IO.sendMessage(player, ChatMessageType.ACTION_BAR, IO.getLang("moveDetectFailed"));
    }

    private String getDetectorMsg(double distance) {
        if (distance < 1.5) {
            return ChatColor.RED + IO.getLang("moveDetectDig");
        }
        if (distance < 5.0) {
            return ChatColor.YELLOW + IO.getLang("moveDetectCloser");
        }
        return ChatColor.GREEN + IO.getLang("moveDetectNearby");
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.NAME_TAG)) {
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.RED + IO.getLang("interactMerchantTag"));
            event.setCancelled(true);
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            if (this.config.isMerchantEnabled()) {
                event.setCancelled(true);
                this.sellTreasure(player, event.getRightClicked());
            }
        } else if (event.getRightClicked().getType() == EntityType.CHEST_MINECART) {
            event.setCancelled(true);
        }
    }

    private void sellTreasure(Player player, Entity merchant) {
        boolean useVault = this.config.canMerchantUseVault() && this.depends.isPluginAvailable("Vault");
        int totalWorth = 0;
        for (ItemStack itemStack : player.getInventory().getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || ItemUtil.isGear(itemStack)) continue;
            for (ItemStack lootItem : ItemUtil.getLootItems()) {
                if (!lootItem.isSimilar(itemStack)) continue;
                totalWorth += itemStack.getAmount() * this.config.getMerchantReward();
                player.getInventory().remove(itemStack);
            }
        }
        if (totalWorth > 0) {
            Pirate pirate = this.plugin.getPirate(player.getUniqueId());
            pirate.setGoldEarned(pirate.getGoldEarned() + totalWorth);
            if (useVault) {
                this.depends.getVaultEconomy().depositPlayer((OfflinePlayer)player, (double)totalWorth);
            }
            String amount = useVault ? this.depends.getVaultEconomy().format((double)totalWorth) : String.valueOf(totalWorth);
            String points = useVault ? "" : IO.getLang("interactMerchantPoints");
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.GREEN + IO.getLang("interactMerchantSold").replace("<name>", this.config.getMerchantName()).replace("<amount>", amount).replace("<points>", points));
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_CLUSTER_HIT, 1.0f, 1.0f);
            PirateSellTreasureEvent pEvent = new PirateSellTreasureEvent(this.plugin.getPirate(player.getUniqueId()), merchant, totalWorth);
            this.plugin.getServer().getPluginManager().callEvent((Event)pEvent);
            this.plugin.getLogger().info(player.getName() + " sold all treasures to " + this.config.getMerchantName() + " for " + amount + " points");
        } else {
            IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.YELLOW + IO.getLang("interactMerchantFailed"));
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void onPlayerInteract(PlayerInteractEvent event) {
        block32: {
            ItemStack hand;
            Player player;
            block30: {
                boolean isInOrOnVotsShip;
                boolean isInDingy;
                block33: {
                    block31: {
                        String mythic;
                        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
                            return;
                        }
                        player = event.getPlayer();
                        hand = player.getInventory().getItemInMainHand();
                        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) break block30;
                        if (this.depends.getMythicMobs() != null && this.depends.getMythicMobs().getItemManager().isMythicItem(hand) && ((mythic = this.depends.getMythicMobs().getItemManager().getMythicTypeFromItem(hand)).startsWith("VOTSMediumShipRepair") || mythic.equals("VOTSAmmoCannonBall"))) {
                            int slot = player.getInventory().getHeldItemSlot();
                            ItemStack replace = this.depends.getMythicMobs().getItemManager().getItemStack(mythic);
                            this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> player.getInventory().setItem(slot, replace), 2L);
                            return;
                        }
                        Block clickedBlock = event.getClickedBlock();
                        isInDingy = player.getVehicle() != null && player.getVehicle() instanceof Boat;
                        isInOrOnVotsShip = false;
                        Biome biome = TerraUtil.getBukkitBiome(event.getPlayer().getLocation());
                        if (biome == null) {
                            return;
                        }
                        if (this.isWaterBiome(biome)) {
                            String mythic2;
                            for (Entity e : player.getNearbyEntities(4.0, 4.0, 4.0)) {
                                if (!(e instanceof Zombie) || !VOTS_TYPE.contains(ChatColor.stripColor((String)e.getName())) || e.isCustomNameVisible() || !e.getTrackedBy().contains(player)) continue;
                                isInOrOnVotsShip = true;
                                break;
                            }
                            if (isInOrOnVotsShip && this.depends.getMythicMobs() != null && this.depends.getMythicMobs().getItemManager().isMythicItem(hand) && (mythic2 = this.depends.getMythicMobs().getItemManager().getMythicTypeFromItem(hand)).equals("VOTSDirectionControler")) {
                                this.rollForEnemyVotsShipSpawn(player);
                                return;
                            }
                        }
                        if (clickedBlock == null || !clickedBlock.getType().equals((Object)Material.CHEST) && !clickedBlock.getType().equals((Object)Material.TRAPPED_CHEST) && !clickedBlock.getType().equals((Object)Material.BARREL)) break block31;
                        if (!this.config.isPhatLootEnabled() || this.depends.getPhatLoots() == null) break block32;
                        if (!this.depends.isPluginAvailable("PhatLoots")) {
                            this.plugin.getLogger().severe("Unable to find PhatLoots for integration");
                            return;
                        }
                        event.setCancelled(true);
                        PhatLoot phatLoot = null;
                        if (clickedBlock.getType().equals((Object)Material.CHEST) || clickedBlock.getType().equals((Object)Material.TRAPPED_CHEST)) {
                            phatLoot = PhatLoots.getPhatLoot((String)this.config.getPhatLootNameChest());
                        } else if (clickedBlock.getType().equals((Object)Material.BARREL)) {
                            phatLoot = PhatLoots.getPhatLoot((String)this.config.getPhatLootNameBarrel());
                        }
                        if (phatLoot == null) {
                            this.plugin.getLogger().severe("Invalid name of PhatLoot in config: " + this.config.getPhatLootNameChest());
                            return;
                        }
                        PhatLootChest chest = PhatLootChest.getChest((Block)clickedBlock);
                        if (phatLoot.getName().equals("SampleLoot") && phatLoot.hours == 0) {
                            phatLoot.hours = 12;
                        }
                        try {
                            phatLoot.rollForChestLoot(player, chest, IO.getLang("interactChestTitle"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Location loc = chest.getBlock().getLocation();
                        if (loc.getWorld() == null) {
                            return;
                        }
                        PirateOpenTreasureEvent pEvent = new PirateOpenTreasureEvent(this.plugin.getPirate(player.getUniqueId()), clickedBlock, phatLoot.getName());
                        this.plugin.getServer().getPluginManager().callEvent((Event)pEvent);
                        this.plugin.getLogger().info(player.getName() + " opened treasure at [" + loc.getWorld().getName() + "]" + loc.getX() + ", " + loc.getY() + ", " + loc.getZ());
                        break block32;
                    }
                    if (!this.gear.isFireballEnabled() || !PirateFireball.equals(hand)) break block33;
                    event.setCancelled(true);
                    if (isInDingy || isInOrOnVotsShip) {
                        if (ItemUtil.isOnCooldown(player, event.getMaterial())) {
                            return;
                        }
                        player.playSound(player.getLocation(), Sound.ITEM_FIRECHARGE_USE, 1.0f, 1.0f);
                        ((Fireball)event.getPlayer().launchProjectile(Fireball.class)).setVelocity(event.getPlayer().getLocation().getDirection().multiply(2.0));
                    } else {
                        IO.sendMessage(player, ChatMessageType.ACTION_BAR, IO.getLang("waterDistanceLimit"));
                    }
                    break block32;
                }
                if (!this.gear.isSurveyorEnabled() || !PirateSurveyor.equals(hand)) break block32;
                event.setCancelled(true);
                if (isInDingy || isInOrOnVotsShip) {
                    if (ItemUtil.isOnCooldown(player, event.getMaterial())) {
                        return;
                    }
                    IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.GRAY + IO.getLang("interactSurveySearch"));
                    Location result = player.getWorld().locateNearestStructure(player.getLocation(), StructureType.VILLAGE, 100, false);
                    if (result == null) {
                        IO.sendMessage(player, ChatMessageType.CHAT, IO.getLang("interactSurveyFailed"));
                        return;
                    }
                    int distance = (int)player.getLocation().distance(result);
                    IO.sendMessage(player, ChatMessageType.CHAT, IO.getLang("interactSurveyNearest").replace("<amount>", String.valueOf(distance)));
                    player.setCompassTarget(result);
                } else {
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, IO.getLang("waterDistanceLimit"));
                }
                break block32;
            }
            if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Biome biome;
                if (PirateDingy.equals(hand)) {
                    if (this.config.isVotsEnabled() && this.depends.isVotsPresent()) {
                        String use = NBTAPI.getNBT(hand, "sos_type");
                        int i = VOTS_TYPE.indexOf(use);
                        String ship = i != -1 && i < VOTS_TYPE.size() - 1 ? VOTS_TYPE.get(i + 1) : VOTS_TYPE.get(0);
                        NBTAPI.addNBT(hand, "sos_type", ship);
                        IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.GREEN + IO.getLang("changeShipType").replace("<type>", ChatColor.YELLOW + ship));
                    } else {
                        int i = BOAT_TYPE.indexOf(hand.getType().name());
                        String ship = i != -1 && i < BOAT_TYPE.size() - 1 ? BOAT_TYPE.get(i + 1) : BOAT_TYPE.get(0);
                        Material mat = Material.getMaterial((String)ship);
                        if (mat == null) {
                            this.plugin.getLogger().severe("Invalid ship material " + ship);
                            return;
                        }
                        hand.setType(mat);
                    }
                }
                if ((biome = TerraUtil.getBukkitBiome(event.getPlayer().getLocation())) == null) {
                    return;
                }
                if (this.isWaterBiome(biome)) {
                    for (Entity e : player.getNearbyEntities(4.0, 4.0, 4.0)) {
                        String mythic;
                        if (!(e instanceof Zombie) || !VOTS_TYPE.contains(ChatColor.stripColor((String)e.getName())) || e.isCustomNameVisible() || !e.getTrackedBy().contains(player) || this.depends.getMythicMobs() == null || !this.depends.getMythicMobs().getItemManager().isMythicItem(hand) || !(mythic = this.depends.getMythicMobs().getItemManager().getMythicTypeFromItem(hand)).equals("VOTSDirectionControler")) continue;
                        this.rollForEnemyVotsShipSpawn(player);
                        break;
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (ItemUtil.isGear(event.getItemDrop().getItemStack())) {
            IO.sendMessage(event.getPlayer(), ChatMessageType.CHAT, IO.getLang("dropDenied"));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (!WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            return;
        }
        if (!this.gear.isFishingRodEnabled()) {
            return;
        }
        if (!PirateFishingRod.get(player).equals((Object)player.getInventory().getItemInMainHand())) {
            return;
        }
        Pirate pirate = this.plugin.getPirate(player.getUniqueId());
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            pirate.setFishCaught(pirate.getFishCaught() + 1);
        } else if (event.getState() == PlayerFishEvent.State.CAUGHT_ENTITY) {
            if (event.getCaught() == null) {
                return;
            }
            if (event.getCaught() instanceof Item) {
                IO.sendMessage(player, ChatMessageType.CHAT, IO.getLang("fishItemCaught"));
            }
        }
        PirateFishCaughtEvent pEvent = new PirateFishCaughtEvent(this.plugin.getPirate(player.getUniqueId()), event.getCaught());
        this.plugin.getServer().getPluginManager().callEvent((Event)pEvent);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        event.getDrops().removeIf(ItemUtil::isGear);
        Player player = event.getEntity();
        this.lastEnteredOcean.remove(event.getEntity().getUniqueId());
        for (Entity e : event.getEntity().getNearbyEntities(30.0, 20.0, 30.0)) {
            if (!(e instanceof Dolphin)) continue;
            e.remove();
        }
        Pirate pirate = this.plugin.getPirate(player.getUniqueId());
        IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.GREEN + IO.getLang("deathTreasureSold").replace("<amount>", String.valueOf(pirate.getGoldEarned())));
        IO.sendMessage(player, ChatMessageType.CHAT, ChatColor.YELLOW + IO.getLang("deathFishCaught").replace("<amount>", String.valueOf(pirate.getFishCaught())));
        pirate.setGoldEarned(0);
        pirate.setFishCaught(0);
        pirate.setEnemiesPlundered(0);
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.adios(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.adios(event.getPlayer());
    }

    private void adios(Player player) {
        if (this.config.isVotsEnabled() && this.depends.getMythicMobs() != null) {
            for (Entity e : player.getNearbyEntities(250.0, 50.0, 250.0)) {
                if (!NBTAPI.hasNBT(e, "sos_owner")) continue;
                String owner = NBTAPI.getNBT(e, "sos_owner");
                if (owner == null) {
                    return;
                }
                if (!owner.equals(player.getUniqueId().toString())) continue;
                Optional am = this.depends.getMythicMobs().getMobManager().getActiveMob(e.getUniqueId());
                am.ifPresent(ActiveMob::despawn);
            }
        }
        Pirate pirate = this.plugin.getPirate(player.getUniqueId());
        if (this.plugin.getAllPirates().contains(pirate) && player.isInsideVehicle()) {
            Entity vehicle = player.getVehicle();
            if (vehicle == null) {
                return;
            }
            vehicle.eject();
            vehicle.remove();
        }
        this.plugin.removePirate(pirate);
    }

    private boolean isWaterBiome(Biome biome) {
        return biome.equals((Object)Biome.DEEP_LUKEWARM_OCEAN) || biome.equals((Object)Biome.DEEP_FROZEN_OCEAN) || biome.equals((Object)Biome.DEEP_COLD_OCEAN) || biome.equals((Object)Biome.DEEP_OCEAN) || biome.equals((Object)Biome.WARM_OCEAN) || biome.equals((Object)Biome.FROZEN_OCEAN) || biome.equals((Object)Biome.COLD_OCEAN) || biome.equals((Object)Biome.OCEAN) || biome.equals((Object)Biome.FROZEN_RIVER) || biome.equals((Object)Biome.RIVER);
    }

    private void rollForEnemyVotsShipSpawn(Player player) {
        if (this.random.nextInt(this.chance.getOceanSpawnVotsNpc()) == 1) {
            this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> {
                Location loc = player.getLocation();
                Vector inverseDirectionVec = loc.getDirection().normalize().multiply(-20);
                loc.add(inverseDirectionVec);
                loc.setY(60.0);
                if (loc.getBlock().isLiquid()) {
                    Optional opt = this.plugin.getDependencies().getMythicMobs().getSkillManager().getSkill("VOTSNPCGalleonShipDeathSound");
                    if (opt.isPresent()) {
                        BukkitEntity bukkitEntity = new BukkitEntity((Entity)player);
                        SkillCaster c = this.plugin.getDependencies().getMythicMobs().getSkillManager().getCaster((AbstractEntity)bukkitEntity);
                        SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.API, c, (AbstractEntity)bukkitEntity);
                        ((Skill)opt.get()).execute((SkillMetadata)meta);
                    }
                    this.plugin.getDependencies().getMythicMobs().getMobManager().spawnMob("VOTSNPCGalleon", loc);
                    IO.sendMessage(player, ChatMessageType.ACTION_BAR, ChatColor.RED + IO.getLang("enemyVesselChase"));
                }
            }, 40L);
        }
    }
}

