/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.gear.type.hand.PirateArrow;
import org.browsit.seaofsteves.gear.type.hand.PirateLongbow;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.ItemStack;

public class ProjectileListener
implements Listener {
    private final SeaOfSteves plugin;
    private final ConfigSettings config;
    private final GearSettings gear;
    private final FoliaLib foliaLib;
    private final List<UUID> projectiles = new ArrayList<UUID>();
    private final ConcurrentHashMap<Player, ItemStack> storedItem = new ConcurrentHashMap();

    public ProjectileListener(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
        this.foliaLib = plugin.getFoliaLib();
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        this.restoreItem(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        if (event.getItemDrop().getItemStack().getType().equals((Object)Material.ARROW)) {
            event.getItemDrop().remove();
            event.getPlayer().sendMessage(IO.getLang("dropDenied"));
            event.setCancelled(true);
        }
        this.restoreItem(event.getPlayer());
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            this.restoreItem((Player)event.getEntity());
        }
    }

    private void restoreItem(Player player) {
        if (this.storedItem.containsKey(player.getPlayer())) {
            int slot = this.gear.getLongbowSlotArrow() == -1 ? player.getInventory().getSize() - 1 : this.gear.getLongbowSlotArrow();
            player.getInventory().setItem(slot, this.storedItem.get(player));
            player.updateInventory();
            this.storedItem.remove(player);
        }
    }

    @EventHandler
    public void onPlayerPickup(PlayerPickupArrowEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        event.getItem().remove();
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!WorldUtil.isAllowedWorld(player.getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (this.storedItem.containsKey(player)) {
            return;
        }
        if (PirateLongbow.equals(player.getInventory().getItemInMainHand())) {
            int slot = this.gear.getLongbowSlotArrow() == -1 ? player.getInventory().getSize() - 1 : this.gear.getLongbowSlotArrow();
            ItemStack item = player.getInventory().getItem(slot);
            if (item == null) {
                item = new ItemStack(Material.AIR);
            }
            this.storedItem.put(player, item);
            player.getInventory().setItem(slot, PirateArrow.get(player));
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Fireball)) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        this.projectiles.add(projectile.getUniqueId());
        this.foliaLib.getScheduler().runAtEntityTimer((Entity)projectile, task -> {
            this.updateProjectile(projectile);
            if (!this.projectiles.contains(projectile.getUniqueId())) {
                try {
                    task.cancel();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
        }, 2L, 2L);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!WorldUtil.isAllowedWorld(projectile.getWorld().getName())) {
            return;
        }
        if (!this.gear.isLongbowEnabled()) {
            return;
        }
        this.projectiles.remove(projectile.getUniqueId());
        projectile.remove();
    }

    private void updateProjectile(Projectile projectile) {
        if (projectile.isDead() || projectile.getShooter() == null || !(projectile.getShooter() instanceof Player)) {
            this.projectiles.remove(projectile.getUniqueId());
            return;
        }
        if (projectile.getLocation().distance(((Player)projectile.getShooter()).getLocation()) > 100.0) {
            this.projectiles.remove(projectile.getUniqueId());
            projectile.remove();
            return;
        }
        for (Entity player : projectile.getWorld().getNearbyEntities(projectile.getLocation(), 2.0, 2.0, 2.0, entity -> entity.getType() == EntityType.PLAYER)) {
            if (projectile.getShooter() != null && projectile.getShooter().equals(player)) continue;
            projectile.getWorld().createExplosion(player.getLocation(), 2.0f, true, false, (Entity)projectile.getShooter());
            this.projectiles.remove(projectile.getUniqueId());
            projectile.remove();
            break;
        }
        if (this.config.isVotsEnabled() && this.plugin.getDependencies().getMythicMobs() != null) {
            boolean success = false;
            for (Entity entity2 : projectile.getWorld().getNearbyEntities(projectile.getLocation(), 4.0, 4.0, 4.0, entity -> entity.getType() == EntityType.ZOMBIE)) {
                boolean ignore = false;
                for (String names : this.config.getVotsShips()) {
                    if (!entity2.getName().contains(names)) continue;
                    ignore = true;
                }
                if (ignore) continue;
                projectile.getWorld().createExplosion(entity2.getLocation(), 10.0f, true, false, (Entity)projectile.getShooter());
                this.projectiles.remove(projectile.getUniqueId());
                projectile.remove();
                success = true;
            }
            if (success && projectile.getShooter() instanceof Player) {
                IO.sendMessage((Player)projectile.getShooter(), ChatMessageType.ACTION_BAR, ChatColor.GREEN + IO.getLang("enemyDirectHit"));
            }
        }
        projectile.getWorld().spawnParticle(Particle.SMOKE, projectile.getLocation(), 0, 0.0, 0.0, 0.0);
    }
}

