/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.listener;

import net.md_5.bungee.api.ChatMessageType;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.depend.Dependencies;
import org.browsit.seaofsteves.gear.type.PirateEmpty;
import org.browsit.seaofsteves.gear.type.boat.PirateDingy;
import org.browsit.seaofsteves.libs.folialib.FoliaLib;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.settings.GearSettings;
import org.browsit.seaofsteves.util.EntityUtil;
import org.browsit.seaofsteves.util.IO;
import org.browsit.seaofsteves.util.NBTAPI;
import org.browsit.seaofsteves.util.WorldUtil;
import org.bukkit.ChatColor;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;

public class VehicleListener
implements Listener {
    private final SeaOfSteves plugin;
    private final Dependencies depends;
    private final ConfigSettings config;
    private final GearSettings gear;
    private final FoliaLib foliaLib;

    public VehicleListener(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.depends = plugin.getDependencies();
        this.config = plugin.getConfigSettings();
        this.gear = plugin.getGearSettings();
        this.foliaLib = plugin.getFoliaLib();
    }

    @EventHandler
    public void onVehiclePlace(EntityPlaceEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled() || this.config.isVotsEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Boat)) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!EntityUtil.isShipAllowedOrCancel(event)) {
            return;
        }
        NBTAPI.addNBT(event.getEntity(), "sos_owner", player.getUniqueId().toString());
        this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> player.getInventory().setItem(this.gear.getDingySlot(), PirateEmpty.get(player)), 2L);
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getVehicle().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled()) {
            return;
        }
        if (!(event.getEntered() instanceof Player)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        if (NBTAPI.hasNBT((Entity)event.getVehicle(), "sos_owner") && !event.getEntered().getUniqueId().toString().equals(NBTAPI.getNBT((Entity)event.getVehicle(), "sos_owner"))) {
            IO.sendMessage((Player)event.getEntered(), ChatMessageType.CHAT, ChatColor.RED + IO.getLang("enterShipFailed").replace("<name>", event.getEntered().getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleExit(VehicleExitEvent event) {
        if (!this.gear.isDingyEnabled()) {
            return;
        }
        if (!(event.getExited() instanceof Player)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        if (NBTAPI.hasNBT((Entity)event.getVehicle(), "sos_owner") && event.getExited().getUniqueId().toString().equals(NBTAPI.getNBT((Entity)event.getVehicle(), "sos_owner"))) {
            Player player = (Player)event.getExited();
            this.foliaLib.getScheduler().runAtEntityLater((Entity)player, () -> {
                if (!player.isInsideVehicle()) {
                    ItemStack dingy = PirateDingy.get(player);
                    player.getInventory().setItem(this.gear.getDingySlot(), dingy);
                }
            }, 2L);
            event.getVehicle().remove();
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (!WorldUtil.isAllowedWorld(event.getVehicle().getWorld().getName())) {
            return;
        }
        if (!this.gear.isDingyEnabled()) {
            return;
        }
        if (!(event.getAttacker() instanceof Player)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        if (event.getAttacker() == null) {
            return;
        }
        if (NBTAPI.hasNBT((Entity)event.getVehicle(), "sos_owner")) {
            String owner = NBTAPI.getNBT((Entity)event.getVehicle(), "sos_owner");
            if (event.getAttacker().getUniqueId().toString().equals(owner)) {
                IO.sendMessage((Player)event.getAttacker(), ChatMessageType.CHAT, ChatColor.RED + IO.getLang("destroyShipFailed"));
                event.setCancelled(true);
            }
        }
    }
}

