/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.settings;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.browsit.seaofsteves.SeaOfSteves;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigSettings {
    private final SeaOfSteves plugin;
    private boolean creatureEnabled;
    private String creatureNameCaptain;
    private boolean eruptionEnabled;
    private String eruptionMaterial;
    private int eruptionStartHeight;
    private boolean eruptionCancelDrop;
    private boolean generalBlockExplode;
    private boolean merchantEnabled;
    private String merchantName;
    private int merchantReward;
    private boolean merchantUseVault;
    private boolean multiverseResetEnabled;
    private boolean multiverseResetUseBossbar;
    private double multiverseResetRegenHours;
    private boolean multiverseResetPurgeDynmap;
    private boolean votsEnabled;
    private final Collection<String> votsShips = new LinkedHashSet<String>();
    private boolean phatLootEnabled;
    private String phatLootNameBarrel;
    private String phatLootNameChest;
    private final Collection<String> worldNames = new ConcurrentSkipListSet<String>();

    public ConfigSettings(SeaOfSteves plugin) {
        this.plugin = plugin;
    }

    public boolean isCreatureEnabled() {
        return this.creatureEnabled;
    }

    public void setCreatureEnabled(boolean creatureEnabled) {
        this.creatureEnabled = creatureEnabled;
    }

    public String getCreatureNameCaptain() {
        return this.creatureNameCaptain;
    }

    public void setCreatureNameCaptain(String creatureNameCaptain) {
        this.creatureNameCaptain = creatureNameCaptain;
    }

    public boolean isEruptionEnabled() {
        return this.eruptionEnabled;
    }

    public void setEruptionEnabled(boolean eruptionEnabled) {
        this.eruptionEnabled = eruptionEnabled;
    }

    public String getEruptionMaterial() {
        return this.eruptionMaterial;
    }

    public void setEruptionMaterial(String eruptionMaterial) {
        this.eruptionMaterial = eruptionMaterial;
    }

    public int getEruptionStartHeight() {
        return this.eruptionStartHeight;
    }

    public void setEruptionStartHeight(int eruptionStartHeight) {
        this.eruptionStartHeight = eruptionStartHeight;
    }

    public boolean getEruptionCancelDrop() {
        return this.eruptionCancelDrop;
    }

    public void setEruptionCancelDrop(boolean eruptionCancelDrop) {
        this.eruptionCancelDrop = eruptionCancelDrop;
    }

    public boolean canGeneralBlockExplode() {
        return this.generalBlockExplode;
    }

    public void setGeneralBlockExplode(boolean generalBlockExplode) {
        this.generalBlockExplode = generalBlockExplode;
    }

    public boolean isMerchantEnabled() {
        return this.merchantEnabled;
    }

    public void setMerchantEnabled(boolean merchantsEnabled) {
        this.merchantEnabled = merchantsEnabled;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public int getMerchantReward() {
        return this.merchantReward;
    }

    public void setMerchantReward(int merchantReward) {
        this.merchantReward = merchantReward;
    }

    public boolean canMerchantUseVault() {
        return this.merchantUseVault;
    }

    public void setMerchantUseVault(boolean merchantUseVault) {
        this.merchantUseVault = merchantUseVault;
    }

    public boolean isMultiverseResetEnabled() {
        return this.multiverseResetEnabled;
    }

    public void setMultiverseResetEnabled(boolean multiverseResetEnabled) {
        this.multiverseResetEnabled = multiverseResetEnabled;
    }

    public boolean canMultiverseResetUseBossbar() {
        return this.multiverseResetUseBossbar;
    }

    public void setMultiverseResetUseBossbar(boolean multiverseResetUseBossbar) {
        this.multiverseResetUseBossbar = multiverseResetUseBossbar;
    }

    public double getMultiverseResetRegenHours() {
        return this.multiverseResetRegenHours;
    }

    public void setMultiverseResetRegenHours(double multiverseResetRegenHours) {
        this.multiverseResetRegenHours = multiverseResetRegenHours;
    }

    public boolean canMultiverseResetPurgeDynmap() {
        return this.multiverseResetPurgeDynmap;
    }

    public void setMultiverseResetPurgeDynmap(boolean multiverseResetPurgeDynmap) {
        this.multiverseResetPurgeDynmap = multiverseResetPurgeDynmap;
    }

    public boolean isVotsEnabled() {
        return this.votsEnabled;
    }

    public void setVotsEnabled(boolean votsEnabled) {
        this.votsEnabled = votsEnabled;
    }

    public Collection<String> getVotsShips() {
        return this.votsShips;
    }

    public void setVotsShips(Collection<String> votsShips) {
        this.votsShips.clear();
        this.votsShips.addAll(votsShips);
    }

    public boolean isPhatLootEnabled() {
        return this.phatLootEnabled;
    }

    public void setPhatLootEnabled(boolean phatLootEnabled) {
        this.phatLootEnabled = phatLootEnabled;
    }

    public String getPhatLootNameBarrel() {
        return this.phatLootNameBarrel;
    }

    public void setPhatLootNameBarrel(String phatLootNameBarrel) {
        this.phatLootNameBarrel = phatLootNameBarrel;
    }

    public String getPhatLootNameChest() {
        return this.phatLootNameChest;
    }

    public void setPhatLootNameChest(String phatLootNameChest) {
        this.phatLootNameChest = phatLootNameChest;
    }

    public Collection<String> getWorldNames() {
        return this.worldNames;
    }

    public void setWorldNames(Collection<String> worldNames) {
        this.worldNames.clear();
        this.worldNames.addAll(worldNames);
    }

    public void load() {
        this.plugin.reloadConfig();
        FileConfiguration cfg = this.plugin.getConfig();
        this.creatureEnabled = cfg.getBoolean("sos.creatures.enabled", true);
        this.creatureNameCaptain = cfg.getString("sos.creatures.name-captain", "Captain");
        this.eruptionEnabled = cfg.getBoolean("sos.eruption.enabled", true);
        this.eruptionMaterial = cfg.getString("sos.eruption.material", "MAGMA_BLOCK");
        this.eruptionStartHeight = cfg.getInt("sos.eruption.start-height", 30);
        this.eruptionCancelDrop = cfg.getBoolean("sos.eruption.cancel-drop", true);
        this.generalBlockExplode = cfg.getBoolean("sos.general.block-explode", false);
        this.merchantEnabled = cfg.getBoolean("sos.merchants.enabled", true);
        this.merchantName = cfg.getString("sos.merchants.name", "Merchant");
        this.merchantReward = cfg.getInt("sos.merchants.reward", 100);
        this.merchantUseVault = cfg.getBoolean("sos.merchants.use-vault", false);
        this.multiverseResetEnabled = cfg.getBoolean("sos.multiverse-reset.enabled", true);
        this.multiverseResetUseBossbar = cfg.getBoolean("sos.multiverse-reset.use-bossbar", true);
        this.multiverseResetRegenHours = cfg.getDouble("sos.multiverse-reset.regen-hours", 720.0);
        this.multiverseResetPurgeDynmap = cfg.getBoolean("sos.multiverse-reset.purge-dynmap", true);
        this.votsEnabled = cfg.getBoolean("sos.vots.enabled", true);
        this.setVotsShips(cfg.getStringList("sos.vots.ships"));
        this.phatLootEnabled = cfg.getBoolean("sos.phatloot.enabled", true);
        this.phatLootNameBarrel = cfg.getString("sos.phatloot.name-barrel", "SampleLoot");
        this.phatLootNameChest = cfg.getString("sos.phatloot.name-chest", "SampleLoot");
        this.setWorldNames(cfg.getStringList("sos.worlds"));
        if ((this.worldNames.contains("world") || this.worldNames.contains("world_nether") || this.worldNames.contains("world_the_end")) && (this.plugin.getFoliaLib() == null || !this.plugin.getFoliaLib().isFolia())) {
            this.plugin.getLogger().severe("Using default world names in config may cause issues!");
        }
    }
}

