/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.timer;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.browsit.seaofsteves.SeaOfSteves;
import org.browsit.seaofsteves.settings.ConfigSettings;
import org.browsit.seaofsteves.util.IO;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ResetTimer {
    private final SeaOfSteves plugin;
    private final ConfigSettings config;
    private BossBar bar;
    private final long regenMillis;
    private static long bufferTime = -600L;

    public ResetTimer(SeaOfSteves plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigSettings();
        this.regenMillis = (long)(plugin.getConfig().getDouble("sos.multiverse-reset.regen-hours") * 60.0 * 60.0 * 1000.0);
    }

    public long getTimerStart(String worldName) {
        File file = new File(this.plugin.getDataFolder() + File.separator + "timers" + File.separator + worldName + ".txt");
        if (!file.exists()) {
            this.saveTimerStart(worldName, System.currentTimeMillis());
            return System.currentTimeMillis();
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(this.plugin.getDataFolder() + File.separator + "timers" + File.separator + worldName + ".txt");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not load timer data for " + worldName);
            return 0L;
        }
        return config.getLong("timer.start");
    }

    public long getTimerRemaining(String worldName) {
        AtomicLong startTime = new AtomicLong(this.getTimerStart(worldName));
        long endTime = startTime.get() + this.regenMillis;
        long currentTime = System.currentTimeMillis();
        return endTime - currentTime;
    }

    private boolean saveTimerStart(String worldName, long milliseconds) {
        YamlConfiguration config = new YamlConfiguration();
        File file = new File(this.plugin.getDataFolder() + File.separator + "timers" + File.separator + worldName + ".txt");
        if (file.exists()) {
            return false;
        }
        config.createSection("timer");
        config.set("timer.start", (Object)milliseconds);
        try {
            config.save(this.plugin.getDataFolder() + File.separator + "timers" + File.separator + worldName + ".txt");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save timer data for " + worldName);
            return false;
        }
        return true;
    }

    private boolean deleteTimerStart(String worldName) {
        File file = new File(this.plugin.getDataFolder() + File.separator + "timers" + File.separator + worldName + ".txt");
        if (file.exists()) {
            file.delete();
        }
        return true;
    }

    public void run() {
        if (!this.config.isMultiverseResetEnabled()) {
            return;
        }
        if (this.plugin.getFoliaLib().isFolia()) {
            this.plugin.getLogger().info("Config has multiverse-reset.enabled but this is not supported on Folia. See https://github.com/Multiverse/Multiverse-Core/issues/2901");
            return;
        }
        HashSet<String> allowedWorldNames = new HashSet<String>();
        for (World world : this.plugin.getServer().getWorlds()) {
            if (!this.plugin.getConfigSettings().getWorldNames().contains(world.getName())) continue;
            allowedWorldNames.add(world.getName());
        }
        long tickRepeat = 20L;
        for (String worldName : allowedWorldNames) {
            AtomicLong startTime = new AtomicLong(this.getTimerStart(worldName));
            bufferTime += 600L;
            boolean useBossBar = this.plugin.getConfig().getBoolean("sos.multiverse-reset.use-bossbar");
            if (useBossBar && this.bar == null) {
                this.bar = this.plugin.getServer().createBossBar(this.formatTime(0L), BarColor.WHITE, BarStyle.SEGMENTED_20, new BarFlag[0]);
            }
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                long endTime = startTime.get() + this.regenMillis;
                long currentTime = System.currentTimeMillis();
                long remainingTime = endTime - currentTime;
                if (System.currentTimeMillis() >= endTime + bufferTime) {
                    World world = this.plugin.getServer().getWorld(worldName);
                    if (this.plugin.getDependencies().getMultiverseCore() != null && world != null) {
                        if (this.bar != null) {
                            this.bar.removeAll();
                            this.bar = null;
                        }
                        for (Player player : world.getPlayers()) {
                            player.getInventory().clear();
                            player.kickPlayer("Resetting world...");
                        }
                        this.deleteTimerStart(worldName);
                        this.saveTimerStart(worldName, currentTime);
                        startTime.set(currentTime);
                        boolean regen = this.plugin.getDependencies().getMultiverseCore().getMVWorldManager().regenWorld(worldName, true, true, "");
                        if (regen) {
                            this.plugin.getServer().broadcastMessage(IO.getLang("worldReset").replace("<name>", worldName));
                        } else {
                            this.plugin.getServer().broadcastMessage(ChatColor.RED + "Contact administrator! Unable to reset world: " + worldName);
                        }
                        if (this.config.canMultiverseResetPurgeDynmap()) {
                            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "dynmap purgeworld " + worldName);
                        }
                    } else {
                        this.plugin.getLogger().severe("Could not regen " + worldName + ". Is Multiverse-Core is enabled?");
                    }
                }
                if (this.bar != null) {
                    for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                        if (allowedWorldNames.contains(p.getWorld().getName())) {
                            if (!this.bar.getPlayers().contains(p)) {
                                this.bar.addPlayer(p);
                            }
                            long totalDuration = endTime - startTime.get();
                            double normalized = (double)remainingTime / (double)totalDuration;
                            normalized = Math.max(0.0, normalized);
                            normalized = Math.min(1.0, normalized);
                            if (startTime.get() < endTime) {
                                this.bar.setProgress(normalized);
                                if (this.bar.getProgress() >= 0.5) {
                                    if (!this.bar.getColor().equals((Object)BarColor.GREEN)) {
                                        this.bar.setColor(BarColor.GREEN);
                                    }
                                } else if (this.bar.getProgress() > 0.25 && this.bar.getProgress() < 0.5) {
                                    if (!this.bar.getColor().equals((Object)BarColor.YELLOW)) {
                                        this.bar.setColor(BarColor.YELLOW);
                                    }
                                } else if (!this.bar.getColor().equals((Object)BarColor.RED)) {
                                    this.bar.setColor(BarColor.RED);
                                }
                            }
                            this.bar.setTitle(this.formatTime(remainingTime));
                            continue;
                        }
                        this.bar.removePlayer(p);
                    }
                }
            }, bufferTime, 20L);
        }
    }

    public String formatTime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        return String.format("%dd %dh %dm %ds", days, hours, minutes, seconds);
    }
}

