/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.browsit.seaofsteves.SeaOfSteves;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class IO {
    private static FileConfiguration bosses;
    private static FileConfiguration gear;
    private static final ConcurrentHashMap<String, String> strings;

    public static void save(SeaOfSteves plugin, String fileName) throws IOException {
        File file = new File(plugin.getDataFolder(), fileName);
        YamlConfiguration config = null;
        if (file.exists()) {
            config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        } else {
            InputStream resource = plugin.getResource(fileName);
            if (resource != null) {
                config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resource, StandardCharsets.UTF_8));
            } else {
                plugin.getLogger().severe("Jar is missing " + fileName);
            }
        }
        if (config != null) {
            config.options().copyDefaults(true);
            config.save(new File(plugin.getDataFolder() + "/" + fileName));
        }
    }

    public static void load(SeaOfSteves plugin, String fileName) throws FileNotFoundException {
        File file = new File(plugin.getDataFolder(), File.separator + fileName);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        switch (fileName) {
            case "boss.yml": {
                bosses = config;
                bosses.options().setHeader(Collections.singletonList("Boss file for SeaOfSteves plugin"));
                break;
            }
            case "gear.yml": {
                gear = config;
                gear.options().setHeader(Collections.singletonList("Gear file for SeaOfSteves plugin (not for VOTS items)"));
                break;
            }
            case "strings.yml": {
                for (String key : config.getKeys(false)) {
                    strings.put(key, config.getString(key, ""));
                }
                break;
            }
        }
    }

    public static FileConfiguration getBosses() {
        return bosses;
    }

    public static FileConfiguration getGear() {
        return gear;
    }

    public static String getLang(String key) {
        if (key == null) {
            return null;
        }
        return strings.getOrDefault(key, "NULL");
    }

    public static void sendMessage(Player player, ChatMessageType type, String text) {
        if (text.trim().isEmpty()) {
            return;
        }
        player.spigot().sendMessage(type, TextComponent.fromLegacyText((String)text));
    }

    static {
        strings = new ConcurrentHashMap();
    }
}

