/*
 * Decompiled with CFR 0.152.
 */
package org.browsit.seaofsteves.util;

import com.dfsek.terra.bukkit.TerraBukkitPlugin;
import com.dfsek.terra.bukkit.world.BukkitServerWorld;
import org.browsit.seaofsteves.SeaOfSteves;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class TerraUtil {
    public static SeaOfSteves plugin = (SeaOfSteves)Bukkit.getPluginManager().getPlugin("SeaOfSteves");
    private static final double MAX_RADIUS = 100.0;
    private static final double EPSILON = 1.0;
    private static final Vector[] DIRECTIONS = new Vector[]{new Vector(1, 0, 0), new Vector(-1, 0, 0), new Vector(0, 0, 1), new Vector(0, 0, -1)};

    @Nullable
    public static Biome getBukkitBiome(Location location) {
        TerraBukkitPlugin terra = plugin.getDependencies().getTerra();
        if (terra == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        ChunkGenerator chunkGenerator = terra.getDefaultWorldGenerator(world.getName(), "ISLANDS");
        if (chunkGenerator == null) {
            return null;
        }
        BiomeProvider biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)world);
        if (biomeProvider == null) {
            return null;
        }
        return biomeProvider.getBiome((WorldInfo)world, location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Nullable
    public static com.dfsek.terra.api.world.biome.Biome getTerraBiome(Location location) {
        TerraBukkitPlugin terra = plugin.getDependencies().getTerra();
        if (terra == null) {
            return null;
        }
        if (location.getWorld() == null) {
            return null;
        }
        BukkitServerWorld serverWorld = new BukkitServerWorld(location.getWorld());
        com.dfsek.terra.api.world.biome.generation.BiomeProvider biomeProvider = null;
        try {
            biomeProvider = serverWorld.getBiomeProvider();
        }
        catch (NullPointerException e) {
            plugin.getLogger().severe("No biome provider for " + location.getWorld().getName() + " - is this a Terra world?");
        }
        if (biomeProvider == null) {
            return null;
        }
        return biomeProvider.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), serverWorld.getSeed());
    }

    public static Location getBukkitBiomeCenter(Biome biome, Location playerLocation) {
        World world = playerLocation.getWorld();
        Location[] edgePoints = new Location[4];
        for (int i = 0; i < 4; ++i) {
            Vector direction = DIRECTIONS[i];
            Location edgePoint = playerLocation.clone();
            for (double interval = 100.0; interval > 1.0; interval /= 2.0) {
                if (TerraUtil.getBukkitBiome(edgePoint).equals((Object)biome)) {
                    edgePoint.add(direction.clone().multiply(interval));
                    continue;
                }
                edgePoint.subtract(direction.clone().multiply(interval));
            }
            if (!TerraUtil.getBukkitBiome(edgePoint).equals((Object)biome)) {
                edgePoint.subtract(direction);
            }
            edgePoints[i] = edgePoint;
        }
        double centerX = (edgePoints[0].getX() + edgePoints[1].getX()) / 2.0;
        double centerZ = (edgePoints[2].getZ() + edgePoints[3].getZ()) / 2.0;
        return new Location(world, centerX, (double)world.getHighestBlockYAt((int)centerX, (int)centerZ) + 1.5, centerZ);
    }

    public static Location getTerraBiomeCenter(com.dfsek.terra.api.world.biome.Biome biome, Location playerLocation) {
        Location[] edgePoints = new Location[4];
        for (int i = 0; i < 4; ++i) {
            Vector direction = DIRECTIONS[i];
            Location edgePoint = playerLocation.clone();
            for (double interval = 100.0; interval > 1.0; interval /= 2.0) {
                if (TerraUtil.getTerraBiome(edgePoint).getID().equals(biome.getID())) {
                    edgePoint.add(direction.clone().multiply(interval));
                    continue;
                }
                edgePoint.subtract(direction.clone().multiply(interval));
            }
            if (!TerraUtil.getTerraBiome(edgePoint).equals(biome)) {
                edgePoint.subtract(direction);
            }
            edgePoints[i] = edgePoint;
        }
        double centerX = (edgePoints[0].getX() + edgePoints[1].getX()) / 2.0;
        double centerZ = (edgePoints[2].getZ() + edgePoints[3].getZ()) / 2.0;
        World world = playerLocation.getWorld();
        return new Location(world, centerX, (double)world.getHighestBlockYAt((int)centerX, (int)centerZ) + 1.5, centerZ);
    }
}

