/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.client.coldbreath;

import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class ColdBreathEffect {
    private static long nextBreathTick = 0L;
    private static long breathBurstEndTick = 0L;
    private static double sprintBlend = 0.0;
    private static double prevSprintBlend = 0.0;

    private ColdBreathEffect() {
    }

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean isEnd;
            ColdBreathConfig cfg = ConfigManager.get();
            if (!cfg.enabled) {
                return;
            }
            if (client.method_1493()) {
                return;
            }
            class_638 world = client.field_1687;
            class_746 player = client.field_1724;
            if (world == null || player == null) {
                return;
            }
            long time = world.method_8510();
            prevSprintBlend = sprintBlend;
            ColdBreathEffect.updateSprintBlend((class_1657)player, cfg);
            if (time < breathBurstEndTick) {
                if (time % 3L == 0L) {
                    if (player.method_5869()) {
                        if (cfg.underwaterEnabled) {
                            ColdBreathEffect.spawnUnderwaterBreath(client, world, (class_1657)player);
                        }
                    } else {
                        ColdBreathEffect.spawnBreathParticles(client, world, (class_1657)player, cfg);
                    }
                }
                return;
            }
            if (time < nextBreathTick) {
                return;
            }
            if (player.method_5869()) {
                if (!cfg.underwaterEnabled) {
                    ColdBreathEffect.scheduleNext(time, cfg);
                    return;
                }
                ColdBreathEffect.startBreathBurst(time, cfg);
                ColdBreathEffect.scheduleNextUnderwater(time, cfg);
                return;
            }
            if (player.method_7325() || player.method_6113()) {
                ColdBreathEffect.scheduleNext(time, cfg);
                return;
            }
            if (!cfg.visibleInCreative && player.method_31549().field_7477) {
                ColdBreathEffect.scheduleNext(time, cfg);
                return;
            }
            class_2338 pos = player.method_24515();
            class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
            int seaLevel = world.method_8615();
            boolean isColdHere = biome.method_33599(pos, seaLevel);
            String dimKey = world.method_27983().method_29177().toString();
            boolean isNether = dimKey.contains("nether");
            boolean bl = isEnd = dimKey.contains("the_end") || dimKey.contains("end");
            if (isNether && !cfg.visibleInNether || isEnd && !cfg.visibleInEnd) {
                ColdBreathEffect.scheduleNext(time, cfg);
                return;
            }
            if (cfg.onlyInColdBiomes && !isColdHere) {
                ColdBreathEffect.scheduleNext(time, cfg);
                return;
            }
            ColdBreathEffect.startBreathBurst(time, cfg);
            ColdBreathEffect.scheduleNext(time, cfg);
        });
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            ColdBreathConfig cfg = ConfigManager.get();
            if (!cfg.debugEnabled) {
                return;
            }
            int color = ColdBreathEffect.getDebugColor(cfg);
            int x = 6;
            int y = 6;
            int w = 80;
            int h = 12;
            context.method_25294(x, y, x + w, y + h, color);
            String state = ColdBreathEffect.getDebugState(cfg);
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1772 != null) {
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)state), x + 3, y + 2, -1, false);
                String blendText = String.format("blend: %.2f -> %.2f", prevSprintBlend, sprintBlend);
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)blendText), x + w + 6, y + 2, -256, false);
            }
        });
    }

    private static void startBreathBurst(long currentTick, ColdBreathConfig cfg) {
        breathBurstEndTick = currentTick + (long)cfg.breathBurstDurationTicks;
    }

    private static void spawnBreathParticles(class_310 client, class_638 world, class_1657 player, ColdBreathConfig cfg) {
        class_243 headPos = new class_243(player.method_23317(), player.method_23320(), player.method_23321());
        class_243 lookDirection = player.method_5828(1.0f).method_1029();
        class_243 forward = lookDirection.method_1021(cfg.forwardOffset);
        class_243 down = new class_243(0.0, -cfg.downOffset, 0.0);
        class_243 spawn = headPos.method_1019(forward).method_1019(down);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        class_702 particleManager = client.field_1713;
        int snowflakeCount = r.nextInt(3) == 0 ? 2 : 1;
        for (int i = 0; i < snowflakeCount; ++i) {
            double offsetX = (r.nextDouble() - 0.5) * 0.08;
            double offsetY = (r.nextDouble() - 0.5) * 0.04;
            double offsetZ = (r.nextDouble() - 0.5) * 0.08;
            double vx = lookDirection.field_1352 * 0.003 + (r.nextDouble() - 0.5) * 0.002;
            double vy = Math.max(0.0, lookDirection.field_1351 * 0.001) + (r.nextDouble() - 0.5) * 0.002;
            double vz = lookDirection.field_1350 * 0.003 + (r.nextDouble() - 0.5) * 0.002;
            int color = cfg.breathColor;
            float size = (float)Math.max(0.1, cfg.breathSize);
            class_2390 dustEffect = new class_2390(color, size);
            particleManager.method_3056((class_2394)dustEffect, spawn.field_1352 + offsetX, spawn.field_1351 + offsetY, spawn.field_1350 + offsetZ, vx, vy, vz);
        }
    }

    private static void spawnUnderwaterBreath(class_310 client, class_638 world, class_1657 player) {
        class_243 headPos = new class_243(player.method_23317(), player.method_23320(), player.method_23321());
        class_243 lookDirection = player.method_5828(1.0f).method_1029();
        class_243 forward = lookDirection.method_1021(0.2);
        class_243 down = new class_243(0.0, -0.05, 0.0);
        class_243 spawn = headPos.method_1019(forward).method_1019(down);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        class_702 particleManager = client.field_1713;
        int bubbleCount = r.nextInt(2, 4);
        for (int i = 0; i < bubbleCount; ++i) {
            double offsetX = (r.nextDouble() - 0.5) * 0.06;
            double offsetY = (r.nextDouble() - 0.5) * 0.04;
            double offsetZ = (r.nextDouble() - 0.5) * 0.06;
            double vx = (r.nextDouble() - 0.5) * 0.02;
            double vy = 0.03 + r.nextDouble() * 0.02;
            double vz = (r.nextDouble() - 0.5) * 0.02;
            particleManager.method_3056((class_2394)class_2398.field_11247, spawn.field_1352 + offsetX, spawn.field_1351 + offsetY, spawn.field_1350 + offsetZ, vx, vy, vz);
        }
    }

    private static void scheduleNext(long nowTick, ColdBreathConfig cfg) {
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double devNormal = Math.max(0.0, cfg.intervalDeviationSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double devSprint = Math.max(0.0, cfg.sprintIntervalDeviationSeconds);
        double blend = cfg.sprintingIntervalsEnabled ? sprintBlend : 0.0;
        double base = ColdBreathEffect.lerp(baseNormal, baseSprint, blend);
        double dev = ColdBreathEffect.lerp(devNormal, devSprint, blend);
        double minSec = Math.max(0.1, base - dev);
        double maxSec = Math.max(minSec, base + dev);
        double waitSec = maxSec <= minSec ? minSec : ThreadLocalRandom.current().nextDouble(minSec, maxSec);
        int waitTicks = Math.max(1, (int)Math.round(waitSec * 20.0));
        nextBreathTick = nowTick + (long)waitTicks;
    }

    private static void scheduleNextUnderwater(long nowTick, ColdBreathConfig cfg) {
        double dev;
        double base = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
        double minSec = Math.max(4.0, base - (dev = Math.max(0.0, cfg.underwaterIntervalDeviationSeconds)));
        double maxSec = Math.min(20.0, Math.max(minSec, base + dev));
        double waitSec = maxSec <= minSec ? minSec : ThreadLocalRandom.current().nextDouble(minSec, maxSec);
        int waitTicks = Math.max(1, (int)Math.round(waitSec * 20.0));
        nextBreathTick = nowTick + (long)waitTicks;
    }

    private static void updateSprintBlend(class_1657 player, ColdBreathConfig cfg) {
        double target;
        double downRate;
        boolean underwater = player.method_5869();
        double dt = 0.05;
        double upRate = cfg.sprintBuildUpSeconds <= 0.0 ? 1.0 : dt / cfg.sprintBuildUpSeconds;
        double d = downRate = cfg.sprintBuildDownSeconds <= 0.0 ? 1.0 : dt / cfg.sprintBuildDownSeconds;
        if (underwater && cfg.underwaterEnabled) {
            if (sprintBlend < 1.0) {
                sprintBlend = Math.min(1.0, sprintBlend + upRate);
            }
            return;
        }
        boolean sprinting = player.method_5624();
        double d2 = target = cfg.sprintingIntervalsEnabled && sprinting ? 1.0 : 0.0;
        if (target > sprintBlend) {
            sprintBlend = Math.min(1.0, sprintBlend + upRate);
        } else if (target < sprintBlend) {
            sprintBlend = Math.max(0.0, sprintBlend - downRate);
        }
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static int getDebugColor(ColdBreathConfig cfg) {
        int alpha = -1610612736;
        if (!cfg.sprintingIntervalsEnabled) {
            return alpha | 0xFF00;
        }
        if (sprintBlend >= 0.95) {
            return alpha | 0xFFA500;
        }
        if (sprintBlend <= 0.05) {
            return alpha | 0xFF00;
        }
        if (sprintBlend > prevSprintBlend + 1.0E-6) {
            return alpha | 0xFFFF00;
        }
        if (sprintBlend < prevSprintBlend - 1.0E-6) {
            return alpha | 0xFF;
        }
        return alpha | 0x7FFF00;
    }

    private static String getDebugState(ColdBreathConfig cfg) {
        if (!cfg.sprintingIntervalsEnabled) {
            return "normal";
        }
        if (sprintBlend >= 0.95) {
            return "sprinting";
        }
        if (sprintBlend <= 0.05) {
            return "normal";
        }
        if (sprintBlend > prevSprintBlend + 1.0E-6) {
            return "building up";
        }
        if (sprintBlend < prevSprintBlend - 1.0E-6) {
            return "building down";
        }
        return "transitional";
    }
}

