/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.config;

import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ColdBreathConfigScreen {
    private ColdBreathConfigScreen() {
    }

    public static class_437 create(class_437 parent) {
        ColdBreathConfig cfg = ConfigManager.get();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Cold Breath Config")).setSavingRunnable(ConfigManager::save);
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Cold Breath"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        BooleanListEntry enabledEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enabled"), cfg.enabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Master switch for Cold Breath feature.")}).setSaveConsumer(val -> {
            cfg.enabled = val;
        }).build();
        BooleanListEntry onlyColdEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Only in Cold Biomes"), cfg.onlyInColdBiomes).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, breaths only appear in cold/snowy biomes."), class_2561.method_43470((String)"Overworld only. Nether/End visibility is controlled by 'Visible in Nether' and 'Visible in End'.")}).setSaveConsumer(val -> {
            cfg.onlyInColdBiomes = val;
        }).build();
        IntegerSliderEntry baseIntervalEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Base Interval (seconds)"), (int)Math.round(cfg.baseIntervalSeconds * 10.0), 20, 100).setDefaultValue(50).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while not sprinting (range: 2.0\u201310.0s).")}).setSaveConsumer(i -> {
            cfg.baseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry baseDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Deviation (seconds)"), (int)Math.round(cfg.intervalDeviationSeconds * 10.0), 0, 20).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation added/subtracted from base interval (range: 0.0\u20132.0s).")}).setSaveConsumer(i -> {
            cfg.intervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        general.addEntry((AbstractConfigListEntry)enabledEntry);
        general.addEntry((AbstractConfigListEntry)onlyColdEntry);
        general.addEntry((AbstractConfigListEntry)baseIntervalEntry);
        general.addEntry((AbstractConfigListEntry)baseDevEntry);
        BooleanListEntry sprintToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Sprinting-specific Intervals"), cfg.sprintingIntervalsEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Use separate timing while sprinting, with smooth ramp in/out.")}).setSaveConsumer(val -> {
            cfg.sprintingIntervalsEnabled = val;
        }).build();
        IntegerSliderEntry sprintBaseEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Base Interval (seconds)"), (int)Math.round(cfg.sprintBaseIntervalSeconds * 10.0), 10, 80).setDefaultValue(30).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while sprinting (range: 1.0\u20138.0s).")}).setSaveConsumer(i -> {
            cfg.sprintBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Deviation (seconds)"), (int)Math.round(cfg.sprintIntervalDeviationSeconds * 10.0), 0, 10).setDefaultValue(5).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation while sprinting (range: 0.0\u20131.0s).")}).setSaveConsumer(i -> {
            cfg.sprintIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintUpEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-up (seconds)"), (int)Math.round(cfg.sprintBuildUpSeconds * 10.0), 0, 300).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from normal to sprint breathing cadence (range: 0.0\u201330.0s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildUpSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDownEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-down (seconds)"), (int)Math.round(cfg.sprintBuildDownSeconds * 10.0), 0, 300).setDefaultValue(120).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from sprint back to normal cadence (range: 0.0\u201330.0s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildDownSeconds = (double)i.intValue() / 10.0;
        }).build();
        List<AbstractConfigListEntry> sprintEntries = Arrays.asList(sprintToggleEntry, sprintBaseEntry, sprintDevEntry, sprintUpEntry, sprintDownEntry);
        SubCategoryListEntry sprintSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Sprinting"), sprintEntries).build();
        DoubleListEntry forwardEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Forward Offset"), cfg.forwardOffset).setDefaultValue(0.3).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters in front of the player head to spawn particles.")}).setSaveConsumer(val -> {
            cfg.forwardOffset = val;
        }).build();
        DoubleListEntry downEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Down Offset"), cfg.downOffset).setDefaultValue(0.2).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters below the player head to spawn particles.")}).setSaveConsumer(val -> {
            cfg.downOffset = val;
        }).build();
        IntegerListEntry burstEntry = eb.startIntField((class_2561)class_2561.method_43470((String)"Burst Duration (ticks)"), cfg.breathBurstDurationTicks).setDefaultValue(10).setMin(1).setTooltip(new class_2561[]{class_2561.method_43470((String)"How long a breath burst continues spawning particles (in ticks).")}).setSaveConsumer(val -> {
            cfg.breathBurstDurationTicks = val;
        }).build();
        ArrayList<AbstractConfigListEntry> visualEntries = new ArrayList<AbstractConfigListEntry>(Arrays.asList(forwardEntry, downEntry, burstEntry));
        String currentHex = String.format("#%06X", 0xFFFFFF & cfg.breathColor);
        StringListEntry colorEntry = eb.startStrField((class_2561)class_2561.method_43470((String)"Breath Color (hex)"), currentHex).setDefaultValue("#E6F2FF").setTooltip(new class_2561[]{class_2561.method_43470((String)"RGB hex for normal breath particles. Accepted: #RRGGBB, 0xRRGGBB, or RRGGBB.")}).setSaveConsumer(str -> {
            if (str == null) {
                return;
            }
            String s = str.trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
            }
            if (s.length() == 6) {
                try {
                    int rgb;
                    cfg.breathColor = rgb = Integer.parseInt(s, 16) & 0xFFFFFF;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }).build();
        DoubleListEntry sizeEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Breath Size"), cfg.breathSize).setDefaultValue(0.6).setMin(0.1).setTooltip(new class_2561[]{class_2561.method_43470((String)"Particle size/scale for normal breath particles (min: 0.1).")}).setSaveConsumer(val -> {
            cfg.breathSize = val;
        }).build();
        visualEntries.add((AbstractConfigListEntry)colorEntry);
        visualEntries.add((AbstractConfigListEntry)sizeEntry);
        BooleanListEntry debugEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Debug Overlay"), cfg.debugEnabled).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show on-screen state and sprint blend values.")}).setSaveConsumer(val -> {
            cfg.debugEnabled = val;
        }).build();
        BooleanListEntry uwToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Underwater Breaths"), cfg.underwaterEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show bubble breaths when the player is underwater (has air bar).")}).setSaveConsumer(v -> {
            cfg.underwaterEnabled = v;
        }).build();
        IntegerSliderEntry uwBase = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Base Interval (seconds)"), (int)Math.round(cfg.underwaterBaseIntervalSeconds * 10.0), 40, 200).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between bubble breaths underwater (range: 4.0\u201320.0s).")}).setSaveConsumer(i -> {
            cfg.underwaterBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry uwDev = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Deviation (seconds)"), (int)Math.round(cfg.underwaterIntervalDeviationSeconds * 10.0), 0, 40).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation for underwater breaths (range: 0.0\u20134.0s).")}).setSaveConsumer(i -> {
            cfg.underwaterIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        List<AbstractConfigListEntry> uwEntries = Arrays.asList(uwToggle, uwBase, uwDev);
        SubCategoryListEntry underwaterSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Underwater"), uwEntries).build();
        general.addEntry((AbstractConfigListEntry)sprintSub);
        general.addEntry((AbstractConfigListEntry)underwaterSub);
        BooleanListEntry visibleCreativeEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Creative"), cfg.visibleInCreative).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in Creative mode.")}).setSaveConsumer(val -> {
            cfg.visibleInCreative = val;
        }).build();
        BooleanListEntry visibleNetherEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Nether"), cfg.visibleInNether).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the Nether.")}).setSaveConsumer(val -> {
            cfg.visibleInNether = val;
        }).build();
        BooleanListEntry visibleEndEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in End"), cfg.visibleInEnd).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the End.")}).setSaveConsumer(val -> {
            cfg.visibleInEnd = val;
        }).build();
        List<AbstractConfigListEntry> dimensionsEntries = Arrays.asList(visibleCreativeEntry, visibleNetherEntry, visibleEndEntry);
        SubCategoryListEntry dimensionsSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Visibility"), dimensionsEntries).build();
        SubCategoryListEntry visualsSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Visuals"), visualEntries).build();
        general.addEntry((AbstractConfigListEntry)visualsSub);
        general.addEntry((AbstractConfigListEntry)dimensionsSub);
        general.addEntry((AbstractConfigListEntry)debugEntry);
        return builder.build();
    }
}

