/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat;

import com.sfdesat.ColdBreathMod;
import com.sfdesat.coldbreath.breath.BreathController;
import com.sfdesat.coldbreath.debug.DebugChat;
import com.sfdesat.coldbreath.debug.DebugHud;
import com.sfdesat.coldbreath.debug.DebugManager;
import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonManager;
import com.sfdesat.config.ConfigManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColdBreathClient
implements ClientModInitializer {
    public void onInitializeClient() {
        SeasonDetector.init();
        SeasonManager.applyConfig(ConfigManager.get());
        BreathController.INSTANCE.register();
        DebugManager debugManager = new DebugManager(BreathController.INSTANCE.getBlends());
        try {
            new DebugHud(debugManager).register();
        }
        catch (LinkageError err) {
            ColdBreathMod.LOGGER.warn("Cold Breath debug HUD disabled due to missing client rendering classes: {}", (Object)err.toString());
        }
        catch (RuntimeException err) {
            ColdBreathMod.LOGGER.warn("Cold Breath debug HUD failed to initialize; debug overlay will be unavailable.", (Throwable)err);
        }
        try {
            new DebugChat(debugManager).register();
        }
        catch (LinkageError err) {
            ColdBreathMod.LOGGER.warn("Cold Breath debug chat commands disabled due to missing client command API: {}", (Object)err.toString());
        }
        catch (RuntimeException err) {
            ColdBreathMod.LOGGER.warn("Cold Breath debug chat commands failed to initialize.", (Throwable)err);
        }
    }
}

