/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.api;

import com.sfdesat.coldbreath.breath.EnvModel;
import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonManager;
import com.sfdesat.coldbreath.season.SeasonPhase;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class ColdBreathApi {
    public static final Event<Consumer<BreathEvent>> BREATH_EVENT = EventFactory.createArrayBacked(Consumer.class, callbacks -> event -> {
        for (Consumer callback : callbacks) {
            callback.accept(event);
        }
    });

    private ColdBreathApi() {
    }

    public static void registerBreathListener(Consumer<BreathEvent> listener) {
        BREATH_EVENT.register(Objects.requireNonNull(listener, "listener"));
    }

    public static Optional<BreathState> currentState() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            return Optional.empty();
        }
        ColdBreathConfig cfg = ConfigManager.get();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        SeasonManager.refresh(world);
        EnvModel.BreathEligibility eligibility = EnvModel.checkEligibility(world, (class_1657)player, cfg);
        boolean underwater = player.method_5869() && cfg.underwaterEnabled;
        float temperature = EnvModel.computeEffectiveTemperature(world, player.method_24515(), cfg);
        boolean condensationActive = eligibility.allowed() && (double)temperature > cfg.alwaysBreathTemperature && !cfg.alwaysShowBreath && !underwater;
        return Optional.of(new BreathState(eligibility.allowed(), eligibility.reason(), temperature, condensationActive, underwater, SeasonManager.getCurrentMod(), SeasonManager.getCurrentPhase()));
    }

    public static void publishBreathEvent() {
        ColdBreathApi.currentState().ifPresent(state -> ((Consumer)BREATH_EVENT.invoker()).accept(new BreathEvent((BreathState)state)));
    }

    @Environment(value=EnvType.CLIENT)
    public record BreathState(boolean visible, String invisibleReason, float effectiveTemperature, boolean condensationActive, boolean underwater, SeasonDetector.SeasonMod seasonMod, SeasonPhase seasonPhase) {
    }

    @Environment(value=EnvType.CLIENT)
    public record BreathEvent(BreathState state) {
    }
}

