/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.breath;

import com.sfdesat.coldbreath.api.ColdBreathApi;
import com.sfdesat.coldbreath.breath.BreathSpawner;
import com.sfdesat.coldbreath.breath.EnvModel;
import com.sfdesat.coldbreath.breath.StateBlends;
import com.sfdesat.coldbreath.season.SeasonManager;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class BreathController {
    private static final int TICKS_PER_SECOND = 20;
    private static final int BURST_EMIT_PERIOD_TICKS = 3;
    private static final double INTERVAL_TIE_EPSILON = 1.0E-6;
    private long nextBreathTick = 0L;
    private long breathBurstEndTick = 0L;
    private final StateBlends blends = new StateBlends();
    public static final BreathController INSTANCE = new BreathController();

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onTick(client));
    }

    private void onTick(class_310 client) {
        ColdBreathConfig cfg = ConfigManager.get();
        if (!cfg.enabled) {
            return;
        }
        if (client.method_1493()) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            return;
        }
        long time = world.method_8510();
        this.blends.tick((class_1657)player, cfg);
        if (time < this.breathBurstEndTick) {
            if (time % 3L == 0L) {
                if (player.method_5869()) {
                    if (cfg.underwaterEnabled) {
                        BreathSpawner.spawnUnderwater(client, world, (class_1657)player);
                    }
                } else {
                    BreathSpawner.spawnAir(client, world, (class_1657)player, cfg);
                }
            }
            return;
        }
        if (time < this.nextBreathTick) {
            return;
        }
        SeasonManager.refresh(world);
        if (!EnvModel.isEligibleNow(world, (class_1657)player, cfg)) {
            this.scheduleNext(time, cfg);
            return;
        }
        if (player.method_5869() && cfg.underwaterEnabled) {
            this.startBurst(time, cfg);
            this.scheduleNextUnderwater(time, cfg);
            ColdBreathApi.publishBreathEvent();
            return;
        }
        this.startBurst(time, cfg);
        this.scheduleNext(time, cfg);
        ColdBreathApi.publishBreathEvent();
    }

    private void startBurst(long now, ColdBreathConfig cfg) {
        this.breathBurstEndTick = now + (long)cfg.breathBurstDurationTicks;
    }

    private void scheduleNext(long nowTick, ColdBreathConfig cfg) {
        double dev;
        double base;
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double devNormal = Math.max(0.0, cfg.intervalDeviationSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double devSprint = Math.max(0.0, cfg.sprintIntervalDeviationSeconds);
        double baseHealth = Math.max(0.1, cfg.lowHealthIntervalSeconds);
        double devHealth = Math.max(0.0, cfg.healthIntervalDeviationSeconds);
        double sprintT = cfg.sprintingIntervalsEnabled ? this.blends.getSprintBlend() : 0.0;
        double healthT = cfg.healthBasedBreathingEnabled ? this.blends.getHealthBlend() : 0.0;
        double afterSprint = BreathController.lerp(baseNormal, baseSprint, sprintT);
        double devAfterSprint = BreathController.lerp(devNormal, devSprint, sprintT);
        double afterHealth = BreathController.lerp(baseNormal, baseHealth, healthT);
        double devAfterHealth = BreathController.lerp(devNormal, devHealth, healthT);
        if (Math.abs(afterSprint - afterHealth) <= 1.0E-6) {
            base = afterSprint;
            dev = 0.5 * (devAfterSprint + devAfterHealth);
        } else if (afterSprint < afterHealth) {
            base = afterSprint;
            dev = devAfterSprint;
        } else {
            base = afterHealth;
            dev = devAfterHealth;
        }
        double minSec = Math.max(0.1, base - dev);
        double maxSec = Math.max(minSec, base + dev);
        double waitSec = maxSec <= minSec ? minSec : ThreadLocalRandom.current().nextDouble(minSec, maxSec);
        int waitTicks = Math.max(1, (int)Math.round(waitSec * 20.0));
        this.nextBreathTick = nowTick + (long)waitTicks;
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private void scheduleNextUnderwater(long nowTick, ColdBreathConfig cfg) {
        double dev;
        double base = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
        double minSec = Math.max(0.1, base - (dev = Math.max(0.0, cfg.underwaterIntervalDeviationSeconds)));
        double maxSec = Math.max(minSec, base + dev);
        double waitSec = maxSec <= minSec ? minSec : ThreadLocalRandom.current().nextDouble(minSec, maxSec);
        int waitTicks = Math.max(1, (int)Math.round(waitSec * 20.0));
        this.nextBreathTick = nowTick + (long)waitTicks;
    }

    public double getCurrentBaseIntervalSeconds(ColdBreathConfig cfg) {
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double baseHealth = Math.max(0.1, cfg.lowHealthIntervalSeconds);
        double sprintT = cfg.sprintingIntervalsEnabled ? this.blends.getSprintBlend() : 0.0;
        double healthT = cfg.healthBasedBreathingEnabled ? this.blends.getHealthBlend() : 0.0;
        double afterSprint = BreathController.lerp(baseNormal, baseSprint, sprintT);
        double afterHealth = BreathController.lerp(baseNormal, baseHealth, healthT);
        return Math.min(afterSprint, afterHealth);
    }

    public StateBlends getBlends() {
        return this.blends;
    }

    public double[] getCurrentIntervalMinMaxSeconds(ColdBreathConfig cfg) {
        double dev;
        double base;
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double devNormal = Math.max(0.0, cfg.intervalDeviationSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double devSprint = Math.max(0.0, cfg.sprintIntervalDeviationSeconds);
        double baseHealth = Math.max(0.1, cfg.lowHealthIntervalSeconds);
        double devHealth = Math.max(0.0, cfg.healthIntervalDeviationSeconds);
        double sprintT = cfg.sprintingIntervalsEnabled ? this.blends.getSprintBlend() : 0.0;
        double healthT = cfg.healthBasedBreathingEnabled ? this.blends.getHealthBlend() : 0.0;
        double afterSprint = BreathController.lerp(baseNormal, baseSprint, sprintT);
        double devAfterSprint = BreathController.lerp(devNormal, devSprint, sprintT);
        double afterHealth = BreathController.lerp(baseNormal, baseHealth, healthT);
        double devAfterHealth = BreathController.lerp(devNormal, devHealth, healthT);
        if (Math.abs(afterSprint - afterHealth) <= 1.0E-6) {
            base = afterSprint;
            dev = 0.5 * (devAfterSprint + devAfterHealth);
        } else if (afterSprint < afterHealth) {
            base = afterSprint;
            dev = devAfterSprint;
        } else {
            base = afterHealth;
            dev = devAfterHealth;
        }
        double minSec = Math.max(0.1, base - dev);
        double maxSec = Math.max(minSec, base + dev);
        return new double[]{minSec, maxSec};
    }
}

