/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.breath;

import java.lang.reflect.Constructor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2390;

@Environment(value=EnvType.CLIENT)
public final class VersionChecker {
    private static ConstructorType constructorType;
    private static Constructor<class_2390> constructor;
    private static boolean initialized;

    private VersionChecker() {
    }

    public static String getLastUsedConstructor() {
        if (!initialized) {
            return "not initialized";
        }
        return VersionChecker.getVersionDescription() + " (" + constructorType.name().toLowerCase().replace("_", "+") + ")";
    }

    private static String getVersionDescription() {
        switch (constructorType.ordinal()) {
            case 0: {
                return "1.21.2+";
            }
            case 1: {
                return "1.20.x/early 1.21";
            }
            case 2: {
                return "1.21.1-";
            }
            case 3: {
                return "older mappings";
            }
        }
        return "unknown";
    }

    public static class_2390 make(int rgb, float scale) {
        if (!initialized) {
            VersionChecker.initializeConstructors();
        }
        float clampedScale = Math.max(0.01f, Math.min(4.0f, scale));
        try {
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            switch (constructorType.ordinal()) {
                case 0: {
                    return constructor.newInstance(rgb, Float.valueOf(clampedScale));
                }
                case 1: {
                    return constructor.newInstance(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(clampedScale));
                }
                case 2: 
                case 3: {
                    Object vector = VersionChecker.createVector3f(r, g, b);
                    return constructor.newInstance(vector, Float.valueOf(clampedScale));
                }
            }
            throw new RuntimeException("No compatible DustParticleEffect constructor found");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create DustParticleEffect", e);
        }
    }

    public static class_2390 make(float r, float g, float b, float scale) {
        if (!initialized) {
            VersionChecker.initializeConstructors();
        }
        float clampedScale = Math.max(0.01f, Math.min(4.0f, scale));
        try {
            switch (constructorType.ordinal()) {
                case 0: {
                    int rgb = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                    return constructor.newInstance(rgb, Float.valueOf(clampedScale));
                }
                case 1: {
                    return constructor.newInstance(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(clampedScale));
                }
                case 2: 
                case 3: {
                    Object vector = VersionChecker.createVector3f(r, g, b);
                    return constructor.newInstance(vector, Float.valueOf(clampedScale));
                }
            }
            throw new RuntimeException("No compatible DustParticleEffect constructor found");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create DustParticleEffect", e);
        }
    }

    private static void initializeConstructors() {
        try {
            try {
                constructor = class_2390.class.getConstructor(Integer.TYPE, Float.TYPE);
                constructorType = ConstructorType.INT_FLOAT;
                initialized = true;
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = class_2390.class.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
                    constructorType = ConstructorType.FLOAT_FLOAT_FLOAT;
                    initialized = true;
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        Class<?> jomlVectorClass = Class.forName("org.joml.Vector3f");
                        constructor = class_2390.class.getConstructor(jomlVectorClass, Float.TYPE);
                        constructorType = ConstructorType.JOML_VECTOR;
                        initialized = true;
                        return;
                    }
                    catch (ClassNotFoundException | NoSuchMethodException jomlVectorClass) {
                        try {
                            Class<?> mojangVectorClass = Class.forName("com.mojang.math.Vector3f");
                            constructor = class_2390.class.getConstructor(mojangVectorClass, Float.TYPE);
                            constructorType = ConstructorType.MOJANG_VECTOR;
                            initialized = true;
                            return;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException mojangVectorClass) {
                            throw new RuntimeException("No compatible DustParticleEffect constructors found");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize DustParticleEffect constructors", e);
        }
    }

    private static Object createVector3f(float x, float y, float z) throws Exception {
        if (constructorType == ConstructorType.JOML_VECTOR) {
            Class<?> jomlVectorClass = Class.forName("org.joml.Vector3f");
            return jomlVectorClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        if (constructorType == ConstructorType.MOJANG_VECTOR) {
            Class<?> mojangVectorClass = Class.forName("com.mojang.math.Vector3f");
            return mojangVectorClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        throw new RuntimeException("Vector3f creation not supported for constructor type: " + String.valueOf((Object)constructorType));
    }

    static {
        initialized = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static enum ConstructorType {
        INT_FLOAT,
        FLOAT_FLOAT_FLOAT,
        JOML_VECTOR,
        MOJANG_VECTOR;

    }
}

