/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.debug;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sfdesat.coldbreath.debug.DebugManager;
import com.sfdesat.config.ConfigManager;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

@Environment(value=EnvType.CLIENT)
public final class DebugChat {
    private final DebugManager manager;

    public DebugChat(DebugManager manager) {
        this.manager = manager;
    }

    public void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"coldbreath").then(ClientCommandManager.literal((String)"help").executes(this::sendHelp))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"print").executes(ctx -> this.printAll((FabricClientCommandSource)ctx.getSource()))).then(ClientCommandManager.literal((String)"all").executes(ctx -> this.printAll((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.argument((String)"category", (ArgumentType)StringArgumentType.greedyString()).executes(this::printCategory)))));
    }

    private int sendHelp(CommandContext<FabricClientCommandSource> ctx) {
        FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
        if (!this.ensureCommandsEnabled(source)) {
            return 0;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/coldbreath help - Show this help"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/coldbreath print all - Print all debug information"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/coldbreath print <category> - Print a single debug category"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Available categories:"));
        for (DebugManager.CategoryDescriptor descriptor : this.manager.categoryDescriptors()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(" - " + descriptor.displayName() + " (" + descriptor.key() + ")")));
        }
        return 1;
    }

    private int printAll(FabricClientCommandSource source) {
        if (!this.ensureCommandsEnabled(source)) {
            return 0;
        }
        DebugManager.DebugSnapshot snapshot = this.manager.capture();
        if (snapshot.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"[Cold Breath] No debug data is available right now."));
            return 1;
        }
        for (DebugManager.DebugCategory category : snapshot.categories()) {
            for (DebugManager.DebugLine line : category.lines()) {
                source.sendFeedback(this.toColoredText(line));
            }
        }
        return 1;
    }

    private int printCategory(CommandContext<FabricClientCommandSource> ctx) {
        DebugManager.CategoryDescriptor descriptor;
        FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
        if (!this.ensureCommandsEnabled(source)) {
            return 0;
        }
        String raw = StringArgumentType.getString(ctx, (String)"category");
        String normalized = raw.trim().toLowerCase(Locale.ROOT);
        if (normalized.isEmpty() || "all".equals(normalized)) {
            return this.printAll(source);
        }
        Optional<DebugManager.CategoryDescriptor> descriptorOpt = this.manager.findDescriptor(normalized);
        if (descriptorOpt.isEmpty()) {
            source.sendError((class_2561)class_2561.method_43470((String)("Unknown Cold Breath debug category: " + raw)));
            return 0;
        }
        DebugManager.DebugSnapshot snapshot = this.manager.capture();
        Optional<DebugManager.DebugCategory> categoryOpt = snapshot.getCategory((descriptor = descriptorOpt.get()).key());
        if (categoryOpt.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("[Cold Breath] Debug category '" + descriptor.displayName() + "' is not available right now.")));
            return 1;
        }
        for (DebugManager.DebugLine line : categoryOpt.get().lines()) {
            source.sendFeedback(this.toColoredText(line));
        }
        return 1;
    }

    private class_2561 toColoredText(DebugManager.DebugLine line) {
        class_5250 text = class_2561.method_43470((String)line.text());
        int rgb = line.color() & 0xFFFFFF;
        text.method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)));
        return text;
    }

    private boolean ensureCommandsEnabled(FabricClientCommandSource source) {
        if (ConfigManager.get().debugCommandsEnabled) {
            return true;
        }
        source.sendError((class_2561)class_2561.method_43470((String)"Cold Breath debug commands are disabled in the config."));
        return false;
    }
}

