/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.debug;

import com.sfdesat.ColdBreathMod;
import com.sfdesat.coldbreath.debug.DebugManager;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class DebugHud {
    private final DebugManager manager;
    private boolean incompatibleHudDetected;
    private boolean compatibilityLogged;
    private boolean messageShownForCurrentContext;
    private boolean messagePending;
    private class_638 lastWorld;
    private boolean lastDebugEnabled;

    public DebugHud(DebugManager manager) {
        this.manager = manager;
    }

    public void register() {
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            block13: {
                ColdBreathConfig cfg = ConfigManager.get();
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                boolean debugEnabled = cfg.debugEnabled;
                class_638 currentWorld = client.field_1687;
                if (currentWorld != this.lastWorld) {
                    this.lastWorld = currentWorld;
                    if (this.incompatibleHudDetected && debugEnabled) {
                        this.messageShownForCurrentContext = false;
                        this.messagePending = true;
                    }
                }
                if (!this.lastDebugEnabled && debugEnabled && this.incompatibleHudDetected) {
                    this.messageShownForCurrentContext = false;
                    this.messagePending = true;
                }
                this.lastDebugEnabled = debugEnabled;
                if (this.incompatibleHudDetected) {
                    this.sendCompatibilityMessageIfNeeded(client, debugEnabled);
                    return;
                }
                if (!debugEnabled) {
                    return;
                }
                if (client.field_1772 == null) {
                    return;
                }
                try {
                    DebugManager.DebugSnapshot snapshot = this.manager.capture();
                    if (snapshot.isEmpty()) {
                        return;
                    }
                    int x = 6;
                    int y = 6;
                    int lineHeight = 12;
                    int padding = 10;
                    int bgWidth = 260;
                    int lineCount = snapshot.totalLineCount();
                    if (lineCount <= 0) {
                        return;
                    }
                    int bgHeight = lineCount * lineHeight + padding;
                    int bgColor = 0x66000000;
                    context.method_25294(x - 3, y - 3, x - 3 + bgWidth, y - 3 + bgHeight, bgColor);
                    for (DebugManager.DebugLine line : snapshot.lines()) {
                        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line.text()), x, y, line.color(), false);
                        y += lineHeight;
                    }
                }
                catch (Throwable t) {
                    this.incompatibleHudDetected = true;
                    if (!this.compatibilityLogged) {
                        ColdBreathMod.LOGGER.warn("Cold Breath debug HUD disabled due to a rendering incompatibility", t);
                        this.compatibilityLogged = true;
                    }
                    this.messageShownForCurrentContext = false;
                    if (!debugEnabled) break block13;
                    this.messagePending = true;
                    this.sendCompatibilityMessageIfNeeded(client, debugEnabled);
                }
            }
        });
    }

    private void sendCompatibilityMessageIfNeeded(class_310 client, boolean debugEnabled) {
        if (!this.incompatibleHudDetected || !debugEnabled) {
            return;
        }
        if (this.messageShownForCurrentContext && !this.messagePending) {
            return;
        }
        if (client.field_1724 == null) {
            this.messagePending = true;
            return;
        }
        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Cold Breath] Debug HUD disabled for compatibility. Minecraft 1.21.3 and older do not support the HUD; try the debug commands with /coldbreath help."), false);
        this.messageShownForCurrentContext = true;
        this.messagePending = false;
    }
}

