/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.debug;

import com.sfdesat.coldbreath.breath.BreathController;
import com.sfdesat.coldbreath.breath.EnvModel;
import com.sfdesat.coldbreath.breath.StateBlends;
import com.sfdesat.coldbreath.breath.VersionChecker;
import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonManager;
import com.sfdesat.coldbreath.season.SeasonPhase;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class DebugManager {
    private static final List<CategoryDescriptor> CATEGORY_DESCRIPTORS = List.of(new CategoryDescriptor("visible_breath", "Visible Breath", List.of("breath")), new CategoryDescriptor("interval", "Breathing Interval", List.of()), new CategoryDescriptor("interval_range", "Interval Range", List.of("range", "minmax")), new CategoryDescriptor("temperature", "Temperature", List.of("temp")), new CategoryDescriptor("status", "Status", List.of()), new CategoryDescriptor("breath_condensation", "Breath Condensation", List.of("condensation")), new CategoryDescriptor("time_range", "Daytime", List.of("time", "daytime")), new CategoryDescriptor("dimension", "Dimension", List.of("dim")), new CategoryDescriptor("season", "Season Phase", List.of("phase")), new CategoryDescriptor("season_mod", "Season Mod", List.of("seasonmod", "mod")), new CategoryDescriptor("version", "Version Checker", List.of("version", "ver")));
    private static final Map<String, CategoryDescriptor> DESCRIPTORS_BY_KEY = DebugManager.buildDescriptorIndex();
    private final StateBlends blends;

    public DebugManager(StateBlends blends) {
        this.blends = Objects.requireNonNull(blends, "blends");
    }

    public List<CategoryDescriptor> categoryDescriptors() {
        return CATEGORY_DESCRIPTORS;
    }

    public Optional<CategoryDescriptor> findDescriptor(String aliasOrKey) {
        if (aliasOrKey == null || aliasOrKey.isBlank()) {
            return Optional.empty();
        }
        String normalized = aliasOrKey.trim().toLowerCase(Locale.ROOT);
        CategoryDescriptor byKey = DESCRIPTORS_BY_KEY.get(normalized);
        if (byKey != null) {
            return Optional.of(byKey);
        }
        for (CategoryDescriptor descriptor : CATEGORY_DESCRIPTORS) {
            if (!descriptor.matches(normalized)) continue;
            return Optional.of(descriptor);
        }
        return Optional.empty();
    }

    public DebugSnapshot capture() {
        double maxInt;
        double minInt;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return DebugSnapshot.empty();
        }
        ColdBreathConfig cfg = ConfigManager.get();
        Builder builder = new Builder();
        class_638 world = client.field_1687;
        Object breathingText = "visible breath: unknown";
        int breathingColor = -1;
        if (world != null && client.field_1724 != null) {
            boolean underwater = client.field_1724.method_5869();
            if (underwater && cfg.underwaterEnabled) {
                breathingText = "visible breath: bubbles";
                breathingColor = -11623425;
            } else {
                EnvModel.BreathEligibility eligibility = EnvModel.checkEligibility(world, (class_1657)client.field_1724, cfg);
                if (eligibility.allowed()) {
                    breathingText = "visible breath: yes";
                    breathingColor = -16711936;
                } else {
                    String reason = eligibility.reason() == null ? "unknown" : eligibility.reason();
                    breathingText = "visible breath: no (" + reason + ")";
                    breathingColor = -65536;
                }
            }
        }
        builder.addLine(DebugManager.descriptorFor("visible_breath"), new DebugLine((String)breathingText, breathingColor));
        double baseInterval = BreathController.INSTANCE.getCurrentBaseIntervalSeconds(cfg);
        if (world != null && client.field_1724 != null && client.field_1724.method_5869() && cfg.underwaterEnabled) {
            baseInterval = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
        }
        builder.addLine(DebugManager.descriptorFor("interval"), new DebugLine(String.format(Locale.ROOT, "interval: %.1fs", baseInterval), -1));
        if (world != null && client.field_1724 != null && client.field_1724.method_5869() && cfg.underwaterEnabled) {
            double base = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
            double dev = Math.max(0.0, cfg.underwaterIntervalDeviationSeconds);
            minInt = Math.max(0.1, base - dev);
            maxInt = Math.max(minInt, base + dev);
        } else {
            double[] range = BreathController.INSTANCE.getCurrentIntervalMinMaxSeconds(cfg);
            minInt = range[0];
            maxInt = range[1];
        }
        builder.addLine(DebugManager.descriptorFor("interval_range"), new DebugLine(String.format(Locale.ROOT, "min/max: %.1fs / %.1fs", minInt, maxInt), -1));
        if (world != null && client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            float baseTemp = ((class_1959)world.method_23753(pos).comp_349()).method_8712();
            float effTemp = EnvModel.computeEffectiveTemperature(world, pos, cfg);
            int sea = world.method_8615();
            int alt = pos.method_10264() - sea;
            double seasonModifier = SeasonManager.getTemperatureOffset();
            String tempLine = String.format(Locale.ROOT, "temp: %.3f (base: %.3f), alt: %+d, season: %+.3f", Float.valueOf(effTemp), Float.valueOf(baseTemp), alt, seasonModifier);
            builder.addLine(DebugManager.descriptorFor("temperature"), new DebugLine(tempLine, -1));
        }
        builder.addLine(DebugManager.descriptorFor("status"), new DebugLine(String.format(Locale.ROOT, "status: %s | sprint: %.2f | health: %.2f", this.getDebugState(cfg), this.blends.getSprintBlend(), this.blends.getHealthBlend()), -1));
        if (world != null && client.field_1724 != null) {
            boolean condensationActive;
            long dayTime = world.method_8532() % 24000L;
            boolean inWindow = EnvModel.isWithinDayWindow(dayTime, cfg.breathCondensationStartTick, cfg.breathCondensationEndTick);
            float temp = EnvModel.computeEffectiveTemperature(world, client.field_1724.method_24515(), cfg);
            boolean okTemp = (double)temp > cfg.alwaysBreathTemperature && (double)temp <= cfg.maxBreathCondensationTemperature;
            boolean seasonCondensationEnabled = SeasonManager.isBreathCondensationEnabled(cfg.breathCondensationEnabled);
            boolean bl = condensationActive = seasonCondensationEnabled && inWindow && okTemp;
            String condensationLabel = seasonCondensationEnabled ? (condensationActive ? "true" : "false") : "disabled";
            builder.addLine(DebugManager.descriptorFor("breath_condensation"), new DebugLine("breath condensation: " + condensationLabel, -1));
            String range = String.format(Locale.ROOT, "time: %d | condensation window: %d-%d", dayTime, cfg.breathCondensationStartTick, cfg.breathCondensationEndTick);
            builder.addLine(DebugManager.descriptorFor("time_range"), new DebugLine(range, -1));
        }
        Object dimText = "dim: unknown";
        if (world != null) {
            EnvModel.DimensionKind kind = EnvModel.getDimensionKind(world);
            dimText = "dim: " + kind.name().toLowerCase(Locale.ROOT) + " (" + String.valueOf(world.method_27983().method_29177()) + ")";
        }
        builder.addLine(DebugManager.descriptorFor("dimension"), new DebugLine((String)dimText, -1));
        SeasonPhase phase = SeasonManager.getCurrentPhase();
        String phaseDisplay = phase == SeasonPhase.UNKNOWN ? "none" : phase.displayName();
        builder.addLine(DebugManager.descriptorFor("season"), new DebugLine("season: " + phaseDisplay, -1));
        String seasonModDisplay = SeasonManager.getCurrentMod() == SeasonDetector.SeasonMod.VANILLA ? "none" : SeasonDetector.getDisplayName();
        builder.addLine(DebugManager.descriptorFor("season_mod"), new DebugLine("season mod: " + seasonModDisplay, -1));
        builder.addLine(DebugManager.descriptorFor("version"), new DebugLine("version: " + VersionChecker.getLastUsedConstructor(), -1));
        return builder.isEmpty() ? DebugSnapshot.empty() : builder.build();
    }

    private String getDebugState(ColdBreathConfig cfg) {
        boolean sprintCtrl;
        if (!cfg.sprintingIntervalsEnabled && !cfg.healthBasedBreathingEnabled) {
            return "normal";
        }
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double baseHealth = Math.max(0.1, cfg.lowHealthIntervalSeconds);
        double afterSprint = DebugManager.lerp(baseNormal, baseSprint, cfg.sprintingIntervalsEnabled ? this.blends.getSprintBlend() : 0.0);
        double afterHealth = DebugManager.lerp(baseNormal, baseHealth, cfg.healthBasedBreathingEnabled ? this.blends.getHealthBlend() : 0.0);
        boolean healthCtrl = cfg.healthBasedBreathingEnabled && afterHealth <= afterSprint;
        boolean bl = sprintCtrl = cfg.sprintingIntervalsEnabled && afterSprint < afterHealth;
        if (healthCtrl) {
            if (this.blends.getHealthBlend() >= 0.7) {
                return "critical health";
            }
            if (this.blends.getHealthBlend() >= 0.3) {
                return "low health";
            }
            return "health priority";
        }
        if (sprintCtrl) {
            if (this.blends.getSprintBlend() >= 0.95) {
                return "sprinting";
            }
            if (this.blends.getSprintBlend() <= 0.05) {
                return "normal";
            }
            if (this.blends.getSprintBlend() > this.blends.getPrevSprintBlend() + 1.0E-6) {
                return "building up";
            }
            if (this.blends.getSprintBlend() < this.blends.getPrevSprintBlend() - 1.0E-6) {
                return "building down";
            }
            return "transitional";
        }
        return "normal";
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static CategoryDescriptor descriptorFor(String key) {
        CategoryDescriptor descriptor = DESCRIPTORS_BY_KEY.get(key);
        if (descriptor == null) {
            throw new IllegalArgumentException("Unknown debug category: " + key);
        }
        return descriptor;
    }

    private static Map<String, CategoryDescriptor> buildDescriptorIndex() {
        LinkedHashMap<String, CategoryDescriptor> index = new LinkedHashMap<String, CategoryDescriptor>();
        for (CategoryDescriptor descriptor : CATEGORY_DESCRIPTORS) {
            index.put(descriptor.key(), descriptor);
        }
        return Collections.unmodifiableMap(index);
    }

    @Environment(value=EnvType.CLIENT)
    public record CategoryDescriptor(String key, String displayName, List<String> aliases) {
        public CategoryDescriptor {
            key = Objects.requireNonNull(key, "key").toLowerCase(Locale.ROOT);
            displayName = Objects.requireNonNull(displayName, "displayName");
            ArrayList<String> normalized = new ArrayList<String>();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (alias == null || alias.isBlank()) continue;
                    normalized.add(alias.toLowerCase(Locale.ROOT));
                }
            }
            aliases = Collections.unmodifiableList(normalized);
        }

        private boolean matches(String alias) {
            return this.aliases.contains(alias);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class DebugSnapshot {
        private static final DebugSnapshot EMPTY = new DebugSnapshot(List.of());
        private final List<DebugCategory> categories;
        private final Map<String, DebugCategory> categoriesByKey;
        private final List<DebugLine> flattenedLines;

        private DebugSnapshot(List<DebugCategory> categories) {
            this.categories = List.copyOf(categories);
            LinkedHashMap<String, DebugCategory> byKey = new LinkedHashMap<String, DebugCategory>();
            ArrayList<DebugLine> lines = new ArrayList<DebugLine>();
            for (DebugCategory category : this.categories) {
                byKey.put(category.descriptor().key(), category);
                lines.addAll(category.lines());
            }
            this.categoriesByKey = Collections.unmodifiableMap(byKey);
            this.flattenedLines = Collections.unmodifiableList(lines);
        }

        public static DebugSnapshot empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this.flattenedLines.isEmpty();
        }

        public int totalLineCount() {
            return this.flattenedLines.size();
        }

        public List<DebugLine> lines() {
            return this.flattenedLines;
        }

        public List<DebugCategory> categories() {
            return this.categories;
        }

        public Optional<DebugCategory> getCategory(String key) {
            return Optional.ofNullable(this.categoriesByKey.get(key));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Builder {
        private final LinkedHashMap<String, CategoryAccumulator> lines = new LinkedHashMap();

        private Builder() {
        }

        void addLine(CategoryDescriptor descriptor, DebugLine line) {
            CategoryAccumulator accumulator = this.lines.computeIfAbsent(descriptor.key(), key -> new CategoryAccumulator(descriptor));
            accumulator.lines.add(line);
        }

        boolean isEmpty() {
            return this.lines.isEmpty();
        }

        DebugSnapshot build() {
            ArrayList<DebugCategory> categories = new ArrayList<DebugCategory>();
            for (CategoryAccumulator accumulator : this.lines.values()) {
                categories.add(new DebugCategory(accumulator.descriptor, List.copyOf(accumulator.lines)));
            }
            return new DebugSnapshot(categories);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record DebugLine(String text, int color) {
    }

    @Environment(value=EnvType.CLIENT)
    private static final class CategoryAccumulator {
        private final CategoryDescriptor descriptor;
        private final List<DebugLine> lines = new ArrayList<DebugLine>();

        private CategoryAccumulator(CategoryDescriptor descriptor) {
            this.descriptor = descriptor;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record DebugCategory(CategoryDescriptor descriptor, List<DebugLine> lines) {
        public DebugCategory {
            lines = List.copyOf(lines);
        }
    }
}

