/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.season;

import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonPhase;
import com.sfdesat.coldbreath.season.SereneInput;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class FabricInput {
    private static final Logger LOGGER = LogManager.getLogger((String)"ColdBreath/FabricInput");

    private FabricInput() {
    }

    public static SereneInput.SeasonSnapshot sample(class_638 world, SeasonDetector.SeasonMod mod) {
        if (world == null || mod != SeasonDetector.SeasonMod.FABRIC_SEASONS) {
            return SereneInput.SeasonSnapshot.empty(mod);
        }
        FabricBridge bridge = FabricBridge.INSTANCE;
        SereneInput.SeasonSnapshot snapshot = bridge.sample(world);
        return snapshot != null ? snapshot : SereneInput.SeasonSnapshot.empty(mod);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class FabricBridge {
        private static final FabricBridge INSTANCE = new FabricBridge();
        private final boolean available;
        private final MethodHandle getCurrentSeason;
        private final MethodHandle getTemperature;
        private boolean loggedUnavailable;
        private boolean loggedFailure;

        private FabricBridge() {
            boolean ok;
            MethodHandle seasonMethod = null;
            MethodHandle tempMethod = null;
            try {
                Class<?> fabricSeasons = Class.forName("io.github.lucaargolo.seasons.FabricSeasons");
                Class<?> seasonEnum = Class.forName("io.github.lucaargolo.seasons.utils.Season");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                seasonMethod = lookup.findStatic(fabricSeasons, "getCurrentSeason", MethodType.methodType(seasonEnum, class_1937.class));
                tempMethod = lookup.findVirtual(seasonEnum, "getTemperature", MethodType.methodType(Integer.TYPE));
                ok = true;
            }
            catch (Throwable error) {
                LOGGER.debug("Fabric Seasons API unavailable: {}", (Object)error.toString());
                ok = false;
            }
            this.available = ok;
            this.getCurrentSeason = seasonMethod;
            this.getTemperature = tempMethod;
            this.loggedUnavailable = !ok;
        }

        private SereneInput.SeasonSnapshot sample(class_638 world) {
            if (!this.available) {
                if (!this.loggedUnavailable) {
                    LOGGER.warn("Fabric Seasons API unavailable; using placeholder seasons");
                    this.loggedUnavailable = true;
                }
                return null;
            }
            try {
                String seasonName;
                String string;
                Object seasonObj = this.getCurrentSeason.invoke(world);
                if (seasonObj == null) {
                    return null;
                }
                if (seasonObj instanceof Enum) {
                    Enum enumValue = (Enum)seasonObj;
                    string = enumValue.name();
                } else {
                    string = String.valueOf(seasonObj);
                }
                SeasonPhase phase = switch (seasonName = string) {
                    case "SUMMER" -> SeasonPhase.MID_SUMMER;
                    case "FALL" -> SeasonPhase.MID_AUTUMN;
                    case "WINTER" -> SeasonPhase.MID_WINTER;
                    case "SPRING" -> SeasonPhase.MID_SPRING;
                    default -> SeasonPhase.UNKNOWN;
                };
                double temperatureBias = 0.0;
                if (this.getTemperature != null) {
                    int temperatureIndex = this.getTemperature.invoke(seasonObj);
                    temperatureBias = switch (temperatureIndex) {
                        case 0 -> -0.12;
                        case 1 -> -0.04;
                        case 2 -> 0.05;
                        case 3 -> 0.12;
                        default -> 0.0;
                    };
                }
                return new SereneInput.SeasonSnapshot(SeasonDetector.SeasonMod.FABRIC_SEASONS, phase, temperatureBias, 0, 0);
            }
            catch (Throwable error) {
                if (!this.loggedFailure) {
                    LOGGER.warn("Failed to query Fabric Seasons state: {}", (Object)error.toString());
                    this.loggedFailure = true;
                }
                return null;
            }
        }
    }
}

