/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.season;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public final class SeasonDetector {
    private static SeasonMod detected = SeasonMod.VANILLA;

    private SeasonDetector() {
    }

    public static void init() {
        boolean sereneLoaded = SeasonDetector.isAnyLoaded("sereneseasons", "serene_seasons", "serene-seasons");
        boolean fabricLoaded = SeasonDetector.isAnyLoaded("seasons", "fabricseasons", "fabric-seasons");
        detected = sereneLoaded ? SeasonMod.SERENE_SEASONS : (fabricLoaded ? SeasonMod.FABRIC_SEASONS : SeasonMod.VANILLA);
    }

    public static SeasonMod getDetected() {
        return detected;
    }

    public static String getDisplayName() {
        return switch (detected.ordinal()) {
            case 1 -> "Serene Seasons";
            case 2 -> "Fabric Seasons";
            default -> "Vanilla";
        };
    }

    private static boolean isAnyLoaded(String ... ids) {
        for (String id : ids) {
            if (!FabricLoader.getInstance().isModLoaded(id)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum SeasonMod {
        VANILLA,
        SERENE_SEASONS,
        FABRIC_SEASONS;

    }
}

