/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.season;

import com.sfdesat.coldbreath.season.FabricInput;
import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonPhase;
import com.sfdesat.coldbreath.season.SereneInput;
import com.sfdesat.config.ColdBreathConfig;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class SeasonManager {
    private static final EnumMap<SeasonPhase, SeasonAdjustment> ADJUSTMENTS = new EnumMap(SeasonPhase.class);
    private static boolean seasonsEnabled = true;
    private static boolean sereneSeasonsEnabled = true;
    private static boolean fabricSeasonsEnabled = true;
    private static SereneInput.SeasonSnapshot latest = SereneInput.SeasonSnapshot.empty(SeasonDetector.getDetected());

    private SeasonManager() {
    }

    public static void applyConfig(ColdBreathConfig cfg) {
        cfg.normalizeSeasonConfig();
        seasonsEnabled = cfg.seasonsEnabled;
        sereneSeasonsEnabled = cfg.sereneSeasonsIntegration;
        fabricSeasonsEnabled = cfg.fabricSeasonsIntegration;
        ADJUSTMENTS.clear();
        SeasonPhase[] phases = SeasonPhase.orderedValues();
        for (int i = 0; i < phases.length; ++i) {
            ADJUSTMENTS.put(phases[i], new SeasonAdjustment(cfg.seasonTemperatureOffsets[i], cfg.seasonBreathCondensation[i]));
        }
        if (!seasonsEnabled) {
            latest = SereneInput.SeasonSnapshot.empty(SeasonDetector.SeasonMod.VANILLA);
        }
    }

    public static void refresh(class_638 world) {
        if (!seasonsEnabled) {
            latest = SereneInput.SeasonSnapshot.empty(SeasonDetector.SeasonMod.VANILLA);
            return;
        }
        SeasonDetector.SeasonMod mod = SeasonDetector.getDetected();
        if (mod == SeasonDetector.SeasonMod.SERENE_SEASONS && !sereneSeasonsEnabled) {
            mod = fabricSeasonsEnabled ? SeasonDetector.SeasonMod.FABRIC_SEASONS : SeasonDetector.SeasonMod.VANILLA;
        } else if (mod == SeasonDetector.SeasonMod.FABRIC_SEASONS && !fabricSeasonsEnabled) {
            mod = sereneSeasonsEnabled ? SeasonDetector.SeasonMod.SERENE_SEASONS : SeasonDetector.SeasonMod.VANILLA;
        }
        latest = mod == SeasonDetector.SeasonMod.FABRIC_SEASONS ? FabricInput.sample(world, mod) : SereneInput.sample(world, mod);
    }

    public static double getTemperatureOffset() {
        if (!seasonsEnabled || latest.mod() == SeasonDetector.SeasonMod.VANILLA) {
            return 0.0;
        }
        SeasonAdjustment adjustment = ADJUSTMENTS.getOrDefault((Object)latest.phase(), SeasonAdjustment.DEFAULT);
        return adjustment.temperatureOffset() + latest.temperatureBias();
    }

    public static SeasonPhase getCurrentPhase() {
        return latest.phase();
    }

    public static SeasonDetector.SeasonMod getCurrentMod() {
        return seasonsEnabled ? latest.mod() : SeasonDetector.SeasonMod.VANILLA;
    }

    public static boolean isBreathCondensationEnabled(boolean defaultValue) {
        if (!seasonsEnabled || latest.mod() == SeasonDetector.SeasonMod.VANILLA) {
            return defaultValue;
        }
        SeasonAdjustment adjustment = ADJUSTMENTS.getOrDefault((Object)latest.phase(), SeasonAdjustment.DEFAULT);
        return adjustment.breathCondensationEnabled();
    }

    public static Map<SeasonPhase, SeasonAdjustment> getAdjustmentsView() {
        return Map.copyOf(ADJUSTMENTS);
    }

    public static SereneInput.SeasonSnapshot getSnapshot() {
        return latest;
    }

    static {
        ColdBreathConfig defaults = new ColdBreathConfig();
        defaults.normalizeSeasonConfig();
        SeasonManager.applyConfig(defaults);
    }

    @Environment(value=EnvType.CLIENT)
    public record SeasonAdjustment(double temperatureOffset, boolean breathCondensationEnabled) {
        private static final SeasonAdjustment DEFAULT = new SeasonAdjustment(0.0, true);
    }
}

