/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.season;

import com.sfdesat.coldbreath.season.SeasonDetector;
import com.sfdesat.coldbreath.season.SeasonPhase;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class SereneInput {
    private static final Logger LOGGER = LogManager.getLogger((String)"ColdBreath/SereneInput");

    private SereneInput() {
    }

    public static SeasonSnapshot sample(class_638 world, SeasonDetector.SeasonMod mod) {
        SeasonSnapshot real;
        if (world == null) {
            return SeasonSnapshot.empty(mod);
        }
        if (mod == SeasonDetector.SeasonMod.SERENE_SEASONS && (real = SereneBridge.INSTANCE.sample(world)) != null) {
            return real;
        }
        return SereneInput.placeholder(world, mod);
    }

    private static SeasonSnapshot placeholder(class_638 world, SeasonDetector.SeasonMod mod) {
        if (mod == SeasonDetector.SeasonMod.VANILLA) {
            return SeasonSnapshot.empty(mod);
        }
        long days = world.method_8532() / 24000L;
        int index = Math.floorMod(days, SeasonPhase.orderedValues().length);
        SeasonPhase phase = SeasonPhase.fromOrdinal(index);
        return new SeasonSnapshot(mod, phase, 0.0, 0, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public record SeasonSnapshot(SeasonDetector.SeasonMod mod, SeasonPhase phase, double temperatureBias, int dayInCycle, int cycleTicks) {
        public static SeasonSnapshot empty(SeasonDetector.SeasonMod mod) {
            return new SeasonSnapshot(mod, SeasonPhase.UNKNOWN, 0.0, 0, 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class SereneBridge {
        private static final SereneBridge INSTANCE = new SereneBridge();
        private final boolean available;
        private final MethodHandle getSeasonState;
        private final MethodHandle getSubSeason;
        private final MethodHandle getDay;
        private final MethodHandle getCycleTicks;
        private boolean loggedUnavailable;
        private boolean loggedFailure;

        private SereneBridge() {
            boolean ok;
            MethodHandle seasonState = null;
            MethodHandle subSeason = null;
            MethodHandle day = null;
            MethodHandle cycle = null;
            try {
                Class<?> helper = Class.forName("sereneseasons.api.season.SeasonHelper");
                Class<?> state = Class.forName("sereneseasons.api.season.ISeasonState");
                Class<?> subSeasonType = Class.forName("sereneseasons.api.season.Season$SubSeason");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                seasonState = lookup.findStatic(helper, "getSeasonState", MethodType.methodType(state, class_1937.class));
                subSeason = lookup.findVirtual(state, "getSubSeason", MethodType.methodType(subSeasonType));
                day = lookup.findVirtual(state, "getDay", MethodType.methodType(Integer.TYPE));
                cycle = lookup.findVirtual(state, "getSeasonCycleTicks", MethodType.methodType(Integer.TYPE));
                ok = true;
            }
            catch (Throwable error) {
                LOGGER.debug("Serene Seasons API unavailable: {}", (Object)error.toString());
                ok = false;
            }
            this.available = ok;
            this.getSeasonState = seasonState;
            this.getSubSeason = subSeason;
            this.getDay = day;
            this.getCycleTicks = cycle;
            this.loggedUnavailable = !ok;
        }

        private SeasonSnapshot sample(class_638 world) {
            if (!this.available) {
                if (!this.loggedUnavailable) {
                    LOGGER.warn("Serene Seasons API unavailable; using placeholder seasons");
                    this.loggedUnavailable = true;
                }
                return null;
            }
            try {
                String string;
                Object state = this.getSeasonState.invoke(world);
                if (state == null) {
                    return null;
                }
                Object subSeasonObj = this.getSubSeason.invoke(state);
                if (subSeasonObj instanceof Enum) {
                    Enum enumValue = (Enum)subSeasonObj;
                    string = enumValue.name();
                } else {
                    string = String.valueOf(subSeasonObj);
                }
                String subSeasonName = string;
                SeasonPhase phase = SeasonPhase.fromName(subSeasonName);
                int day = this.getDay.invoke(state);
                int ticks = this.getCycleTicks.invoke(state);
                double bias = switch (phase) {
                    case SeasonPhase.EARLY_WINTER, SeasonPhase.MID_WINTER, SeasonPhase.LATE_WINTER -> -0.15;
                    case SeasonPhase.EARLY_SUMMER, SeasonPhase.MID_SUMMER, SeasonPhase.LATE_SUMMER -> 0.12;
                    default -> 0.0;
                };
                return new SeasonSnapshot(SeasonDetector.SeasonMod.SERENE_SEASONS, phase, bias, day, ticks);
            }
            catch (Throwable error) {
                if (!this.loggedFailure) {
                    LOGGER.warn("Failed to query Serene Seasons state: {}", (Object)error.toString());
                    this.loggedFailure = true;
                }
                return null;
            }
        }
    }
}

