/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.config;

import com.sfdesat.coldbreath.season.SeasonPhase;

public class ColdBreathConfig {
    public boolean enabled = true;
    public boolean visibleInCreative = false;
    public boolean alwaysShowBreath = false;
    public boolean visibleInNether = false;
    public boolean visibleInEnd = true;
    public double baseIntervalSeconds = 5.0;
    public double intervalDeviationSeconds = 1.0;
    public boolean sprintingIntervalsEnabled = true;
    public double sprintBaseIntervalSeconds = 3.0;
    public double sprintIntervalDeviationSeconds = 0.5;
    public double sprintBuildUpSeconds = 8.0;
    public double sprintBuildDownSeconds = 12.0;
    public double forwardOffset = 0.3;
    public double downOffset = 0.2;
    public int breathBurstDurationTicks = 10;
    public int breathColor = 15135487;
    public double breathSize = 0.6;
    public boolean debugEnabled = false;
    public boolean debugCommandsEnabled = true;
    public boolean seasonsEnabled = true;
    public boolean sereneSeasonsIntegration = true;
    public boolean fabricSeasonsIntegration = true;
    public double[] seasonTemperatureOffsets = ColdBreathConfig.defaultTemperatureOffsets();
    public boolean[] seasonBreathCondensation = ColdBreathConfig.defaultBreathCondensation();
    public boolean underwaterEnabled = true;
    public double underwaterBaseIntervalSeconds = 8.0;
    public double underwaterIntervalDeviationSeconds = 1.0;
    public boolean altitudeAdjustmentEnabled = true;
    public double altitudeTemperatureRate = 0.00125;
    public boolean breathCondensationEnabled = true;
    public long breathCondensationStartTick = 22500L;
    public long breathCondensationEndTick = 1500L;
    public double maxBreathCondensationTemperature = 0.7;
    public double alwaysBreathTemperature = 0.15;
    public boolean healthBasedBreathingEnabled = true;
    public double lowHealthIntervalSeconds = 1.0;
    public double healthIntervalDeviationSeconds = 0.2;

    public static double[] defaultTemperatureOffsets() {
        return new double[]{0.02, 0.04, 0.05, 0.08, 0.12, 0.1, 0.02, -0.02, -0.06, -0.1, -0.14, -0.12};
    }

    public static boolean[] defaultBreathCondensation() {
        return new boolean[]{true, true, false, false, false, false, false, true, true, true, true, true};
    }

    public void normalizeSeasonConfig() {
        int i;
        Object[] copy;
        int len = SeasonPhase.orderedValues().length;
        if (this.seasonTemperatureOffsets == null) {
            this.seasonTemperatureOffsets = ColdBreathConfig.defaultTemperatureOffsets();
        } else if (this.seasonTemperatureOffsets.length != len) {
            copy = ColdBreathConfig.defaultTemperatureOffsets();
            for (i = 0; i < Math.min(len, this.seasonTemperatureOffsets.length); ++i) {
                copy[i] = this.seasonTemperatureOffsets[i];
            }
            this.seasonTemperatureOffsets = copy;
        }
        if (this.seasonBreathCondensation == null) {
            this.seasonBreathCondensation = ColdBreathConfig.defaultBreathCondensation();
        } else if (this.seasonBreathCondensation.length != len) {
            copy = ColdBreathConfig.defaultBreathCondensation();
            for (i = 0; i < Math.min(len, this.seasonBreathCondensation.length); ++i) {
                copy[i] = (double)this.seasonBreathCondensation[i];
            }
            this.seasonBreathCondensation = (boolean[])copy;
        }
    }
}

