/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.config;

import com.sfdesat.coldbreath.season.SeasonManager;
import com.sfdesat.coldbreath.season.SeasonPhase;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.ArrayList;
import java.util.Locale;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.LongListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ColdBreathConfigScreen {
    private ColdBreathConfigScreen() {
    }

    public static class_437 create(class_437 parent) {
        ColdBreathConfig cfg = ConfigManager.get();
        cfg.normalizeSeasonConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Cold Breath Config")).setSavingRunnable(() -> {
            cfg.normalizeSeasonConfig();
            SeasonManager.applyConfig(cfg);
            ConfigManager.save();
        });
        ConfigCategory mainCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Main"));
        ConfigCategory breathingCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Breathing"));
        ConfigCategory seasonsCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Seasons"));
        ConfigCategory visualsCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Visuals"));
        ConfigCategory visibilityCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Visibility"));
        ConfigCategory debugCat = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Debug"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        BooleanListEntry enabledEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enabled"), cfg.enabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Master switch for Cold Breath.")}).setSaveConsumer(v -> {
            cfg.enabled = v;
        }).build();
        BooleanListEntry alwaysShowEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Always Show Breath"), cfg.alwaysShowBreath).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, breath appears even in warmer temperatures."), class_2561.method_43470((String)"When off, breath follows the Breath Temperature threshold and condensation window."), class_2561.method_43470((String)"Nether/End visibility is configured in the Visibility tab.")}).setSaveConsumer(v -> {
            cfg.alwaysShowBreath = v;
        }).build();
        BooleanListEntry altitudeToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Altitude Effects"), cfg.altitudeAdjustmentEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, temperature decreases with altitude above sea level."), class_2561.method_43470((String)"This allows breath to show at high altitudes in warmer biomes.")}).setSaveConsumer(v -> {
            cfg.altitudeAdjustmentEnabled = v;
        }).build();
        IntegerSliderEntry altitudeRateEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Altitude Rate"), (int)Math.round(cfg.altitudeTemperatureRate * 100000.0), 0, 1000).setDefaultValue(125).setTextGetter(i -> class_2561.method_43470((String)String.format("%.5f", (double)i.intValue() / 100000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Temperature decrease per block above sea level (0.00000\u20130.01000)."), class_2561.method_43470((String)"Default 0.00125 matches Minecraft's vanilla behavior.")}).setSaveConsumer(i -> {
            cfg.altitudeTemperatureRate = (double)i.intValue() / 100000.0;
        }).build();
        IntegerSliderEntry alwaysBreathTempEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Breath Temperature"), (int)Math.round(cfg.alwaysBreathTemperature * 1000.0), 0, 1000).setDefaultValue(150).setTextGetter(i -> class_2561.method_43470((String)String.format("%.3f", (double)i.intValue() / 1000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Temperature threshold where breath always appears (0.000\u20131.000)."), class_2561.method_43470((String)"Default 0.15 - breath always shows in biomes colder than this.")}).setSaveConsumer(i -> {
            cfg.alwaysBreathTemperature = (double)i.intValue() / 1000.0;
        }).build();
        IntegerSliderEntry baseIntervalEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Base Interval (seconds)"), (int)Math.round(cfg.baseIntervalSeconds * 10.0), 20, 100).setDefaultValue(50).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while not sprinting (2.0\u201310.0 s).")}).setSaveConsumer(i -> {
            cfg.baseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry baseDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Deviation (seconds)"), (int)Math.round(cfg.intervalDeviationSeconds * 10.0), 0, 20).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation added/subtracted from base interval (0.0\u20132.0 s).")}).setSaveConsumer(i -> {
            cfg.intervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        mainCat.addEntry((AbstractConfigListEntry)enabledEntry);
        mainCat.addEntry((AbstractConfigListEntry)alwaysShowEntry);
        mainCat.addEntry((AbstractConfigListEntry)altitudeToggleEntry);
        mainCat.addEntry((AbstractConfigListEntry)altitudeRateEntry);
        mainCat.addEntry((AbstractConfigListEntry)alwaysBreathTempEntry);
        mainCat.addEntry((AbstractConfigListEntry)baseIntervalEntry);
        mainCat.addEntry((AbstractConfigListEntry)baseDevEntry);
        BooleanListEntry sprintToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Sprinting Interval"), cfg.sprintingIntervalsEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Use separate timing while sprinting, with smooth ramp in/out.")}).setSaveConsumer(v -> {
            cfg.sprintingIntervalsEnabled = v;
        }).build();
        IntegerSliderEntry sprintBaseEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Base Interval (seconds)"), (int)Math.round(cfg.sprintBaseIntervalSeconds * 10.0), 10, 80).setDefaultValue(30).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while sprinting (1.0\u20138.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Deviation (seconds)"), (int)Math.round(cfg.sprintIntervalDeviationSeconds * 10.0), 0, 10).setDefaultValue(5).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation while sprinting (0.0\u20131.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintUpEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-up (seconds)"), (int)Math.round(cfg.sprintBuildUpSeconds * 10.0), 0, 300).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from normal to sprint cadence (0.0\u201330.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildUpSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDownEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-down (seconds)"), (int)Math.round(cfg.sprintBuildDownSeconds * 10.0), 0, 300).setDefaultValue(120).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from sprint back to normal (0.0\u201330.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildDownSeconds = (double)i.intValue() / 10.0;
        }).build();
        ArrayList<Object> sprintEntries = new ArrayList<Object>();
        sprintEntries.add(sprintToggleEntry);
        sprintEntries.add(sprintBaseEntry);
        sprintEntries.add(sprintDevEntry);
        sprintEntries.add(sprintUpEntry);
        sprintEntries.add(sprintDownEntry);
        SubCategoryListEntry sprintSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Sprinting"), sprintEntries).build();
        breathingCat.addEntry((AbstractConfigListEntry)sprintSub);
        BooleanListEntry condensationToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Breath Condensation"), cfg.breathCondensationEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable visible breath condensation during cool time windows."), class_2561.method_43470((String)"Breath will appear in moderate temperatures during the configured condensation window.")}).setSaveConsumer(v -> {
            cfg.breathCondensationEnabled = v;
        }).build();
        LongListEntry condensationStartEntry = eb.startLongField((class_2561)class_2561.method_43470((String)"Condensation Start (ticks)"), cfg.breathCondensationStartTick).setDefaultValue(22500L).setMin(0L).setMax(23999L).setTooltip(new class_2561[]{class_2561.method_43470((String)"Start of the breath condensation window (0-23999 ticks)."), class_2561.method_43470((String)"Default 22500 - condensation begins at this time.")}).setSaveConsumer(v -> {
            cfg.breathCondensationStartTick = v;
        }).build();
        LongListEntry condensationEndEntry = eb.startLongField((class_2561)class_2561.method_43470((String)"Condensation End (ticks)"), cfg.breathCondensationEndTick).setDefaultValue(1500L).setMin(0L).setMax(23999L).setTooltip(new class_2561[]{class_2561.method_43470((String)"End of the breath condensation window (0-23999 ticks)."), class_2561.method_43470((String)"Default 1500 - condensation stops at this time.")}).setSaveConsumer(v -> {
            cfg.breathCondensationEndTick = v;
        }).build();
        IntegerSliderEntry maxCondensationTempEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Max Condensation Temperature"), (int)Math.round(cfg.maxBreathCondensationTemperature * 1000.0), 0, 1000).setDefaultValue(700).setTextGetter(i -> class_2561.method_43470((String)String.format("%.3f", (double)i.intValue() / 1000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Maximum temperature for breath condensation (0.000\u20131.000)."), class_2561.method_43470((String)"Default 0.7 - condensation appears between always-breath temp and this value.")}).setSaveConsumer(i -> {
            cfg.maxBreathCondensationTemperature = (double)i.intValue() / 1000.0;
        }).build();
        ArrayList<Object> condensationEntries = new ArrayList<Object>();
        condensationEntries.add(condensationToggleEntry);
        condensationEntries.add(condensationStartEntry);
        condensationEntries.add(condensationEndEntry);
        condensationEntries.add(maxCondensationTempEntry);
        SubCategoryListEntry condensationSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Breath Condensation"), condensationEntries).build();
        breathingCat.addEntry((AbstractConfigListEntry)condensationSub);
        BooleanListEntry healthBreathingToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Health-based Breathing"), cfg.healthBasedBreathingEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable breathing intervals that change based on player health."), class_2561.method_43470((String)"Players will breathe faster when they have lower health.")}).setSaveConsumer(v -> {
            cfg.healthBasedBreathingEnabled = v;
        }).build();
        IntegerSliderEntry lowHealthIntervalEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Low Health Interval (seconds)"), (int)Math.round(cfg.lowHealthIntervalSeconds * 10.0), 5, 20).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Breathing interval when at 0 hearts (0.5\u20132.0 s)."), class_2561.method_43470((String)"Default 1.0 - fast breathing when critically injured.")}).setSaveConsumer(i -> {
            cfg.lowHealthIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry healthDeviationEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Health Interval Deviation (seconds)"), (int)Math.round(cfg.healthIntervalDeviationSeconds * 10.0), 0, 10).setDefaultValue(2).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation for health breathing (0.0\u20131.0 s)."), class_2561.method_43470((String)"Default 0.5 - allows min ~0.5 s and max ~2.0 s around 1.0 s base.")}).setSaveConsumer(i -> {
            cfg.healthIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        ArrayList<Object> healthEntries = new ArrayList<Object>();
        healthEntries.add(healthBreathingToggleEntry);
        healthEntries.add(lowHealthIntervalEntry);
        healthEntries.add(healthDeviationEntry);
        SubCategoryListEntry healthSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Health-based"), healthEntries).build();
        breathingCat.addEntry((AbstractConfigListEntry)healthSub);
        DoubleListEntry forwardEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Forward Offset"), cfg.forwardOffset).setDefaultValue(0.3).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters in front of the player head to spawn particles.")}).setSaveConsumer(v -> {
            cfg.forwardOffset = v;
        }).build();
        DoubleListEntry downEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Down Offset"), cfg.downOffset).setDefaultValue(0.2).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters below the player head to spawn particles.")}).setSaveConsumer(v -> {
            cfg.downOffset = v;
        }).build();
        IntegerListEntry burstEntry = eb.startIntField((class_2561)class_2561.method_43470((String)"Burst Duration (ticks)"), cfg.breathBurstDurationTicks).setDefaultValue(10).setMin(1).setTooltip(new class_2561[]{class_2561.method_43470((String)"How long a breath burst continues spawning particles (ticks).")}).setSaveConsumer(v -> {
            cfg.breathBurstDurationTicks = v;
        }).build();
        String currentHex = String.format("#%06X", 0xFFFFFF & cfg.breathColor);
        StringListEntry colorEntry = eb.startStrField((class_2561)class_2561.method_43470((String)"Breath Color (hex)"), currentHex).setDefaultValue("#E6F2FF").setTooltip(new class_2561[]{class_2561.method_43470((String)"RGB hex for breath particles. Accepts #RRGGBB, 0xRRGGBB, or RRGGBB.")}).setSaveConsumer(str -> {
            if (str == null) {
                return;
            }
            String s = str.trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
            }
            if (s.length() == 6) {
                try {
                    int rgb;
                    cfg.breathColor = rgb = Integer.parseInt(s, 16) & 0xFFFFFF;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }).build();
        DoubleListEntry sizeEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Breath Size"), cfg.breathSize).setDefaultValue(0.6).setMin(0.1).setTooltip(new class_2561[]{class_2561.method_43470((String)"Particle scale for breath particles (min 0.1).")}).setSaveConsumer(v -> {
            cfg.breathSize = v;
        }).build();
        visualsCat.addEntry((AbstractConfigListEntry)forwardEntry);
        visualsCat.addEntry((AbstractConfigListEntry)downEntry);
        visualsCat.addEntry((AbstractConfigListEntry)burstEntry);
        visualsCat.addEntry((AbstractConfigListEntry)colorEntry);
        visualsCat.addEntry((AbstractConfigListEntry)sizeEntry);
        BooleanListEntry seasonsToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Seasons"), cfg.seasonsEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Master switch for seasonal temperature and condensation adjustments."), class_2561.method_43470((String)"Requires a supported season mod for live data; otherwise uses simple cycling.")}).setSaveConsumer(v -> {
            cfg.seasonsEnabled = v;
        }).build();
        BooleanListEntry sereneToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Input Serene Seasons"), cfg.sereneSeasonsIntegration).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"When enabled and Serene Seasons is installed, use its data for season-aware adjustments.")}).setSaveConsumer(v -> {
            cfg.sereneSeasonsIntegration = v;
        }).build();
        SeasonPhase[] phases = SeasonPhase.orderedValues();
        double[] defaultTemps = ColdBreathConfig.defaultTemperatureOffsets();
        boolean[] defaultCondensation = ColdBreathConfig.defaultBreathCondensation();
        ArrayList<DoubleListEntry> perSeasonTempEntries = new ArrayList<DoubleListEntry>();
        ArrayList<BooleanListEntry> perSeasonCondensationEntries = new ArrayList<BooleanListEntry>();
        for (int i2 = 0; i2 < phases.length; ++i2) {
            int index = i2;
            SeasonPhase phase = phases[index];
            String display = phase.displayName();
            String label = display.isEmpty() ? "Subseason " + (index + 1) : display.substring(0, 1).toUpperCase(Locale.ROOT) + display.substring(1);
            DoubleListEntry tempEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)(label + " Temperature Offset")), cfg.seasonTemperatureOffsets[index]).setDefaultValue(defaultTemps[index]).setTooltip(new class_2561[]{class_2561.method_43470((String)("Adjust the effective temperature during " + display + "."))}).setMin(-1.0).setMax(1.0).setSaveConsumer(v -> {
                cfg.seasonTemperatureOffsets[index] = v;
            }).build();
            BooleanListEntry condensationEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)(label + " Breath Condensation")), cfg.seasonBreathCondensation[index]).setDefaultValue(defaultCondensation[index]).setTooltip(new class_2561[]{class_2561.method_43470((String)("Enable breath condensation effects during " + display + "."))}).setSaveConsumer(v -> {
                cfg.seasonBreathCondensation[index] = v;
            }).build();
            perSeasonTempEntries.add(tempEntry);
            perSeasonCondensationEntries.add(condensationEntry);
        }
        SubCategoryListEntry perSeasonTempSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Season Temperature"), perSeasonTempEntries).build();
        SubCategoryListEntry perSeasonCondensationSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Season Breath Condensation"), perSeasonCondensationEntries).build();
        seasonsCat.addEntry((AbstractConfigListEntry)seasonsToggle);
        seasonsCat.addEntry((AbstractConfigListEntry)sereneToggle);
        BooleanListEntry fabricSeasonsToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Input Fabric Seasons"), cfg.fabricSeasonsIntegration).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"When enabled and Fabric Seasons is installed, use its data for season-aware adjustments.")}).setSaveConsumer(v -> {
            cfg.fabricSeasonsIntegration = v;
        }).build();
        seasonsCat.addEntry((AbstractConfigListEntry)fabricSeasonsToggle);
        seasonsCat.addEntry((AbstractConfigListEntry)perSeasonTempSub);
        seasonsCat.addEntry((AbstractConfigListEntry)perSeasonCondensationSub);
        BooleanListEntry uwToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Underwater Breaths"), cfg.underwaterEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show bubble breaths when underwater (has air bar).")}).setSaveConsumer(v -> {
            cfg.underwaterEnabled = v;
        }).build();
        IntegerSliderEntry uwBase = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Base Interval (seconds)"), (int)Math.round(cfg.underwaterBaseIntervalSeconds * 10.0), 40, 200).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between bubble breaths underwater (4.0\u201320.0 s).")}).setSaveConsumer(i -> {
            cfg.underwaterBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry uwDev = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Deviation (seconds)"), (int)Math.round(cfg.underwaterIntervalDeviationSeconds * 10.0), 0, 40).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation for underwater breaths (0.0\u20134.0 s).")}).setSaveConsumer(i -> {
            cfg.underwaterIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        ArrayList<Object> underwaterEntries = new ArrayList<Object>();
        underwaterEntries.add(uwToggle);
        underwaterEntries.add(uwBase);
        underwaterEntries.add(uwDev);
        SubCategoryListEntry underwaterSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Underwater"), underwaterEntries).build();
        breathingCat.addEntry((AbstractConfigListEntry)underwaterSub);
        BooleanListEntry visibleCreativeEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Creative"), cfg.visibleInCreative).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in Creative mode.")}).setSaveConsumer(v -> {
            cfg.visibleInCreative = v;
        }).build();
        BooleanListEntry visibleNetherEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Nether"), cfg.visibleInNether).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the Nether.")}).setSaveConsumer(v -> {
            cfg.visibleInNether = v;
        }).build();
        BooleanListEntry visibleEndEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in End"), cfg.visibleInEnd).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the End.")}).setSaveConsumer(v -> {
            cfg.visibleInEnd = v;
        }).build();
        visibilityCat.addEntry((AbstractConfigListEntry)visibleCreativeEntry);
        visibilityCat.addEntry((AbstractConfigListEntry)visibleNetherEntry);
        visibilityCat.addEntry((AbstractConfigListEntry)visibleEndEntry);
        BooleanListEntry debugEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Debug Overlay"), cfg.debugEnabled).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show on-screen state and sprint blend values."), class_2561.method_43470((String)"Requires Minecraft 1.21.4 or newer; older versions should use /coldbreath commands.")}).setSaveConsumer(v -> {
            cfg.debugEnabled = v;
        }).build();
        debugCat.addEntry((AbstractConfigListEntry)debugEntry);
        BooleanListEntry debugCommandsEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Debug Commands"), cfg.debugCommandsEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Allow the /coldbreath client commands.")}).setSaveConsumer(v -> {
            cfg.debugCommandsEnabled = v;
        }).build();
        debugCat.addEntry((AbstractConfigListEntry)debugCommandsEntry);
        return builder.build();
    }
}

