/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.config;

import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import java.util.ArrayList;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.LongListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ColdBreathConfigScreen {
    private ColdBreathConfigScreen() {
    }

    public static class_437 create(class_437 parent) {
        ColdBreathConfig cfg = ConfigManager.get();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Cold Breath Config")).setSavingRunnable(ConfigManager::save);
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Cold Breath"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        BooleanListEntry enabledEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enabled"), cfg.enabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Master switch for Cold Breath.")}).setSaveConsumer(v -> {
            cfg.enabled = v;
        }).build();
        BooleanListEntry onlyColdEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Only in Cold Temperatures"), cfg.onlyInColdBiomes).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, breaths only appear in cold areas and during morning hours."), class_2561.method_43470((String)"Cold areas: temperature <= Always Breath Temperature threshold."), class_2561.method_43470((String)"Morning hours: configurable time window with morning breath settings."), class_2561.method_43470((String)"Nether/End visibility is controlled below.")}).setSaveConsumer(v -> {
            cfg.onlyInColdBiomes = v;
        }).build();
        BooleanListEntry altitudeToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Altitude Adjustment"), cfg.altitudeAdjustmentEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, temperature decreases with altitude above sea level."), class_2561.method_43470((String)"This allows cold breath to appear at high altitudes in warmer biomes.")}).setSaveConsumer(v -> {
            cfg.altitudeAdjustmentEnabled = v;
        }).build();
        IntegerSliderEntry altitudeRateEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Altitude Temperature Rate"), (int)Math.round(cfg.altitudeTemperatureRate * 100000.0), 0, 1000).setDefaultValue(125).setTextGetter(i -> class_2561.method_43470((String)String.format("%.5f", (double)i.intValue() / 100000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Temperature decrease per block above sea level (0.00000\u20130.01000)."), class_2561.method_43470((String)"Default 0.00125 matches Minecraft's vanilla behavior.")}).setSaveConsumer(i -> {
            cfg.altitudeTemperatureRate = (double)i.intValue() / 100000.0;
        }).build();
        IntegerSliderEntry alwaysBreathTempEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Always Breath Temperature"), (int)Math.round(cfg.alwaysBreathTemperature * 1000.0), 0, 1000).setDefaultValue(150).setTextGetter(i -> class_2561.method_43470((String)String.format("%.3f", (double)i.intValue() / 1000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Temperature threshold where breath always appears (0.000\u20131.000)."), class_2561.method_43470((String)"Default 0.15 - breath will always show in cold biomes below this temperature.")}).setSaveConsumer(i -> {
            cfg.alwaysBreathTemperature = (double)i.intValue() / 1000.0;
        }).build();
        IntegerSliderEntry baseIntervalEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Base Interval (seconds)"), (int)Math.round(cfg.baseIntervalSeconds * 10.0), 20, 100).setDefaultValue(50).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while not sprinting (2.0\u201310.0 s).")}).setSaveConsumer(i -> {
            cfg.baseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry baseDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Deviation (seconds)"), (int)Math.round(cfg.intervalDeviationSeconds * 10.0), 0, 20).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation added/subtracted from base interval (0.0\u20132.0 s).")}).setSaveConsumer(i -> {
            cfg.intervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        general.addEntry((AbstractConfigListEntry)enabledEntry);
        general.addEntry((AbstractConfigListEntry)onlyColdEntry);
        general.addEntry((AbstractConfigListEntry)altitudeToggleEntry);
        general.addEntry((AbstractConfigListEntry)altitudeRateEntry);
        general.addEntry((AbstractConfigListEntry)alwaysBreathTempEntry);
        general.addEntry((AbstractConfigListEntry)baseIntervalEntry);
        general.addEntry((AbstractConfigListEntry)baseDevEntry);
        BooleanListEntry sprintToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Sprinting-specific Intervals"), cfg.sprintingIntervalsEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Use separate timing while sprinting, with smooth ramp in/out.")}).setSaveConsumer(v -> {
            cfg.sprintingIntervalsEnabled = v;
        }).build();
        IntegerSliderEntry sprintBaseEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Base Interval (seconds)"), (int)Math.round(cfg.sprintBaseIntervalSeconds * 10.0), 10, 80).setDefaultValue(30).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between breaths while sprinting (1.0\u20138.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDevEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprinting Deviation (seconds)"), (int)Math.round(cfg.sprintIntervalDeviationSeconds * 10.0), 0, 10).setDefaultValue(5).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation while sprinting (0.0\u20131.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintUpEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-up (seconds)"), (int)Math.round(cfg.sprintBuildUpSeconds * 10.0), 0, 300).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from normal to sprint cadence (0.0\u201330.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildUpSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry sprintDownEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Sprint Build-down (seconds)"), (int)Math.round(cfg.sprintBuildDownSeconds * 10.0), 0, 300).setDefaultValue(120).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Time to ramp from sprint back to normal (0.0\u201330.0 s).")}).setSaveConsumer(i -> {
            cfg.sprintBuildDownSeconds = (double)i.intValue() / 10.0;
        }).build();
        ArrayList<Object> sprintEntries = new ArrayList<Object>();
        sprintEntries.add(sprintToggleEntry);
        sprintEntries.add(sprintBaseEntry);
        sprintEntries.add(sprintDevEntry);
        sprintEntries.add(sprintUpEntry);
        sprintEntries.add(sprintDownEntry);
        SubCategoryListEntry sprintSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Sprinting"), sprintEntries).build();
        BooleanListEntry morningBreathToggleEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Morning Breath"), cfg.morningBreathEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable morning breath during early morning hours."), class_2561.method_43470((String)"Breath will appear in moderate temperatures during the configured time window.")}).setSaveConsumer(v -> {
            cfg.morningBreathEnabled = v;
        }).build();
        LongListEntry morningBreathStartEntry = eb.startLongField((class_2561)class_2561.method_43470((String)"Morning Breath Start (ticks)"), cfg.morningBreathStartTick).setDefaultValue(22500L).setMin(0L).setMax(23999L).setTooltip(new class_2561[]{class_2561.method_43470((String)"Start of morning breath time window (0-23999 ticks)."), class_2561.method_43470((String)"Default 22500 - breath starts appearing at this time.")}).setSaveConsumer(v -> {
            cfg.morningBreathStartTick = v;
        }).build();
        LongListEntry morningBreathEndEntry = eb.startLongField((class_2561)class_2561.method_43470((String)"Morning Breath End (ticks)"), cfg.morningBreathEndTick).setDefaultValue(1500L).setMin(0L).setMax(23999L).setTooltip(new class_2561[]{class_2561.method_43470((String)"End of morning breath time window (0-23999 ticks)."), class_2561.method_43470((String)"Default 1500 - breath stops appearing at this time.")}).setSaveConsumer(v -> {
            cfg.morningBreathEndTick = v;
        }).build();
        IntegerSliderEntry maxMorningBreathTempEntry = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Max Morning Breath Temperature"), (int)Math.round(cfg.maxMorningBreathTemperature * 1000.0), 0, 1000).setDefaultValue(700).setTextGetter(i -> class_2561.method_43470((String)String.format("%.3f", (double)i.intValue() / 1000.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Maximum temperature for morning breath (0.000\u20131.000)."), class_2561.method_43470((String)"Default 0.7 - morning breath appears between always-breath temp and this value.")}).setSaveConsumer(i -> {
            cfg.maxMorningBreathTemperature = (double)i.intValue() / 1000.0;
        }).build();
        ArrayList<Object> morningBreathEntries = new ArrayList<Object>();
        morningBreathEntries.add(morningBreathToggleEntry);
        morningBreathEntries.add(morningBreathStartEntry);
        morningBreathEntries.add(morningBreathEndEntry);
        morningBreathEntries.add(maxMorningBreathTempEntry);
        SubCategoryListEntry morningBreathSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Morning Breath"), morningBreathEntries).build();
        DoubleListEntry forwardEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Forward Offset"), cfg.forwardOffset).setDefaultValue(0.3).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters in front of the player head to spawn particles.")}).setSaveConsumer(v -> {
            cfg.forwardOffset = v;
        }).build();
        DoubleListEntry downEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Down Offset"), cfg.downOffset).setDefaultValue(0.2).setMin(0.0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Meters below the player head to spawn particles.")}).setSaveConsumer(v -> {
            cfg.downOffset = v;
        }).build();
        IntegerListEntry burstEntry = eb.startIntField((class_2561)class_2561.method_43470((String)"Burst Duration (ticks)"), cfg.breathBurstDurationTicks).setDefaultValue(10).setMin(1).setTooltip(new class_2561[]{class_2561.method_43470((String)"How long a breath burst continues spawning particles (ticks).")}).setSaveConsumer(v -> {
            cfg.breathBurstDurationTicks = v;
        }).build();
        String currentHex = String.format("#%06X", 0xFFFFFF & cfg.breathColor);
        StringListEntry colorEntry = eb.startStrField((class_2561)class_2561.method_43470((String)"Breath Color (hex)"), currentHex).setDefaultValue("#E6F2FF").setTooltip(new class_2561[]{class_2561.method_43470((String)"RGB hex for breath particles. Accepts #RRGGBB, 0xRRGGBB, or RRGGBB.")}).setSaveConsumer(str -> {
            if (str == null) {
                return;
            }
            String s = str.trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
            }
            if (s.length() == 6) {
                try {
                    int rgb;
                    cfg.breathColor = rgb = Integer.parseInt(s, 16) & 0xFFFFFF;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }).build();
        DoubleListEntry sizeEntry = eb.startDoubleField((class_2561)class_2561.method_43470((String)"Breath Size"), cfg.breathSize).setDefaultValue(0.6).setMin(0.1).setTooltip(new class_2561[]{class_2561.method_43470((String)"Particle scale for breath particles (min 0.1).")}).setSaveConsumer(v -> {
            cfg.breathSize = v;
        }).build();
        ArrayList<Object> visualEntries = new ArrayList<Object>();
        visualEntries.add(forwardEntry);
        visualEntries.add(downEntry);
        visualEntries.add(burstEntry);
        visualEntries.add(colorEntry);
        visualEntries.add(sizeEntry);
        SubCategoryListEntry visualsSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Visuals"), visualEntries).build();
        BooleanListEntry uwToggle = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Underwater Breaths"), cfg.underwaterEnabled).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show bubble breaths when underwater (has air bar).")}).setSaveConsumer(v -> {
            cfg.underwaterEnabled = v;
        }).build();
        IntegerSliderEntry uwBase = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Base Interval (seconds)"), (int)Math.round(cfg.underwaterBaseIntervalSeconds * 10.0), 40, 200).setDefaultValue(80).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Average delay between bubble breaths underwater (4.0\u201320.0 s).")}).setSaveConsumer(i -> {
            cfg.underwaterBaseIntervalSeconds = (double)i.intValue() / 10.0;
        }).build();
        IntegerSliderEntry uwDev = eb.startIntSlider((class_2561)class_2561.method_43470((String)"Underwater Deviation (seconds)"), (int)Math.round(cfg.underwaterIntervalDeviationSeconds * 10.0), 0, 40).setDefaultValue(10).setTextGetter(i -> class_2561.method_43470((String)String.format("%.1f s", (double)i.intValue() / 10.0))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Random variation for underwater breaths (0.0\u20134.0 s).")}).setSaveConsumer(i -> {
            cfg.underwaterIntervalDeviationSeconds = (double)i.intValue() / 10.0;
        }).build();
        ArrayList<Object> uwEntries = new ArrayList<Object>();
        uwEntries.add(uwToggle);
        uwEntries.add(uwBase);
        uwEntries.add(uwDev);
        SubCategoryListEntry underwaterSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Underwater"), uwEntries).build();
        BooleanListEntry visibleCreativeEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Creative"), cfg.visibleInCreative).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in Creative mode.")}).setSaveConsumer(v -> {
            cfg.visibleInCreative = v;
        }).build();
        BooleanListEntry visibleNetherEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in Nether"), cfg.visibleInNether).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the Nether.")}).setSaveConsumer(v -> {
            cfg.visibleInNether = v;
        }).build();
        BooleanListEntry visibleEndEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Visible in End"), cfg.visibleInEnd).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show breaths while in the End.")}).setSaveConsumer(v -> {
            cfg.visibleInEnd = v;
        }).build();
        ArrayList<BooleanListEntry> dimensionsEntries = new ArrayList<BooleanListEntry>();
        dimensionsEntries.add(visibleCreativeEntry);
        dimensionsEntries.add(visibleNetherEntry);
        dimensionsEntries.add(visibleEndEntry);
        SubCategoryListEntry dimensionsSub = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Visibility"), dimensionsEntries).build();
        BooleanListEntry debugEntry = eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Debug Overlay"), cfg.debugEnabled).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show on-screen state and sprint blend values.")}).setSaveConsumer(v -> {
            cfg.debugEnabled = v;
        }).build();
        general.addEntry((AbstractConfigListEntry)sprintSub);
        general.addEntry((AbstractConfigListEntry)morningBreathSub);
        general.addEntry((AbstractConfigListEntry)underwaterSub);
        general.addEntry((AbstractConfigListEntry)visualsSub);
        general.addEntry((AbstractConfigListEntry)dimensionsSub);
        general.addEntry((AbstractConfigListEntry)debugEntry);
        return builder.build();
    }
}

